/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.util;

import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.perm.PermNodes;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class AfkService {
    private final Map<UUID, State> state = new ConcurrentHashMap<UUID, State>();
    private MEConfig cfg;
    private final PlayerDataStore pdata;

    public AfkService(MEConfig cfg, PlayerDataStore pdata) {
        this.cfg = Objects.requireNonNull(cfg, "config");
        this.pdata = Objects.requireNonNull(pdata, "player data");
    }

    public void reloadPools() {
        this.cfg = MEConfig.INSTANCE != null ? MEConfig.INSTANCE : this.cfg;
    }

    public void markActiveMovement(ServerPlayer p) {
        this.markActive(p, false);
    }

    public void markActiveInteraction(ServerPlayer p) {
        this.markActive(p, false);
    }

    public void markActiveChat(ServerPlayer p) {
        this.markActive(p, true);
    }

    public void onJoin(ServerPlayer p) {
        State s = this.state.computeIfAbsent(p.getUUID(), k -> new State());
        s.lastActiveMs = System.currentTimeMillis();
    }

    public void onQuit(UUID id) {
        this.state.remove(id);
    }

    public boolean toggleAfk(ServerPlayer p, String message) {
        State s = this.state.computeIfAbsent(p.getUUID(), k -> new State());
        if (s.afk) {
            this.exitAfk(p, s, false);
            return false;
        }
        if (message != null && !message.isBlank() && Perms.has(p, "messentials.afk.message.set", 0)) {
            this.pdata.setAfkMessage(p.getUUID(), message);
        }
        this.enterAfk(p, s, true);
        return true;
    }

    public void tick(MinecraftServer server) {
        long nowMs = System.currentTimeMillis();
        long nowSec = nowMs / 1000L;
        ArrayList players = new ArrayList(server.getPlayerList().getPlayers());
        for (ServerPlayer p : players) {
            long afkFor;
            State s = this.state.computeIfAbsent(p.getUUID(), k -> new State());
            if (!(s.afk || !this.cfg.afk.enabled || this.cfg.afk.respectExemptPermission && Perms.has(p, "messentials.afk.exempt", 2) || this.cfg.afk.respectAutoEnablePermission && !Perms.has(p, "messentials.afk.autoenable", 0) || nowMs - s.lastActiveMs < (long)this.cfg.afk.autoAfkSeconds * 1000L)) {
                this.enterAfk(p, s, true);
            }
            if (!s.afk) continue;
            MEConfig.AfkPool pool = this.poolOf(s.poolName);
            if (pool != null) {
                if (!this.isInsidePool(p, pool)) {
                    this.exitAfk(p, s, true);
                    continue;
                }
                if (pool.rewards != null) {
                    for (MEConfig.AfkReward tr : pool.rewards) {
                        long due;
                        if (tr == null || tr.id == null || tr.id.isBlank() || tr.everySeconds <= 0 || nowSec < (due = s.nextRewardAtEpochSec.getOrDefault(tr.id, Long.MAX_VALUE).longValue())) continue;
                        this.giveRewards(server, p, tr);
                        s.nextRewardAtEpochSec.put(tr.id, nowSec + (long)tr.everySeconds);
                    }
                }
            }
            if (this.cfg.afk.idleKickSeconds <= 0 || Perms.has(p, "messentials.afk.kickbypass", 2) || (afkFor = s.afkSinceMs > 0L ? nowMs - s.afkSinceMs : 0L) / 1000L < (long)this.cfg.afk.idleKickSeconds) continue;
            p.connection.disconnect((Component)Component.literal((String)this.cfg.afk.idleKickReason));
        }
    }

    private void markActive(ServerPlayer p, boolean isChat) {
        MEConfig.AfkPool pool;
        State s = this.state.computeIfAbsent(p.getUUID(), k -> new State());
        long now = System.currentTimeMillis();
        if (s.afk && isChat && (pool = this.poolOf(s.poolName)) != null && pool.allowChatInside) {
            s.lastActiveMs = now;
            return;
        }
        s.lastActiveMs = now;
    }

    private void enterAfk(ServerPlayer p, State s, boolean teleportToPool) {
        if (s.afk) {
            return;
        }
        s.afk = true;
        s.afkSinceMs = System.currentTimeMillis();
        PlayerDataStore.LastLoc loc = new PlayerDataStore.LastLoc();
        loc.dim = AfkService.dimKey(p).location().toString();
        Vec3 pos = p.position();
        loc.x = pos.x;
        loc.y = pos.y;
        loc.z = pos.z;
        loc.yaw = p.getYRot();
        loc.pitch = p.getXRot();
        loc.when = System.currentTimeMillis();
        this.pdata.setAfkReturnLoc(p.getUUID(), loc);
        if (teleportToPool) {
            for (Map.Entry<String, MEConfig.AfkPool> e : this.cfg.afk.pools.entrySet()) {
                String name = e.getKey();
                MEConfig.AfkPool pool = e.getValue();
                if (pool == null || !pool.enabled || pool.requirePermission && !Perms.has(p, PermNodes.afkPoolNode(name), 0)) continue;
                if (!this.teleport(p, pool.teleport)) break;
                s.poolName = name;
                s.nextRewardAtEpochSec.clear();
                long nowSec = System.currentTimeMillis() / 1000L;
                if (pool.rewards == null) break;
                for (MEConfig.AfkReward tr : pool.rewards) {
                    if (tr == null || tr.id == null || tr.id.isBlank() || tr.everySeconds <= 0) continue;
                    s.nextRewardAtEpochSec.put(tr.id, nowSec + (long)tr.everySeconds);
                }
            }
        }
    }

    private void exitAfk(ServerPlayer p, State s, boolean leftArea) {
        if (!s.afk) {
            return;
        }
        s.afk = false;
        s.poolName = null;
        s.nextRewardAtEpochSec.clear();
        s.afkSinceMs = 0L;
        this.teleportBackOrFallback(p);
        this.pdata.clearAfkMessage(p.getUUID());
        this.pdata.clearAfkReturnLoc(p.getUUID());
    }

    private void teleportBackOrFallback(ServerPlayer p) {
        Optional<PlayerDataStore.LastLoc> back = this.pdata.getAfkReturnLoc(p.getUUID());
        if (back.isPresent()) {
            PlayerDataStore.LastLoc l = back.get();
            TeleportPoint tp = new TeleportPoint(l.dim, l.x, l.y, l.z, l.yaw, l.pitch);
            if (this.teleport(p, tp)) {
                return;
            }
        }
        this.teleport(p, this.cfg.afk.fallback);
    }

    private boolean teleport(ServerPlayer p, MEConfig.TeleportPoint t) {
        try {
            ResourceLocation dimRl = ResourceLocation.tryParse((String)t.world);
            if (dimRl == null) {
                return false;
            }
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimRl);
            ServerLevel level = p.server.getLevel(key);
            if (level == null) {
                return false;
            }
            p.teleportTo(level, t.x, t.y, t.z, t.yaw, t.pitch);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private boolean isInsidePool(ServerPlayer p, MEConfig.AfkPool pool) {
        if (pool == null || pool.region == null || pool.region.world == null) {
            return false;
        }
        String curWorld = AfkService.dimKey(p).location().toString();
        if (!pool.region.world.equalsIgnoreCase(curWorld)) {
            return false;
        }
        Vec3 pos = p.position();
        int x = (int)Math.floor(pos.x);
        int y = (int)Math.floor(pos.y);
        int z = (int)Math.floor(pos.z);
        int minX = Math.min(pool.region.min.x, pool.region.max.x);
        int minY = Math.min(pool.region.min.y, pool.region.max.y);
        int minZ = Math.min(pool.region.min.z, pool.region.max.z);
        int maxX = Math.max(pool.region.min.x, pool.region.max.x);
        int maxY = Math.max(pool.region.min.y, pool.region.max.y);
        int maxZ = Math.max(pool.region.min.z, pool.region.max.z);
        return x >= minX && x <= maxX && y >= minY && y <= maxY && z >= minZ && z <= maxZ;
    }

    private MEConfig.AfkPool poolOf(String name) {
        if (name == null) {
            return null;
        }
        return this.cfg.afk.pools.get(name);
    }

    private static ResourceKey<Level> dimKey(ServerPlayer p) {
        return p.level().dimension();
    }

    private void giveRewards(MinecraftServer server, ServerPlayer p, MEConfig.AfkReward tr) {
        if (tr.commands != null) {
            for (String raw : tr.commands) {
                if (raw == null || raw.isBlank()) continue;
                String cmd = raw.replace("%player%", p.getGameProfile().getName());
                server.getCommands().performPrefixedCommand(server.createCommandSourceStack().withPermission(4), cmd);
            }
        }
        if (tr.items != null) {
            for (MEConfig.ItemSpec it : tr.items) {
                boolean added;
                ItemStack stack;
                if (it == null || it.type == null || it.type.isBlank() || it.amount <= 0 || (stack = this.makeItem(it)).isEmpty() || (added = p.getInventory().add(stack))) continue;
                p.drop(stack, false);
            }
        }
    }

    private ItemStack makeItem(MEConfig.ItemSpec it) {
        try {
            ResourceLocation rl = ResourceLocation.tryParse((String)it.type);
            Optional oi = BuiltInRegistries.ITEM.getOptional(rl);
            if (oi.isEmpty()) {
                return ItemStack.EMPTY;
            }
            ItemStack st = new ItemStack((ItemLike)oi.get(), Math.max(1, it.amount));
            String nbt = it.nbt == null || it.nbt.isBlank() ? "{}" : it.nbt;
            try {
                st.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)TagParser.parseTag((String)nbt)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return st;
        }
        catch (Exception e) {
            return ItemStack.EMPTY;
        }
    }

    public boolean isAfk(UUID id) {
        State s = this.state.get(id);
        return s != null && s.afk;
    }

    public Optional<String> currentAfkMessage(UUID id) {
        return this.pdata.getAfkMessage(id).filter(msg -> !msg.isBlank());
    }

    public String formatNotify(String senderName, String targetName, String message) {
        String fmt = this.cfg.afk.notifyFormat == null || this.cfg.afk.notifyFormat.isBlank() ? "<gray><sender> \u2192 <target>: <msg>" : this.cfg.afk.notifyFormat;
        return fmt.replace("<sender>", senderName).replace("<target>", targetName).replace("<msg>", message);
    }

    private static final class State {
        boolean afk = false;
        String poolName = null;
        long lastActiveMs = System.currentTimeMillis();
        long afkSinceMs = 0L;
        final Map<String, Long> nextRewardAtEpochSec = new HashMap<String, Long>();

        private State() {
        }
    }

    private static final class TeleportPoint
    extends MEConfig.TeleportPoint {
        TeleportPoint(String world, double x, double y, double z, float yaw, float pitch) {
            super(world, x, y, z, yaw, pitch);
        }
    }
}

