/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DurationUtil {
    private static final Pattern P = Pattern.compile("(\\d+)([smhdw])", 2);

    private DurationUtil() {
    }

    public static long parseToMillis(String s) {
        if (s == null || s.isBlank()) {
            return 0L;
        }
        long ms = 0L;
        Matcher m = P.matcher(s);
        while (m.find()) {
            long v = Long.parseLong(m.group(1));
            switch (Character.toLowerCase(m.group(2).charAt(0))) {
                case 's': {
                    ms += v * 1000L;
                    break;
                }
                case 'm': {
                    ms += v * 60000L;
                    break;
                }
                case 'h': {
                    ms += v * 3600000L;
                    break;
                }
                case 'd': {
                    ms += v * 86400000L;
                    break;
                }
                case 'w': {
                    ms += v * 604800000L;
                }
            }
        }
        return ms;
    }

    public static String fmtRemaining(long ms) {
        if (ms <= 0L) {
            return "0s";
        }
        long s = ms / 1000L;
        long w = s / 604800L;
        long d = (s %= 604800L) / 86400L;
        long h = (s %= 86400L) / 3600L;
        long m = (s %= 3600L) / 60L;
        s %= 60L;
        StringBuilder b = new StringBuilder();
        if (w > 0L) {
            b.append(w).append("w ");
        }
        if (d > 0L) {
            b.append(d).append("d ");
        }
        if (h > 0L) {
            b.append(h).append("h ");
        }
        if (m > 0L) {
            b.append(m).append("m ");
        }
        if (s > 0L) {
            b.append(s).append("s");
        }
        return b.toString().trim();
    }
}

