/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.util;

import com.alphine.mysticessentials.config.MEConfig;
import java.util.Map;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.minecraft.server.level.ServerPlayer;

public final class HomeLimitResolver {
    private HomeLimitResolver() {
    }

    public static int resolve(ServerPlayer p) {
        User user;
        int cap;
        MEConfig cfg = MEConfig.INSTANCE;
        if (cfg == null) {
            return 1;
        }
        String base = cfg.permissions != null && cfg.permissions.homesMultipleBase != null && !cfg.permissions.homesMultipleBase.isBlank() ? cfg.permissions.homesMultipleBase : "messentials.home.multiple";
        for (int n = cap = Math.max(1, cfg.homes.numericCap <= 0 ? 64 : cfg.homes.numericCap); n >= 1; --n) {
            if (!HomeLimitResolver.has(p, base + "." + n)) continue;
            return n;
        }
        int best = cfg.homes.defaultHomes;
        for (Map.Entry<String, Integer> e : cfg.homes.groups.entrySet()) {
            int val;
            String group = e.getKey();
            int n = val = e.getValue() == null ? cfg.homes.defaultHomes : e.getValue();
            if (!HomeLimitResolver.has(p, base + "." + group) || val <= best) continue;
            best = val;
        }
        if (cfg.features.useLuckPermsHomeLimits && HomeLimitResolver.lpAvailable() && (user = LuckPermsProvider.get().getUserManager().getUser(p.getUUID())) != null) {
            for (Node node : user.getNodes()) {
                String name;
                Integer mapped;
                String key = node.getKey();
                if (!key.startsWith("group.") || (mapped = cfg.homes.groups.get(name = key.substring("group.".length()))) == null || mapped <= best) continue;
                best = mapped;
            }
        }
        return best > 0 ? best : cfg.homes.defaultHomes;
    }

    private static boolean has(ServerPlayer p, String perm) {
        try {
            LuckPerms lp;
            User user;
            if (HomeLimitResolver.lpAvailable() && (user = (lp = LuckPermsProvider.get()).getUserManager().getUser(p.getUUID())) != null && user.getCachedData().getPermissionData().checkPermission(perm).asBoolean()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return p.hasPermissions(2);
    }

    private static boolean lpAvailable() {
        try {
            LuckPermsProvider.get();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

