/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel;

import com.google.gson.annotations.Expose;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import org.ginafro.notenoughfakepixel.NotEnoughFakepixel;
import org.ginafro.notenoughfakepixel.alerts.AlertManagementGui;
import org.ginafro.notenoughfakepixel.config.features.Accessories;
import org.ginafro.notenoughfakepixel.config.features.ChocolateFactory;
import org.ginafro.notenoughfakepixel.config.features.Crimson;
import org.ginafro.notenoughfakepixel.config.features.Debug;
import org.ginafro.notenoughfakepixel.config.features.DianaF;
import org.ginafro.notenoughfakepixel.config.features.Dungeons;
import org.ginafro.notenoughfakepixel.config.features.Experimentation;
import org.ginafro.notenoughfakepixel.config.features.Fishing;
import org.ginafro.notenoughfakepixel.config.features.Mining;
import org.ginafro.notenoughfakepixel.config.features.Misc;
import org.ginafro.notenoughfakepixel.config.features.Overlays;
import org.ginafro.notenoughfakepixel.config.features.QualityOfLife;
import org.ginafro.notenoughfakepixel.config.features.Slayer;
import org.ginafro.notenoughfakepixel.config.features.SlotLocking;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.config.gui.config.ConfigEditor;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiElement;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiScreenElementWrapper;
import org.ginafro.notenoughfakepixel.config.gui.core.config.Position;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.Category;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiPositionEditor;
import org.ginafro.notenoughfakepixel.events.handlers.RepoHandler;
import org.ginafro.notenoughfakepixel.features.capes.gui.CapeGui;
import org.ginafro.notenoughfakepixel.features.duels.Duels;
import org.ginafro.notenoughfakepixel.features.duels.KDCounter;
import org.ginafro.notenoughfakepixel.features.mlf.Info;
import org.ginafro.notenoughfakepixel.features.mlf.Map;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.terminals.TerminalSimulator;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.CrystalHollowsMap;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.WormSpawnTimer;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.stats.PositionEditorScreen;
import org.ginafro.notenoughfakepixel.features.skyblock.qol.customaliases.AliasManagementGui;
import org.ginafro.notenoughfakepixel.serverdata.SkyblockData;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.Logger;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;

public class Configuration {
    @Expose
    @Category(name="Quality of Life", desc="Quality of Life settings.")
    public QualityOfLife qol = new QualityOfLife();
    @Expose
    @Category(name="Dungeons", desc="Dungeons settings.")
    public Dungeons dungeons = new Dungeons();
    @Expose
    @Category(name="Diana", desc="Diana settings.")
    public DianaF diana = new DianaF();
    @Expose
    @Category(name="Slayer", desc="Slayer settings.")
    public Slayer slayer = new Slayer();
    @Expose
    @Category(name="Experimentation Table", desc="Experimentation Table settings.")
    public Experimentation experimentation = new Experimentation();
    @Expose
    @Category(name="Chocolate Factory", desc="Chocolate Factory settings.")
    public ChocolateFactory chocolateFactory = new ChocolateFactory();
    @Expose
    @Category(name="Crimson", desc="Crimson settings.")
    public Crimson crimson = new Crimson();
    @Expose
    @Category(name="Mining", desc="Mining settings.")
    public Mining mining = new Mining();
    @Expose
    @Category(name="Fishing", desc="Fishing settings.")
    public Fishing fishing = new Fishing();
    @Expose
    @Category(name="My Little Farm", desc="Mlf settings.")
    public Info mlf = new Info();
    @Expose
    @Category(name="Slot Locking", desc="Slot Locking Settings")
    public SlotLocking sl = new SlotLocking();
    @Expose
    @Category(name="Duels", desc="Duels settings.")
    public Duels duels = new Duels();
    @Expose
    @Category(name="Misc", desc="Misc features.")
    public Misc misc = new Misc();
    @Expose
    @Category(name="Overlays", desc="GUI Overlays")
    public Overlays overlays = new Overlays();
    @Expose
    @Category(name="Accessories", desc="Accessories settings.")
    public Accessories accessories = new Accessories();
    @Expose
    @Category(name="Debug", desc="Debug settings.")
    public Debug debug = new Debug();

    private void editOverlay(String activeConfig, int width, int height, Position position) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPositionEditor(position, width, height, () -> {}, () -> {}, () -> {
            Config.screenToOpen = new GuiScreenElementWrapper(new ConfigEditor(Config.feature, activeConfig));
        }));
    }

    public void executeRunnable(String runnableId) {
        String data;
        Position tempPosition;
        String activeConfigCategory = null;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiScreenElementWrapper) {
            GuiScreenElementWrapper wrapper = (GuiScreenElementWrapper)Minecraft.func_71410_x().field_71462_r;
            GuiElement element = wrapper.element;
            if (element instanceof ConfigEditor) {
                activeConfigCategory = ((ConfigEditor)element).getSelectedCategoryName();
            }
        }
        if ("editAshfangPosition".equals(runnableId)) {
            this.editOverlay(activeConfigCategory, 100, 20, Config.feature.crimson.ashfangOverlayPos);
        }
        if ("editDungeonsMapPosition".equals(runnableId)) {
            this.editOverlay(activeConfigCategory, 128, 128, Config.feature.dungeons.dungeonsMapPos);
        }
        if ("editMlfInfoPosition".equals(runnableId)) {
            tempPosition = new Position((int)Config.feature.mlf.mlfInfoOffsetX, (int)Config.feature.mlf.mlfInfoOffsetY);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPositionEditor(tempPosition, 35, 60, () -> new Map().renderDummy(), () -> {
                ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
                Config.feature.mlf.mlfInfoOffsetX = tempPosition.getAbsX(sr, 35);
                Config.feature.mlf.mlfInfoOffsetY = tempPosition.getAbsY(sr, 60);
            }, () -> {}));
        }
        if ("editKdCounterPosition".equals(runnableId)) {
            tempPosition = new Position((int)Config.feature.duels.kdCounterOffsetX, (int)Config.feature.duels.kdCounterOffsetY);
            KDCounter kdCounter = new KDCounter();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPositionEditor(tempPosition, (int)kdCounter.getWidth(), (int)kdCounter.getHeight(), kdCounter::renderDummy, () -> {
                ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
                Config.feature.duels.kdCounterOffsetX = tempPosition.getAbsX(sr, (int)kdCounter.getWidth());
                Config.feature.duels.kdCounterOffsetY = tempPosition.getAbsY(sr, (int)kdCounter.getHeight());
            }, () -> {}));
        }
        if ("editScoreOverlayPosition".equals(runnableId)) {
            this.editOverlay(activeConfigCategory, 150, 115, Config.feature.dungeons.scoreOverlayPos);
        }
        if ("resetItemValues".equals(runnableId)) {
            Config.feature.qol.resetItemValues();
        }
        if ("editSlayerOverlayPosition".equals(runnableId)) {
            this.editOverlay(activeConfigCategory, 100, 20, Config.feature.slayer.slayerBossHPPos);
        }
        if ("nefAlerts".equals(runnableId)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new AlertManagementGui());
        }
        if ("nefAlias".equals(runnableId)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new AliasManagementGui());
        }
        if ("termSim".equals(runnableId)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new TerminalSimulator());
        }
        if ("slotReset".equals(runnableId)) {
            NotEnoughFakepixel.resetLockedSlots();
        }
        if ("nefCapes".equals(runnableId)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new CapeGui());
        }
        if ("editTerminalTrackerPosition".equals(runnableId)) {
            this.editOverlay(activeConfigCategory, 150, 60, Config.feature.dungeons.terminalTrackerPos);
        }
        if ("editWarpHelperPosition".equals(runnableId)) {
            this.editOverlay(activeConfigCategory, 100, 30, Config.feature.diana.warpHelperPos);
        }
        if ("nefButtons".equals(runnableId)) {
            // empty if block
        }
        if ("editCrystalHollowsMapPos".equals(runnableId)) {
            int width = Config.feature.mining.miningCrystalMapWidth + CrystalHollowsMap.getMARGIN_PX() * 2;
            this.editOverlay(activeConfigCategory, width, width, Config.feature.mining.crystalMapPos);
        }
        if ("editScavengedOverlayPos".equals(runnableId)) {
            int width = (int)Math.abs(170.0f * Config.feature.mining.scavengedOverlayScale);
            int height = (int)Math.abs(44.0f * Config.feature.mining.scavengedOverlayScale);
            this.editOverlay(activeConfigCategory, width, height, Config.feature.mining.scavengedOverlayPos);
        }
        if ("editAutomatonOverlayPos".equals(runnableId)) {
            int width = (int)Math.abs(170.0f * Config.feature.mining.automatonOverlayScale);
            int height = (int)Math.abs(66.0f * Config.feature.mining.automatonOverlayScale);
            this.editOverlay(activeConfigCategory, width, height, Config.feature.mining.automatonOverlayPos);
        }
        if ("editWormTimerPos".equals(runnableId)) {
            this.editOverlay(activeConfigCategory, (int)Math.abs(38.0f * Config.feature.mining.wormTimerScale), (int)Math.abs(9.0f * Config.feature.mining.wormTimerScale), Config.feature.mining.wormTimerPos);
        }
        if ("editEggTimerPos".equals(runnableId)) {
            this.editOverlay(activeConfigCategory, (int)Math.abs(38.0f * Config.feature.chocolateFactory.eggTimerScale), (int)Math.abs(9.0f * Config.feature.chocolateFactory.eggTimerScale), Config.feature.chocolateFactory.eggTimerPos);
        }
        if ("editDarkAHTimerPos".equals(runnableId)) {
            this.editOverlay(activeConfigCategory, (int)Math.abs(38.0f * Config.feature.qol.darkAHTimerScale), (int)Math.abs(9.0f * Config.feature.qol.darkAHTimerScale), Config.feature.qol.darkAhTimerPos);
        }
        if ("logLocation".equals(runnableId)) {
            Logger.log((Object)TablistParser.currentLocation);
        }
        if ("logScoreboard".equals(runnableId)) {
            ScoreboardUtils.getScoreboardLines().forEach(Logger::log);
        }
        if ("logIsInSkyblock".equals(runnableId)) {
            Logger.log("Current Gamemode: " + (Object)((Object)ScoreboardUtils.currentGamemode) + " | Is in Skyblock: " + ScoreboardUtils.currentGamemode.isSkyblock());
        }
        if ("statEditor".equals(runnableId)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new PositionEditorScreen());
        }
        if ("showAPI".equals(runnableId) && (data = RepoHandler.getJson("fairysouls")) != null) {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new StringSelection(data), null);
            Logger.log("Copied API to clipboard! Length: " + data.length());
        }
        if ("showSBID".equals(runnableId)) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                ItemStack item = player.func_70694_bm();
                if (item != null) {
                    Logger.log(ItemUtils.getInternalName(item));
                } else {
                    Logger.logError("No Held Item");
                }
            } else {
                Logger.logError("No Player");
            }
        }
        if ("triggerTimers".equals(runnableId)) {
            WormSpawnTimer.setGoalEpochMs(System.currentTimeMillis() + 30000L);
            Logger.log("Set worm spawn to 30 seconds from now");
        }
        if ("logSeason".equals(runnableId)) {
            Logger.log("Current Season: " + (Object)((Object)SkyblockData.getSeason()));
        }
    }

    public static boolean isPojav() {
        return Config.feature.debug.forcePojav || System.getProperty("os.name").contains("Android") || System.getProperty("os.name").contains("Linux");
    }
}

