/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.alerts.Alerts;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.ModEventRegistrar;
import org.ginafro.notenoughfakepixel.events.handlers.RepoHandler;
import org.ginafro.notenoughfakepixel.features.cosmetics.CosmeticsManager;
import org.ginafro.notenoughfakepixel.features.cosmetics.impl.Bandana;
import org.ginafro.notenoughfakepixel.features.cosmetics.loader.OBJLoader;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.treasure.TreasureTriangulator;
import org.ginafro.notenoughfakepixel.features.skyblock.mining.crystalhollows.waypoints.CrystalWaypoints;
import org.ginafro.notenoughfakepixel.features.skyblock.overlays.inventory.equipment.EquipmentOverlay;
import org.ginafro.notenoughfakepixel.features.skyblock.qol.customaliases.CustomAliases;
import org.ginafro.notenoughfakepixel.features.skyblock.slotlocking.SlotLocking;
import org.ginafro.notenoughfakepixel.nefrepo.NefRepo;
import org.ginafro.notenoughfakepixel.utils.Utils;

@Mod(modid="notenoughfakepixel", useMetadata=true)
public class NotEnoughFakepixel {
    public static NotEnoughFakepixel instance;
    public static final File nefFolder;
    private final Utils utils = new Utils();
    public static File storageDirectory;
    private OBJLoader objLoader;
    public static GuiScreen openGui;
    public static long lastOpenedGui;
    public static String th;

    public void registerCosmetics() {
        CosmeticsManager.registerCosmetics(new Bandana());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.objLoader = new OBJLoader();
        this.createDirectoryIfNotExists(Config.configDirectory);
        Config.init();
        Runtime.getRuntime().addShutdownHook(new Thread(Config::saveConfig));
        EquipmentOverlay.loadData();
        Alerts.load();
        ModEventRegistrar.registerModEvents();
        ModEventRegistrar.registerKeybinds();
        ModEventRegistrar.registerCommands();
        SlotLocking.getInstance().loadConfig(new File(Config.configDirectory, "slotlocking.json"));
        NefRepo.init();
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdownHook, "Shutdown Hook"));
        CrystalWaypoints.getInstance().load();
    }

    private void createDirectoryIfNotExists(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    private void shutdownHook() {
        RepoHandler.shutdown();
        TreasureTriangulator.getInstance().shutdown();
        try {
            CrystalWaypoints.getInstance().saveIfDirty();
            SlotLocking.getInstance().saveConfig();
            CustomAliases.save();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void resetLockedSlots() {
        SlotLocking.getInstance().resetSlotLocking();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            openGui = null;
            return;
        }
        if (openGui != null) {
            if (mc.field_71439_g.field_71070_bA != null) {
                mc.field_71439_g.func_71053_j();
            }
            mc.func_147108_a(openGui);
            openGui = null;
            lastOpenedGui = System.currentTimeMillis();
        }
    }

    public Utils getUtils() {
        return this.utils;
    }

    public OBJLoader getObjLoader() {
        return this.objLoader;
    }

    static {
        nefFolder = new File(Minecraft.func_71410_x().field_71412_D, "NotEnoughFakepixel");
        storageDirectory = new File("config/Notenoughfakepixel/storage");
        th = "default";
    }
}

