/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.alerts;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;

@RegisterEvents
public class Alerts {
    public static List<Alert> alerts = new ArrayList<Alert>();
    public static HashMap<Alert, Pattern> patterns = new HashMap();
    public static String configFile = Config.configDirectory + "/nefalerts.json";
    private static String displayText = "";
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static long endTime = 0L;

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent event) {
        if (event.type == 2) {
            return;
        }
        String message = StringUtils.func_76338_a((String)event.message.func_150260_c());
        block18: for (Alert alert : alerts) {
            boolean trigger;
            boolean location;
            if (!alert.toggled) continue;
            switch (alert.location) {
                case "Skyblock": {
                    location = ScoreboardUtils.currentGamemode.isSkyblock();
                    break;
                }
                case "Dungeons": {
                    location = TablistParser.currentLocation.isDungeon();
                    break;
                }
                default: {
                    location = true;
                }
            }
            if (!location) continue;
            String alertText = alert.alert;
            if (alert.mode.equals("Regex")) {
                Matcher matcher = patterns.get(alert).matcher(message);
                if (!matcher.matches()) continue;
                matcher.reset();
                int i = 0;
                while (matcher.find()) {
                    for (int j = 0; j <= matcher.groupCount(); ++j) {
                        alertText = alertText.replace("$$" + i + "$$", matcher.group(j));
                        ++i;
                    }
                }
                SoundUtils.playSound(Alerts.mc.field_71439_g.func_180425_c(), "note.pling", 2.0f, 2.0f);
                this.showCustomOverlay(EnumChatFormatting.RED + alertText.replace("&", "\u00a7"), 2000);
                return;
            }
            switch (alert.mode) {
                case "Starts With": {
                    trigger = message.startsWith(alert.message);
                    break;
                }
                case "Contains": {
                    trigger = message.contains(alert.message);
                    break;
                }
                case "Ends With": {
                    trigger = message.endsWith(alert.message);
                    break;
                }
                default: {
                    continue block18;
                }
            }
            if (!trigger) continue;
            SoundUtils.playSound(Alerts.mc.field_71439_g.func_180425_c(), "note.pling", 2.0f, 2.0f);
            this.showCustomOverlay(EnumChatFormatting.RED + alertText.replace("&", "\u00a7"), 2000);
            return;
        }
    }

    private void showCustomOverlay(String text, int durationMillis) {
        displayText = text;
        endTime = System.currentTimeMillis() + (long)durationMillis;
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        if (System.currentTimeMillis() > endTime) {
            return;
        }
        FontRenderer fr = Alerts.mc.field_71466_p;
        int screenWidth = event.resolution.func_78326_a();
        int screenHeight = event.resolution.func_78328_b();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)6.0f, (float)6.0f, (float)6.0f);
        int textWidth = fr.func_78256_a(displayText);
        int x = screenWidth / 12 - textWidth / 2;
        int y = screenHeight / 12 - 15;
        fr.func_175063_a(displayText, (float)x, (float)y, 0xFF5555);
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Alerts.mc.field_71441_e == null) {
            displayText = "";
        }
    }

    public static void save() {
        for (Alert alert : alerts) {
            if (!alert.mode.equals("Regex")) continue;
            Pattern pattern = Pattern.compile(alert.message);
            patterns.put(alert, pattern);
        }
        try (FileWriter writer = new FileWriter(configFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson(alerts, (Appendable)writer);
            writer.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void load() {
        File file = new File(configFile);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                List loadedAlerts = (List)new GsonBuilder().create().fromJson((Reader)reader, new TypeToken<List<Alert>>(){}.getType());
                if (loadedAlerts != null) {
                    alerts.clear();
                    alerts.addAll(loadedAlerts);
                    for (Alert alert : alerts) {
                        if (!alert.mode.equals("Regex")) continue;
                        Pattern pattern = Pattern.compile(alert.message);
                        patterns.put(alert, pattern);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.out.println("Failed to load alerts from " + configFile);
            }
        } else {
            System.out.println("No alerts file found at " + configFile + ", starting with empty list");
        }
    }

    public static class Alert {
        public String mode;
        public String location;
        public String message;
        public String alert;
        public boolean toggled;

        public Alert(String mode, String location, String message, String alert, boolean toggled) {
            this.mode = mode;
            this.location = location;
            this.message = message;
            this.alert = alert;
            this.toggled = toggled;
        }

        public void toggle() {
            this.toggled = !this.toggled;
        }
    }
}

