/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.config.ConfigEditor;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiScreenElementWrapper;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterKeybind;
import org.ginafro.notenoughfakepixel.features.skyblock.slotlocking.SlotLocking;

@RegisterEvents
public class Config {
    public static Configuration feature;
    private static File configFile;
    public static File configDirectory;
    private static final Gson gson;
    @RegisterKeybind
    public static final KeyBinding openGuiKey;
    public static GuiScreen screenToOpen;
    private static int screenTicks;

    public static void init() {
        configFile = new File(configDirectory, "config.json");
        Config.loadConfig();
    }

    private static void loadConfig() {
        if (configFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                feature = (Configuration)gson.fromJson((Reader)reader, Configuration.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (feature == null) {
            feature = new Configuration();
            Config.saveConfig();
        }
    }

    public static void saveConfig() {
        try {
            configFile.createNewFile();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(configFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                writer.write(gson.toJson((Object)feature));
                SlotLocking.getInstance().saveConfig();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (screenToOpen != null && ++screenTicks == 5) {
            Minecraft.func_71410_x().func_147108_a(screenToOpen);
            screenTicks = 0;
            screenToOpen = null;
        }
        if (openGuiKey.func_151468_f() && Minecraft.func_71410_x().field_71462_r == null) {
            screenToOpen = new GuiScreenElementWrapper(new ConfigEditor(feature));
        }
    }

    static {
        configDirectory = new File("config/Notenoughfakepixel");
        gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
        openGuiKey = new KeyBinding("Open GUI", 25, "NotEnoughFakepixel");
        screenToOpen = null;
        screenTicks = 0;
    }
}

