/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.config;

import com.google.common.collect.Lists;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.config.gui.GuiTextures;
import org.ginafro.notenoughfakepixel.config.gui.core.GlScissorStack;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiElement;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiElementTextField;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditor;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorAccordion;
import org.ginafro.notenoughfakepixel.config.gui.core.config.struct.ConfigProcessor;
import org.ginafro.notenoughfakepixel.config.gui.core.util.lerp.LerpUtils;
import org.ginafro.notenoughfakepixel.config.gui.core.util.lerp.LerpingInteger;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.RenderUtils;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.TextRenderUtils;
import org.ginafro.notenoughfakepixel.utils.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ConfigEditor
extends GuiElement {
    private static final ResourceLocation[] socialsIco = new ResourceLocation[]{GuiTextures.DISCORD, GuiTextures.GITHUB};
    private static final String[] socialsLink = new String[]{"https://discord.gg/DKrMTQugev", "https://github.com/davidbelesp/NotEnoughFakepixel"};
    private static final ResourceLocation SEARCH_ICON = new ResourceLocation("notenoughfakepixel:search.png");
    public static ConfigEditor editor = new ConfigEditor(Config.feature);
    private final long openedMillis;
    private final LerpingInteger optionsScroll = new LerpingInteger(0, 150);
    private final LerpingInteger categoryScroll = new LerpingInteger(0, 150);
    private final LinkedHashMap<String, ConfigProcessor.ProcessedCategory> processedConfig;
    private final TreeMap<String, Set<ConfigProcessor.ProcessedOption>> searchOptionMap = new TreeMap();
    private final HashMap<ConfigProcessor.ProcessedOption, ConfigProcessor.ProcessedCategory> categoryForOption = new HashMap();
    private final LerpingInteger minimumSearchSize = new LerpingInteger(0, 150);
    private final GuiElementTextField searchField = new GuiElementTextField("", 0, 20, 0);
    private String selectedCategory = null;
    private Set<ConfigProcessor.ProcessedCategory> searchedCategories = null;
    private Map<ConfigProcessor.ProcessedCategory, Set<Integer>> searchedAccordions = null;
    private Set<ConfigProcessor.ProcessedOption> searchedOptions = null;
    private float optionsBarStart;
    private float optionsBarend;
    private int lastMouseX = 0;
    private int keyboardScrollXCutoff = 0;

    public ConfigEditor(Configuration config) {
        this(config, null);
    }

    public ConfigEditor(Configuration config, String categoryOpen) {
        this.openedMillis = System.currentTimeMillis();
        this.processedConfig = ConfigProcessor.create(config);
        for (ConfigProcessor.ProcessedCategory processedCategory : this.processedConfig.values()) {
            for (ConfigProcessor.ProcessedOption option : processedCategory.options.values()) {
                this.categoryForOption.put(option, processedCategory);
                String combined = processedCategory.name + " " + processedCategory.desc + " " + option.name + " " + option.desc;
                combined = combined.replaceAll("[^a-zA-Z_ ]", "").toLowerCase();
                for (String word : combined.split("[ _]")) {
                    this.searchOptionMap.computeIfAbsent(word, k -> new HashSet()).add(option);
                }
            }
        }
        if (categoryOpen != null) {
            for (Map.Entry entry : this.processedConfig.entrySet()) {
                if (!((ConfigProcessor.ProcessedCategory)entry.getValue()).name.equalsIgnoreCase(categoryOpen)) continue;
                this.selectedCategory = (String)entry.getKey();
                break;
            }
            if (this.selectedCategory == null) {
                for (Map.Entry entry : this.processedConfig.entrySet()) {
                    if (!((ConfigProcessor.ProcessedCategory)entry.getValue()).name.toLowerCase().startsWith(categoryOpen.toLowerCase())) continue;
                    this.selectedCategory = (String)entry.getKey();
                    break;
                }
            }
            if (this.selectedCategory == null) {
                for (Map.Entry entry : this.processedConfig.entrySet()) {
                    if (!((ConfigProcessor.ProcessedCategory)entry.getValue()).name.toLowerCase().contains(categoryOpen.toLowerCase())) continue;
                    this.selectedCategory = (String)entry.getKey();
                    break;
                }
            }
        }
        editor = this;
    }

    private LinkedHashMap<String, ConfigProcessor.ProcessedCategory> getCurrentConfigEditing() {
        LinkedHashMap<String, ConfigProcessor.ProcessedCategory> newMap = new LinkedHashMap<String, ConfigProcessor.ProcessedCategory>(this.processedConfig);
        if (this.searchedCategories != null) {
            newMap.values().retainAll(this.searchedCategories);
        }
        return newMap;
    }

    private LinkedHashMap<String, ConfigProcessor.ProcessedOption> getOptionsInCategory(ConfigProcessor.ProcessedCategory cat) {
        LinkedHashMap<String, ConfigProcessor.ProcessedOption> newMap = new LinkedHashMap<String, ConfigProcessor.ProcessedOption>(cat.options);
        if (this.searchedOptions != null) {
            Set<Integer> visibleAccordions;
            HashSet<ConfigProcessor.ProcessedOption> retain = new HashSet<ConfigProcessor.ProcessedOption>();
            retain.addAll(this.searchedOptions);
            if (this.searchedAccordions != null && (visibleAccordions = this.searchedAccordions.get(cat)) != null && !visibleAccordions.isEmpty()) {
                for (ConfigProcessor.ProcessedOption option : newMap.values()) {
                    int accordionId;
                    if (!(option.editor instanceof GuiOptionEditorAccordion) || !visibleAccordions.contains(accordionId = ((GuiOptionEditorAccordion)option.editor).getAccordionId())) continue;
                    retain.add(option);
                }
            }
            newMap.values().retainAll(retain);
        }
        return newMap;
    }

    public String getSelectedCategory() {
        return this.selectedCategory;
    }

    private void setSelectedCategory(String category) {
        this.selectedCategory = category;
        this.optionsScroll.setValue(0);
    }

    public String getSelectedCategoryName() {
        return this.processedConfig.get((Object)this.selectedCategory).name;
    }

    public void search() {
        String search = this.searchField.getText().trim().replaceAll("[^a-zA-Z_ ]", "").toLowerCase();
        this.searchedCategories = null;
        this.searchedOptions = null;
        this.searchedAccordions = null;
        if (!search.isEmpty()) {
            this.searchedCategories = new HashSet<ConfigProcessor.ProcessedCategory>();
            this.searchedAccordions = new HashMap<ConfigProcessor.ProcessedCategory, Set<Integer>>();
            for (String word : search.split(" ")) {
                if (word.trim().isEmpty()) continue;
                HashSet options = new HashSet();
                Map<String, Set<ConfigProcessor.ProcessedOption>> map = StringUtils.subMapWithKeysThatAreSuffixes(word, this.searchOptionMap);
                map.values().forEach(options::addAll);
                if (options.isEmpty()) continue;
                if (this.searchedOptions == null) {
                    this.searchedOptions = new HashSet<ConfigProcessor.ProcessedOption>(options);
                    continue;
                }
                this.searchedOptions.retainAll(options);
            }
            if (this.searchedOptions == null) {
                this.searchedOptions = new HashSet<ConfigProcessor.ProcessedOption>();
            } else {
                for (ConfigProcessor.ProcessedOption option : this.searchedOptions) {
                    ConfigProcessor.ProcessedCategory cat = this.categoryForOption.get(option);
                    if (cat == null) continue;
                    this.searchedCategories.add(cat);
                    this.searchedAccordions.computeIfAbsent(cat, k -> new HashSet()).add(option.accordionId);
                }
            }
        }
    }

    @Override
    public void render() {
        boolean shouldShow;
        this.optionsScroll.tick();
        this.categoryScroll.tick();
        this.handleKeyboardPresses();
        ArrayList tooltipToDisplay = null;
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.openedMillis;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        float opacityFactor = LerpUtils.sigmoidZeroOne((float)delta / 500.0f);
        RenderUtils.drawGradientRect(0, 0, 0, width, height, (int)(128.0f * opacityFactor) << 24 | 0x101010, (int)(144.0f * opacityFactor) << 24 | 0x101010);
        int xSize = Math.min(scaledResolution.func_78326_a() - 100 / scaledResolution.func_78325_e(), 500);
        int ySize = Math.min(scaledResolution.func_78328_b() - 100 / scaledResolution.func_78325_e(), 400);
        int x = (scaledResolution.func_78326_a() - xSize) / 2;
        int y = (scaledResolution.func_78328_b() - ySize) / 2;
        int adjScaleFactor = Math.max(2, scaledResolution.func_78325_e());
        int openingXSize = xSize;
        int openingYSize = ySize;
        if (delta < 150L) {
            openingXSize = (int)(delta * (long)xSize / 150L);
            openingYSize = 5;
        } else if (delta < 300L) {
            openingYSize = 5 + (int)(delta - 150L) * (ySize - 5) / 150;
        }
        RenderUtils.drawFloatingRectDark((scaledResolution.func_78326_a() - openingXSize) / 2, (scaledResolution.func_78328_b() - openingYSize) / 2, openingXSize, openingYSize);
        GlScissorStack.clear();
        GlScissorStack.push((scaledResolution.func_78326_a() - openingXSize) / 2, (scaledResolution.func_78328_b() - openingYSize) / 2, (scaledResolution.func_78326_a() + openingXSize) / 2, (scaledResolution.func_78328_b() + openingYSize) / 2, scaledResolution);
        RenderUtils.drawFloatingRectDark(x + 5, y + 5, xSize - 10, 20, false);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        TextRenderUtils.drawStringCenteredScaledMaxWidth("NotEnoughFakepixel" + EnumChatFormatting.RESET + ", config by " + EnumChatFormatting.DARK_PURPLE + "Moulberry", fr, (float)x + (float)xSize / 2.0f, y + 15, false, 200, 0xA0A0A0);
        RenderUtils.drawFloatingRectDark(x + 4, y + 49 - 20, 140, ySize - 54 + 20, false);
        int innerPadding = 20 / adjScaleFactor;
        int innerLeft = x + 4 + innerPadding;
        int innerRight = x + 144 - innerPadding;
        int innerTop = y + 49 + innerPadding;
        int innerBottom = y + ySize - 5 - innerPadding;
        Gui.func_73734_a((int)innerLeft, (int)innerTop, (int)(innerLeft + 1), (int)innerBottom, (int)-16250866);
        Gui.func_73734_a((int)(innerLeft + 1), (int)innerTop, (int)innerRight, (int)(innerTop + 1), (int)-16250866);
        Gui.func_73734_a((int)(innerRight - 1), (int)(innerTop + 1), (int)innerRight, (int)innerBottom, (int)-14145490);
        Gui.func_73734_a((int)(innerLeft + 1), (int)(innerBottom - 1), (int)(innerRight - 1), (int)innerBottom, (int)-14145490);
        Gui.func_73734_a((int)(innerLeft + 1), (int)(innerTop + 1), (int)(innerRight - 1), (int)(innerBottom - 1), (int)1611139086);
        GlScissorStack.push(0, innerTop + 1, scaledResolution.func_78326_a(), innerBottom - 1, scaledResolution);
        float catBarSize = 1.0f;
        int catY = -this.categoryScroll.getValue();
        LinkedHashMap<String, ConfigProcessor.ProcessedCategory> currentConfigEditing = this.getCurrentConfigEditing();
        for (Map.Entry<String, ConfigProcessor.ProcessedCategory> entry : currentConfigEditing.entrySet()) {
            String selectedCategory = this.getSelectedCategory();
            if (selectedCategory == null || !currentConfigEditing.containsKey(selectedCategory)) {
                this.setSelectedCategory(entry.getKey());
            }
            String catName = entry.getValue().name;
            catName = entry.getKey().equals(this.getSelectedCategory()) ? EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.UNDERLINE + catName : EnumChatFormatting.GRAY + catName;
            TextRenderUtils.drawStringCenteredScaledMaxWidth(catName, fr, x + 75, y + 70 + catY, false, 100, -1);
            if ((catY += 15) <= 0) continue;
            catBarSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(catY + 5 + this.categoryScroll.getValue()));
        }
        float catBarStart = (float)this.categoryScroll.getValue() / (float)(catY + this.categoryScroll.getValue());
        float catBarEnd = catBarStart + catBarSize;
        if (catBarEnd > 1.0f) {
            catBarEnd = 1.0f;
            if ((float)this.categoryScroll.getTarget() / (float)(catY + this.categoryScroll.getValue()) + catBarSize < 1.0f) {
                int target = this.optionsScroll.getTarget();
                this.categoryScroll.setValue((int)Math.ceil((float)(catY + 5 + this.categoryScroll.getValue()) - catBarSize * (float)(catY + 5 + this.categoryScroll.getValue())));
                this.categoryScroll.setTarget(target);
            } else {
                this.categoryScroll.setValue((int)Math.ceil((float)(catY + 5 + this.categoryScroll.getValue()) - catBarSize * (float)(catY + 5 + this.categoryScroll.getValue())));
            }
        }
        int catDist = innerBottom - innerTop - 12;
        Gui.func_73734_a((int)(innerLeft + 2), (int)(innerTop + 5), (int)(innerLeft + 7), (int)(innerBottom - 5), (int)-15724528);
        Gui.func_73734_a((int)(innerLeft + 3), (int)(innerTop + 6 + (int)((float)catDist * catBarStart)), (int)(innerLeft + 6), (int)(innerTop + 6 + (int)((float)catDist * catBarEnd)), (int)-13619152);
        GlScissorStack.pop(scaledResolution);
        TextRenderUtils.drawStringCenteredScaledMaxWidth("Categories", fr, x + 75, y + 44, false, 120, 10709231);
        RenderUtils.drawFloatingRectDark(x + 149, y + 29, xSize - 154, ySize - 34, false);
        innerLeft = x + 149 + innerPadding;
        innerRight = x + xSize - 5 - innerPadding;
        innerBottom = y + ySize - 5 - innerPadding;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SEARCH_ICON);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawTexturedRect(innerRight - 20, innerTop - (20 + innerPadding) / 2 - 9, 18.0f, 18.0f, 9728);
        this.minimumSearchSize.tick();
        boolean bl = shouldShow = !this.searchField.getText().trim().isEmpty() || this.searchField.getFocus();
        if (shouldShow && this.minimumSearchSize.getTarget() < 30) {
            this.minimumSearchSize.setTarget(30);
            this.minimumSearchSize.resetTimer();
        } else if (!shouldShow && this.minimumSearchSize.getTarget() > 0) {
            this.minimumSearchSize.setTarget(0);
            this.minimumSearchSize.resetTimer();
        }
        int rightStuffLen = 20;
        if (this.minimumSearchSize.getValue() > 1) {
            int strLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.searchField.getText()) + 10;
            if (!shouldShow) {
                strLen = 0;
            }
            int len = Math.max(strLen, this.minimumSearchSize.getValue());
            this.searchField.setSize(len, 18);
            this.searchField.render(innerRight - 25 - len, innerTop - (20 + innerPadding) / 2 - 9);
            rightStuffLen += 5 + len;
        }
        if (this.getSelectedCategory() != null && currentConfigEditing.containsKey(this.getSelectedCategory())) {
            ConfigProcessor.ProcessedCategory cat = currentConfigEditing.get(this.getSelectedCategory());
            TextRenderUtils.drawStringScaledMaxWidth(cat.desc, fr, innerLeft + 5, y + 40, true, innerRight - innerLeft - rightStuffLen - 10, 0xB0B0B0);
        }
        Gui.func_73734_a((int)innerLeft, (int)innerTop, (int)(innerLeft + 1), (int)innerBottom, (int)-16250866);
        Gui.func_73734_a((int)(innerLeft + 1), (int)innerTop, (int)innerRight, (int)(innerTop + 1), (int)-16250866);
        Gui.func_73734_a((int)(innerRight - 1), (int)(innerTop + 1), (int)innerRight, (int)innerBottom, (int)-13619146);
        Gui.func_73734_a((int)(innerLeft + 1), (int)(innerBottom - 1), (int)(innerRight - 1), (int)innerBottom, (int)-13619146);
        Gui.func_73734_a((int)(innerLeft + 1), (int)(innerTop + 1), (int)(innerRight - 1), (int)(innerBottom - 1), (int)1611139086);
        GlScissorStack.push(innerLeft + 1, innerTop + 1, innerRight - 1, innerBottom - 1, scaledResolution);
        float barSize = 1.0f;
        int optionY = -this.optionsScroll.getValue();
        if (this.getSelectedCategory() != null && currentConfigEditing.containsKey(this.getSelectedCategory())) {
            ConfigProcessor.ProcessedCategory cat = currentConfigEditing.get(this.getSelectedCategory());
            int optionWidthDefault = innerRight - innerLeft - 20;
            GlStateManager.func_179126_j();
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            for (ConfigProcessor.ProcessedOption option : this.getOptionsInCategory(cat).values()) {
                int optionHeight;
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor;
                int optionWidth = optionWidthDefault;
                if (option.accordionId >= 0) {
                    if (!activeAccordions.containsKey(option.accordionId)) continue;
                    int accordionDepth = (Integer)activeAccordions.get(option.accordionId);
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth + 1);
                }
                if ((editor = option.editor) == null) continue;
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    int accordionDepth = 0;
                    if (option.accordionId >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                if (innerTop + 5 + optionY + (optionHeight = editor.getHeight()) > innerTop + 1 && innerTop + 5 + optionY < innerBottom - 1) {
                    editor.render((innerLeft + innerRight - optionWidth) / 2 - 5, innerTop + 5 + optionY, optionWidth);
                }
                optionY += optionHeight + 5;
            }
            GlStateManager.func_179097_i();
            if (optionY > 0) {
                barSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(optionY + 5 + this.optionsScroll.getValue()));
            }
        }
        GlScissorStack.pop(scaledResolution);
        GL11.glDisable((int)3089);
        if (this.getSelectedCategory() != null && currentConfigEditing.containsKey(this.getSelectedCategory())) {
            int optionYOverlay = -this.optionsScroll.getValue();
            ConfigProcessor.ProcessedCategory cat = currentConfigEditing.get(this.getSelectedCategory());
            int optionWidthDefault = innerRight - innerLeft - 20;
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
            GlStateManager.func_179126_j();
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            for (ConfigProcessor.ProcessedOption option : this.getOptionsInCategory(cat).values()) {
                int optionHeight;
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor;
                int optionWidth = optionWidthDefault;
                if (option.accordionId >= 0) {
                    if (!activeAccordions.containsKey(option.accordionId)) continue;
                    int accordionDepth = (Integer)activeAccordions.get(option.accordionId);
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth + 1);
                }
                if ((editor = option.editor) == null) continue;
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    int accordionDepth = 0;
                    if (option.accordionId >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                if (innerTop + 5 + optionYOverlay + (optionHeight = editor.getHeight()) > innerTop + 1 && innerTop + 5 + optionYOverlay < innerBottom - 1) {
                    editor.renderOverlay((innerLeft + innerRight - optionWidth) / 2 - 5, innerTop + 5 + optionYOverlay, optionWidth);
                }
                optionYOverlay += optionHeight + 5;
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
        }
        GL11.glEnable((int)3089);
        this.optionsBarStart = (float)this.optionsScroll.getValue() / (float)(optionY + this.optionsScroll.getValue());
        this.optionsBarend = this.optionsBarStart + barSize;
        if (this.optionsBarend > 1.0f) {
            this.optionsBarend = 1.0f;
            if ((float)this.optionsScroll.getTarget() / (float)(optionY + this.optionsScroll.getValue()) + barSize < 1.0f) {
                int target = this.optionsScroll.getTarget();
                this.optionsScroll.setValue((int)Math.ceil((float)(optionY + 5 + this.optionsScroll.getValue()) - barSize * (float)(optionY + 5 + this.optionsScroll.getValue())));
                this.optionsScroll.setTarget(target);
            } else {
                this.optionsScroll.setValue((int)Math.ceil((float)(optionY + 5 + this.optionsScroll.getValue()) - barSize * (float)(optionY + 5 + this.optionsScroll.getValue())));
            }
        }
        int dist = innerBottom - innerTop - 12;
        Gui.func_73734_a((int)(innerRight - 10), (int)(innerTop + 5), (int)(innerRight - 5), (int)(innerBottom - 5), (int)-15724528);
        Gui.func_73734_a((int)(innerRight - 9), (int)(innerTop + 6 + (int)((float)dist * this.optionsBarStart)), (int)(innerRight - 6), (int)(innerTop + 6 + (int)((float)dist * this.optionsBarend)), (int)-13619152);
        for (int socialIndex = 0; socialIndex < socialsIco.length; ++socialIndex) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(socialsIco[socialIndex]);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int socialLeft = x + xSize - 23 - 18 * socialIndex;
            RenderUtils.drawTexturedRect(socialLeft, y + 7, 16.0f, 16.0f, 9729);
            if (mouseX < socialLeft || mouseX > socialLeft + 16 || mouseY < y + 6 || mouseY > y + 23) continue;
            tooltipToDisplay = Lists.newArrayList((Object[])new String[]{EnumChatFormatting.YELLOW + "Go to: " + EnumChatFormatting.RESET + socialsLink[socialIndex]});
        }
        GlScissorStack.clear();
        if (tooltipToDisplay != null) {
            TextRenderUtils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, width, height, -1, fr);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY) {
        int accordionDepth;
        GuiOptionEditorAccordion accordion;
        GuiOptionEditor editor;
        this.lastMouseX = mouseX;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int xSize = Math.min(width - 100 / scaledResolution.func_78325_e(), 500);
        int ySize = Math.min(height - 100 / scaledResolution.func_78325_e(), 400);
        int x = (scaledResolution.func_78326_a() - xSize) / 2;
        int y = (scaledResolution.func_78328_b() - ySize) / 2;
        int adjScaleFactor = Math.max(2, scaledResolution.func_78325_e());
        int innerPadding = 20 / adjScaleFactor;
        int innerTop = y + 49 + innerPadding;
        int innerBottom = y + ySize - 5 - innerPadding;
        int innerLeft = x + 149 + innerPadding;
        int innerRight = x + xSize - 5 - innerPadding;
        int dist = innerBottom - innerTop - 12;
        int optionsBarStartY = innerTop + 6 + (int)((float)dist * this.optionsBarStart);
        int optionsBarEndY = innerTop + 6 + (int)((float)dist * this.optionsBarend);
        int optionsBarStartX = innerRight - 12;
        int optionsBarEndX = innerRight - 3;
        int categoryY = -this.categoryScroll.getValue();
        int catDist = innerBottom - innerTop - 12;
        float catBarStart = (float)this.categoryScroll.getValue() / (float)((categoryY += 15 * this.getCurrentConfigEditing().size()) + this.categoryScroll.getValue());
        float categoryBarSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(categoryY + 5 + this.categoryScroll.getValue()));
        float catBarEnd = catBarStart + categoryBarSize;
        int categoryBarStartY = innerTop + 6 + (int)((float)catDist * catBarStart);
        int categoryBarEndY = innerTop + 6 + (int)((float)catDist * catBarEnd);
        int categoryBarStartX = x + innerPadding + 7;
        int categoryBarEndX = x + innerPadding + 12;
        this.keyboardScrollXCutoff = innerLeft - 10;
        if (Mouse.getEventButtonState()) {
            int strLen;
            int len;
            if ((mouseY < optionsBarStartY || mouseY > optionsBarEndY) && mouseX >= optionsBarStartX && mouseX <= optionsBarEndX && mouseY > innerTop + 6 && mouseY < innerBottom - 6) {
                this.optionsScroll.setTimeToReachTarget(200);
                this.optionsScroll.resetTimer();
                this.optionsScroll.setTarget(mouseY - innerTop);
                return true;
            }
            if ((mouseY < categoryBarStartY || mouseY > categoryBarEndY) && mouseX >= categoryBarStartX && mouseX <= categoryBarEndX && mouseY > innerTop + 6 && mouseY < innerBottom - 6) {
                this.categoryScroll.setTimeToReachTarget(200);
                this.categoryScroll.resetTimer();
                this.categoryScroll.setTarget(mouseY - innerTop);
                return true;
            }
            this.searchField.setFocus(mouseX >= innerRight - 20 && mouseX <= innerRight - 2 && mouseY >= innerTop - (20 + innerPadding) / 2 - 9 && mouseY <= innerTop - (20 + innerPadding) / 2 + 9);
            if (this.minimumSearchSize.getValue() > 1 && mouseX >= innerRight - 25 - (len = Math.max(strLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.searchField.getText()) + 10, this.minimumSearchSize.getValue())) && mouseX <= innerRight - 25 && mouseY >= innerTop - (20 + innerPadding) / 2 - 9 && mouseY <= innerTop - (20 + innerPadding) / 2 + 9) {
                String old = this.searchField.getText();
                this.searchField.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                if (!this.searchField.getText().equals(old)) {
                    this.search();
                }
            }
        }
        int dWheel = Mouse.getEventDWheel();
        if (mouseY > innerTop && mouseY < innerBottom && dWheel != 0) {
            int barMax;
            int newTarget;
            if (dWheel < 0) {
                dWheel = -1;
            }
            if (dWheel > 0) {
                dWheel = 1;
            }
            if (mouseX < innerLeft) {
                newTarget = this.categoryScroll.getTarget() - dWheel * 30;
                if (newTarget < 0) {
                    newTarget = 0;
                }
                float catBarSize = 1.0f;
                int catY = -newTarget;
                for (Map.Entry<String, ConfigProcessor.ProcessedCategory> entry : this.getCurrentConfigEditing().entrySet()) {
                    if (this.getSelectedCategory() == null) {
                        this.setSelectedCategory(entry.getKey());
                    }
                    if ((catY += 15) <= 0) continue;
                    catBarSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(catY + 5 + newTarget));
                }
                barMax = (int)Math.floor((float)(catY + 5 + newTarget) - catBarSize * (float)(catY + 5 + newTarget));
                if (newTarget > barMax) {
                    newTarget = barMax;
                }
                this.categoryScroll.resetTimer();
                this.categoryScroll.setTarget(newTarget);
            } else {
                newTarget = this.optionsScroll.getTarget() - dWheel * 30;
                if (newTarget < 0) {
                    newTarget = 0;
                }
                float barSize = 1.0f;
                int optionY = -newTarget;
                if (this.getSelectedCategory() != null && this.getCurrentConfigEditing() != null && this.getCurrentConfigEditing().containsKey(this.getSelectedCategory())) {
                    ConfigProcessor.ProcessedCategory cat = this.getCurrentConfigEditing().get(this.getSelectedCategory());
                    HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
                    for (ConfigProcessor.ProcessedOption option : this.getOptionsInCategory(cat).values()) {
                        if (option.accordionId >= 0 && !activeAccordions.containsKey(option.accordionId) || (editor = option.editor) == null) continue;
                        if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                            accordionDepth = 0;
                            if (option.accordionId >= 0) {
                                accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                            }
                            activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                        }
                        if ((optionY += editor.getHeight() + 5) <= 0) continue;
                        barSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(optionY + 5 + newTarget));
                    }
                }
                if (newTarget > (barMax = (int)Math.floor((float)(optionY + 5 + newTarget) - barSize * (float)(optionY + 5 + newTarget)))) {
                    newTarget = barMax;
                }
                this.optionsScroll.setTimeToReachTarget(Math.min(150, Math.max(10, 5 * Math.abs(newTarget - this.optionsScroll.getValue()))));
                this.optionsScroll.resetTimer();
                this.optionsScroll.setTarget(newTarget);
            }
        } else if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            if (this.getCurrentConfigEditing() != null) {
                int catY = -this.categoryScroll.getValue();
                for (Map.Entry<String, ConfigProcessor.ProcessedCategory> entry : this.getCurrentConfigEditing().entrySet()) {
                    if (this.getSelectedCategory() == null) {
                        this.setSelectedCategory(entry.getKey());
                    }
                    if (mouseX >= x + 5 && mouseX <= x + 145 && mouseY >= y + 70 + catY - 7 && mouseY <= y + 70 + catY + 7) {
                        this.setSelectedCategory(entry.getKey());
                        return true;
                    }
                    catY += 15;
                }
            }
            for (int socialIndex = 0; socialIndex < socialsLink.length; ++socialIndex) {
                int socialLeft = x + xSize - 23 - 18 * socialIndex;
                if (mouseX < socialLeft || mouseX > socialLeft + 16 || mouseY < y + 6 || mouseY > y + 23) continue;
                try {
                    Desktop.getDesktop().browse(new URI(socialsLink[socialIndex]));
                }
                catch (Exception entry) {
                    // empty catch block
                }
                return true;
            }
        }
        int optionY = -this.optionsScroll.getValue();
        if (this.getSelectedCategory() != null && this.getCurrentConfigEditing() != null && this.getCurrentConfigEditing().containsKey(this.getSelectedCategory())) {
            int optionWidthDefault = innerRight - innerLeft - 20;
            ConfigProcessor.ProcessedCategory cat = this.getCurrentConfigEditing().get(this.getSelectedCategory());
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            for (ConfigProcessor.ProcessedOption option : this.getOptionsInCategory(cat).values()) {
                int optionWidth = optionWidthDefault;
                if (option.accordionId >= 0) {
                    if (!activeAccordions.containsKey(option.accordionId)) continue;
                    int accordionDepth2 = (Integer)activeAccordions.get(option.accordionId);
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth2 + 1);
                }
                if ((editor = option.editor) == null) continue;
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    accordionDepth = 0;
                    if (option.accordionId >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                if (editor.mouseInputOverlay((innerLeft + innerRight - optionWidth) / 2 - 5, innerTop + 5 + optionY, optionWidth, mouseX, mouseY)) {
                    return true;
                }
                optionY += editor.getHeight() + 5;
            }
        }
        if (mouseX > innerLeft && mouseX < innerRight && mouseY > innerTop && mouseY < innerBottom) {
            optionY = -this.optionsScroll.getValue();
            if (this.getSelectedCategory() != null && this.getCurrentConfigEditing() != null && this.getCurrentConfigEditing().containsKey(this.getSelectedCategory())) {
                int optionWidthDefault = innerRight - innerLeft - 20;
                ConfigProcessor.ProcessedCategory cat = this.getCurrentConfigEditing().get(this.getSelectedCategory());
                HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
                for (ConfigProcessor.ProcessedOption option : this.getOptionsInCategory(cat).values()) {
                    int optionWidth = optionWidthDefault;
                    if (option.accordionId >= 0) {
                        if (!activeAccordions.containsKey(option.accordionId)) continue;
                        int accordionDepth3 = (Integer)activeAccordions.get(option.accordionId);
                        optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth3 + 1);
                    }
                    if ((editor = option.editor) == null) continue;
                    if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                        accordionDepth = 0;
                        if (option.accordionId >= 0) {
                            accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                        }
                        activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                    }
                    if (editor.mouseInput((innerLeft + innerRight - optionWidth) / 2 - 5, innerTop + 5 + optionY, optionWidth, mouseX, mouseY)) {
                        return true;
                    }
                    optionY += editor.getHeight() + 5;
                }
            }
        }
        return true;
    }

    @Override
    public boolean keyboardInput() {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int xSize = Math.min(width - 100 / scaledResolution.func_78325_e(), 500);
        int adjScaleFactor = Math.max(2, scaledResolution.func_78325_e());
        int innerPadding = 20 / adjScaleFactor;
        int innerWidth = xSize - 154 - innerPadding * 2;
        if (Keyboard.getEventKeyState()) {
            String old = this.searchField.getText();
            this.searchField.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            this.searchField.setText(Minecraft.func_71410_x().field_71466_p.func_78269_a(this.searchField.getText(), innerWidth / 2 - 20));
            if (!this.searchField.getText().equals(old)) {
                this.search();
            }
        }
        if (this.getSelectedCategory() != null && this.getCurrentConfigEditing() != null && this.getCurrentConfigEditing().containsKey(this.getSelectedCategory())) {
            ConfigProcessor.ProcessedCategory cat = this.getCurrentConfigEditing().get(this.getSelectedCategory());
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            for (ConfigProcessor.ProcessedOption option : this.getOptionsInCategory(cat).values()) {
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor;
                if (option.accordionId >= 0 && !activeAccordions.containsKey(option.accordionId) || (editor = option.editor) == null) continue;
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    int accordionDepth = 0;
                    if (option.accordionId >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                if (!editor.keyboardInput()) continue;
                return true;
            }
        }
        return true;
    }

    private void handleKeyboardPresses() {
        LerpingInteger target;
        LerpingInteger lerpingInteger = target = this.lastMouseX < this.keyboardScrollXCutoff ? this.categoryScroll : this.optionsScroll;
        if (Keyboard.isKeyDown((int)208)) {
            target.setTimeToReachTarget(50);
            target.resetTimer();
            target.setTarget(target.getTarget() + 5);
        } else if (Keyboard.isKeyDown((int)200)) {
            target.setTimeToReachTarget(50);
            target.resetTimer();
            if (target.getTarget() >= 0) {
                target.setTarget(target.getTarget() - 5);
            }
        }
    }
}

