/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core;

import java.awt.Color;

public class ChromaColour {
    private static final int RADIX = 10;
    private static final int MIN_CHROMA_SECS = 1;
    private static final int MAX_CHROMA_SECS = 60;
    public static long startTime = -1L;

    public static String special(int chromaSpeed, int alpha, int rgb) {
        return ChromaColour.special(chromaSpeed, alpha, (rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
    }

    public static String special(int chromaSpeed, int alpha, int r, int g, int b) {
        String sb = Integer.toString(chromaSpeed, 10) + ":" + Integer.toString(alpha, 10) + ":" + Integer.toString(r, 10) + ":" + Integer.toString(g, 10) + ":" + Integer.toString(b, 10);
        return sb;
    }

    private static int[] decompose(String csv) {
        String[] split = csv.split(":");
        int[] arr = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            arr[i] = Integer.parseInt(split[split.length - 1 - i], 10);
        }
        return arr;
    }

    public static int specialToSimpleRGB(String special) {
        int[] d = ChromaColour.decompose(special);
        int r = d[2];
        int g = d[1];
        int b = d[0];
        int a = d[3];
        int chr = d[4];
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getSpeed(String special) {
        return ChromaColour.decompose(special)[4];
    }

    public static float getSecondsForSpeed(int speed) {
        return (float)(255 - speed) / 254.0f * 59.0f + 1.0f;
    }

    public static int specialToChromaRGB(String special) {
        if (startTime < 0L) {
            startTime = System.currentTimeMillis();
        }
        int[] d = ChromaColour.decompose(special);
        int chr = d[4];
        int a = d[3];
        int r = d[2];
        int g = d[1];
        int b = d[0];
        float[] hsv = Color.RGBtoHSB(r, g, b, null);
        if (chr > 0) {
            float seconds = ChromaColour.getSecondsForSpeed(chr);
            hsv[0] = hsv[0] + (float)(System.currentTimeMillis() - startTime) / 1000.0f / seconds;
            hsv[0] = hsv[0] % 1.0f;
            if (hsv[0] < 0.0f) {
                hsv[0] = hsv[0] + 1.0f;
            }
        }
        return (a & 0xFF) << 24 | Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]) & 0xFFFFFF;
    }

    public static int rotateHue(int argb, int degrees) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float[] hsv = Color.RGBtoHSB(r, g, b, null);
        hsv[0] = hsv[0] + (float)degrees / 360.0f;
        hsv[0] = hsv[0] % 1.0f;
        return (a & 0xFF) << 24 | Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]) & 0xFFFFFF;
    }
}

