/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.ginafro.notenoughfakepixel.config.gui.GuiTextures;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiElement;
import org.ginafro.notenoughfakepixel.config.gui.core.util.lerp.LerpUtils;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.RenderUtils;
import org.lwjgl.input.Mouse;

public class GuiElementBoolean
extends GuiElement {
    public int x;
    public int y;
    private boolean value;
    private final int clickRadius;
    private final Consumer<Boolean> toggleCallback;
    private boolean previewValue;
    private int animation = 0;
    private long lastMillis = 0L;
    private static final int xSize = 48;
    private static final int ySize = 14;

    public GuiElementBoolean(int x, int y, boolean value, Consumer<Boolean> toggleCallback) {
        this(x, y, value, 0, toggleCallback);
    }

    public GuiElementBoolean(int x, int y, boolean value, int clickRadius, Consumer<Boolean> toggleCallback) {
        this.x = x;
        this.y = y;
        this.value = value;
        this.previewValue = value;
        this.clickRadius = clickRadius;
        this.toggleCallback = toggleCallback;
        this.lastMillis = System.currentTimeMillis();
        if (value) {
            this.animation = 36;
        }
    }

    @Override
    public void render() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.BAR);
        RenderUtils.drawTexturedRect(this.x, this.y, 48.0f, 14.0f);
        ResourceLocation buttonLoc = GuiTextures.ON;
        long currentMillis = System.currentTimeMillis();
        long deltaMillis = currentMillis - this.lastMillis;
        this.lastMillis = currentMillis;
        boolean passedLimit = false;
        if (this.previewValue != this.value && (this.previewValue && this.animation > 12 || !this.previewValue && this.animation < 24)) {
            passedLimit = true;
        }
        this.animation = this.previewValue != passedLimit ? (int)((long)this.animation + deltaMillis / 10L) : (int)((long)this.animation - deltaMillis / 10L);
        this.lastMillis -= deltaMillis % 10L;
        this.animation = this.previewValue == this.value ? Math.max(0, Math.min(36, this.animation)) : (!passedLimit ? (this.previewValue ? Math.max(0, Math.min(12, this.animation)) : Math.max(24, Math.min(36, this.animation))) : (this.previewValue ? Math.max(12, this.animation) : Math.min(24, this.animation)));
        int animation = (int)(LerpUtils.sigmoidZeroOne((float)this.animation / 36.0f) * 36.0f);
        if (animation < 3) {
            buttonLoc = GuiTextures.OFF;
        } else if (animation < 13) {
            buttonLoc = GuiTextures.ONE;
        } else if (animation < 23) {
            buttonLoc = GuiTextures.TWO;
        } else if (animation < 33) {
            buttonLoc = GuiTextures.THREE;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(buttonLoc);
        RenderUtils.drawTexturedRect(this.x + animation, this.y, 12.0f, 14.0f);
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY) {
        if (mouseX > this.x - this.clickRadius && mouseX < this.x + 48 + this.clickRadius && mouseY > this.y - this.clickRadius && mouseY < this.y + 14 + this.clickRadius) {
            if (Mouse.getEventButton() == 0) {
                if (Mouse.getEventButtonState()) {
                    this.previewValue = !this.value;
                } else if (this.previewValue == !this.value) {
                    this.value = !this.value;
                    this.toggleCallback.accept(this.value);
                }
            }
        } else {
            this.previewValue = this.value;
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        return false;
    }
}

