/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.ginafro.notenoughfakepixel.config.gui.core.ChromaColour;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiElement;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiElementTextField;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.RenderUtils;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.TextRenderUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiElementColour
extends GuiElement {
    public static final ResourceLocation colour_selector_dot = new ResourceLocation("notenoughfakepixel:core/colour_selector_dot.png");
    public static final ResourceLocation colour_selector_bar = new ResourceLocation("notenoughfakepixel:core/colour_selector_bar.png");
    public static final ResourceLocation colour_selector_bar_alpha = new ResourceLocation("notenoughfakepixel:core/colour_selector_bar_alpha.png");
    public static final ResourceLocation colour_selector_chroma = new ResourceLocation("notenoughfakepixel:core/colour_selector_chroma.png");
    private static final ResourceLocation colourPickerLocation = new ResourceLocation("mbcore:dynamic/colourpicker");
    private static final ResourceLocation colourPickerBarValueLocation = new ResourceLocation("mbcore:dynamic/colourpickervalue");
    private static final ResourceLocation colourPickerBarOpacityLocation = new ResourceLocation("mbcore:dynamic/colourpickeropacity");
    private final GuiElementTextField hexField = new GuiElementTextField("", 44);
    private final int x;
    private final int y;
    private int xSize = 119;
    private final int ySize = 89;
    private float wheelAngle = 0.0f;
    private float wheelRadius = 0.0f;
    private int clickedComponent = -1;
    private final Consumer<String> colourChangedCallback;
    private final Runnable closeCallback;
    private String colour;
    private final boolean opacitySlider;
    private final boolean valueSlider;

    public GuiElementColour(int x, int y, String initialColour, Consumer<String> colourChangedCallback, Runnable closeCallback) {
        this(x, y, initialColour, colourChangedCallback, closeCallback, true, true);
    }

    public GuiElementColour(int x, int y, String initialColour, Consumer<String> colourChangedCallback, Runnable closeCallback, boolean opacitySlider, boolean valueSlider) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        this.y = Math.max(10, Math.min(scaledResolution.func_78328_b() - 89 - 10, y));
        this.x = Math.max(10, Math.min(scaledResolution.func_78326_a() - this.xSize - 10, x));
        this.colour = initialColour;
        this.colourChangedCallback = colourChangedCallback;
        this.closeCallback = closeCallback;
        int colour = ChromaColour.specialToSimpleRGB(initialColour);
        Color c = new Color(colour);
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.updateAngleAndRadius(hsv);
        this.opacitySlider = opacitySlider;
        this.valueSlider = valueSlider;
        if (!valueSlider) {
            this.xSize -= 15;
        }
        if (!opacitySlider) {
            this.xSize -= 15;
        }
    }

    public void updateAngleAndRadius(float[] hsv) {
        this.wheelRadius = hsv[1];
        this.wheelAngle = hsv[0] * 360.0f;
    }

    @Override
    public void render() {
        int rgb;
        RenderUtils.drawFloatingRectDark(this.x, this.y, this.xSize, 89);
        int currentColour = ChromaColour.specialToSimpleRGB(this.colour);
        Color c = new Color(currentColour, true);
        float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        BufferedImage bufferedImage = new BufferedImage(288, 288, 2);
        float borderRadius = 0.05f;
        if (Keyboard.isKeyDown((int)49)) {
            borderRadius = 0.0f;
        }
        for (int x = -16; x < 272; ++x) {
            for (int y = -16; y < 272; ++y) {
                float radius = (float)Math.sqrt((float)((x - 128) * (x - 128) + (y - 128) * (y - 128)) / 16384.0f);
                float angle = (float)Math.toDegrees(Math.atan((double)(128 - x) / ((double)(y - 128) + 1.0E-5)) + 1.5707963267948966);
                if (y < 128) {
                    angle += 180.0f;
                }
                if (radius <= 1.0f) {
                    rgb = Color.getHSBColor(angle / 360.0f, (float)Math.pow(radius, 1.5), hsv[2]).getRGB();
                    bufferedImage.setRGB(x + 16, y + 16, rgb);
                    continue;
                }
                if (!(radius <= 1.0f + borderRadius)) continue;
                float invBlackAlpha = Math.abs(radius - 1.0f - borderRadius / 2.0f) / borderRadius * 2.0f;
                float blackAlpha = 1.0f - invBlackAlpha;
                if (radius > 1.0f + borderRadius / 2.0f) {
                    bufferedImage.setRGB(x + 16, y + 16, (int)(blackAlpha * 255.0f) << 24);
                    continue;
                }
                Color col = Color.getHSBColor(angle / 360.0f, 1.0f, hsv[2]);
                int rgb2 = (int)((float)col.getRed() * invBlackAlpha) << 16 | (int)((float)col.getGreen() * invBlackAlpha) << 8 | (int)((float)col.getBlue() * invBlackAlpha);
                bufferedImage.setRGB(x + 16, y + 16, 0xFF000000 | rgb2);
            }
        }
        BufferedImage bufferedImageValue = new BufferedImage(10, 64, 2);
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 64; ++y) {
                if (!(x != 0 && x != 9 || y != 0 && y != 63)) continue;
                int rgb3 = Color.getHSBColor(this.wheelAngle / 360.0f, this.wheelRadius, (float)(64 - y) / 64.0f).getRGB();
                bufferedImageValue.setRGB(x, y, rgb3);
            }
        }
        BufferedImage bufferedImageOpacity = new BufferedImage(10, 64, 2);
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 64; ++y) {
                if (!(x != 0 && x != 9 || y != 0 && y != 63)) continue;
                rgb = currentColour & 0xFFFFFF | Math.min(255, (64 - y) * 4) << 24;
                bufferedImageOpacity.setRGB(x, y, rgb);
            }
        }
        float selradius = (float)Math.pow(this.wheelRadius, 0.6666666865348816) * 32.0f;
        int selx = (int)(Math.cos(Math.toRadians(this.wheelAngle)) * (double)selradius);
        int sely = (int)(Math.sin(Math.toRadians(this.wheelAngle)) * (double)selradius);
        int valueOffset = 0;
        if (this.valueSlider) {
            valueOffset = 15;
            Minecraft.func_71410_x().func_110434_K().func_110579_a(colourPickerBarValueLocation, (ITextureObject)new DynamicTexture(bufferedImageValue));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(colourPickerBarValueLocation);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.drawTexturedRect(this.x + 5 + 64 + 5, this.y + 5, 10.0f, 64.0f, 9728);
        }
        int opacityOffset = 0;
        if (this.opacitySlider) {
            opacityOffset = 15;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(colour_selector_bar_alpha);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.drawTexturedRect(this.x + 5 + 64 + 5 + valueOffset, this.y + 5, 10.0f, 64.0f, 9728);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(colourPickerBarOpacityLocation, (ITextureObject)new DynamicTexture(bufferedImageOpacity));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(colourPickerBarOpacityLocation);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.drawTexturedRect(this.x + 5 + 64 + 5 + valueOffset, this.y + 5, 10.0f, 64.0f, 9728);
        }
        int chromaSpeed = ChromaColour.getSpeed(this.colour);
        int currentColourChroma = ChromaColour.specialToChromaRGB(this.colour);
        Color cChroma = new Color(currentColourChroma, true);
        float[] hsvChroma = Color.RGBtoHSB(cChroma.getRed(), cChroma.getGreen(), cChroma.getBlue(), null);
        if (chromaSpeed > 0) {
            GuiElementColour.func_73734_a((int)(this.x + 5 + 64 + valueOffset + opacityOffset + 5 + 1), (int)(this.y + 5 + 1), (int)(this.x + 5 + 64 + valueOffset + opacityOffset + 5 + 10 - 1), (int)(this.y + 5 + 64 - 1), (int)Color.HSBtoRGB(hsvChroma[0], 0.8f, 0.8f));
        } else {
            GuiElementColour.func_73734_a((int)(this.x + 5 + 64 + valueOffset + opacityOffset + 5 + 1), (int)(this.y + 5 + 27 + 1), (int)(this.x + 5 + 64 + valueOffset + opacityOffset + 5 + 10 - 1), (int)(this.y + 5 + 37 - 1), (int)Color.HSBtoRGB((hsvChroma[0] + (float)(System.currentTimeMillis() - ChromaColour.startTime) / 1000.0f) % 1.0f, 0.8f, 0.8f));
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(colour_selector_bar);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.valueSlider) {
            RenderUtils.drawTexturedRect(this.x + 5 + 64 + 5, this.y + 5, 10.0f, 64.0f, 9728);
        }
        if (this.opacitySlider) {
            RenderUtils.drawTexturedRect(this.x + 5 + 64 + 5 + valueOffset, this.y + 5, 10.0f, 64.0f, 9728);
        }
        if (chromaSpeed > 0) {
            RenderUtils.drawTexturedRect(this.x + 5 + 64 + valueOffset + opacityOffset + 5, this.y + 5, 10.0f, 64.0f, 9728);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(colour_selector_chroma);
            RenderUtils.drawTexturedRect(this.x + 5 + 64 + valueOffset + opacityOffset + 5, this.y + 5 + 27, 10.0f, 10.0f, 9728);
        }
        if (this.valueSlider) {
            GuiElementColour.func_73734_a((int)(this.x + 5 + 64 + 5), (int)(this.y + 5 + 64 - (int)(64.0f * hsv[2])), (int)(this.x + 5 + 64 + valueOffset), (int)(this.y + 5 + 64 - (int)(64.0f * hsv[2]) + 1), (int)-16777216);
        }
        if (this.opacitySlider) {
            GuiElementColour.func_73734_a((int)(this.x + 5 + 64 + 5 + valueOffset), (int)(this.y + 5 + 64 - c.getAlpha() / 4), (int)(this.x + 5 + 64 + valueOffset + opacityOffset), (int)(this.y + 5 + 64 - c.getAlpha() / 4 - 1), (int)-16777216);
        }
        if (chromaSpeed > 0) {
            GuiElementColour.func_73734_a((int)(this.x + 5 + 64 + valueOffset + opacityOffset + 5), (int)(this.y + 5 + 64 - (int)((float)chromaSpeed / 255.0f * 64.0f)), (int)(this.x + 5 + 64 + valueOffset + opacityOffset + 5 + 10), (int)(this.y + 5 + 64 - (int)((float)chromaSpeed / 255.0f * 64.0f) + 1), (int)-16777216);
        }
        Minecraft.func_71410_x().func_110434_K().func_110579_a(colourPickerLocation, (ITextureObject)new DynamicTexture(bufferedImage));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(colourPickerLocation);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawTexturedRect(this.x + 1, this.y + 1, 72.0f, 72.0f, 9729);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(colour_selector_dot);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawTexturedRect(this.x + 5 + 32 + selx - 4, this.y + 5 + 32 + sely - 4, 8.0f, 8.0f, 9728);
        TextRenderUtils.drawStringCenteredScaledMaxWidth(EnumChatFormatting.GRAY.toString() + Math.round(hsv[2] * 100.0f), Minecraft.func_71410_x().field_71466_p, this.x + 5 + 64 + 5 + 5 - (Math.round(hsv[2] * 100.0f) == 100 ? 1 : 0), this.y + 5 + 64 + 5 + 5, true, 13, -1);
        if (this.opacitySlider) {
            TextRenderUtils.drawStringCenteredScaledMaxWidth(EnumChatFormatting.GRAY.toString() + Math.round((float)c.getAlpha() / 255.0f * 100.0f), Minecraft.func_71410_x().field_71466_p, this.x + 5 + 64 + 5 + valueOffset + 5, this.y + 5 + 64 + 5 + 5, true, 13, -1);
        }
        if (chromaSpeed > 0) {
            TextRenderUtils.drawStringCenteredScaledMaxWidth(EnumChatFormatting.GRAY.toString() + (int)ChromaColour.getSecondsForSpeed(chromaSpeed) + "s", Minecraft.func_71410_x().field_71466_p, this.x + 5 + 64 + 5 + valueOffset + opacityOffset + 6, this.y + 5 + 64 + 5 + 5, true, 13, -1);
        }
        this.hexField.setSize(48, 10);
        if (!this.hexField.getFocus()) {
            this.hexField.setText(Integer.toHexString(c.getRGB() & 0xFFFFFF).toUpperCase());
        }
        StringBuilder sb = new StringBuilder(EnumChatFormatting.GRAY + "#");
        for (int i = 0; i < 6 - this.hexField.getText().length(); ++i) {
            sb.append("0");
        }
        sb.append(EnumChatFormatting.WHITE);
        this.hexField.setPrependText(sb.toString());
        this.hexField.render(this.x + 5 + 8, this.y + 5 + 64 + 5);
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        float mouseXF = (float)((double)Mouse.getX() * scaledResolution.func_78327_c() / (double)Minecraft.func_71410_x().field_71443_c);
        float mouseYF = (float)(scaledResolution.func_78324_d() - (double)Mouse.getY() * scaledResolution.func_78324_d() / (double)Minecraft.func_71410_x().field_71440_d - 1.0);
        if ((Mouse.getEventButton() == 0 || Mouse.getEventButton() == 1) && Mouse.getEventButtonState() && mouseX > this.x + 5 + 8 && mouseX < this.x + 5 + 8 + 48 && mouseY > this.y + 5 + 64 + 5 && mouseY < this.y + 5 + 64 + 5 + 10) {
            this.hexField.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
            this.clickedComponent = -1;
            return true;
        }
        if (!Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            this.clickedComponent = -1;
        }
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            if (mouseX >= this.x && mouseX <= this.x + 119 && mouseY >= this.y && mouseY <= this.y + 89) {
                int valueOffset;
                this.hexField.unfocus();
                int xWheel = mouseX - this.x - 5;
                int yWheel = mouseY - this.y - 5;
                if (xWheel > 0 && xWheel < 64 && yWheel > 0 && yWheel < 64) {
                    this.clickedComponent = 0;
                }
                int xValue = mouseX - (this.x + 5 + 64 + 5);
                int y = mouseY - this.y - 5;
                int opacityOffset = this.opacitySlider ? 15 : 0;
                int n = valueOffset = this.valueSlider ? 15 : 0;
                if (y > -5 && y <= 69) {
                    int xOpacity;
                    if (this.valueSlider && xValue > 0 && xValue < 10) {
                        this.clickedComponent = 1;
                    }
                    if (this.opacitySlider && (xOpacity = mouseX - (this.x + 5 + 64 + 5 + valueOffset)) > 0 && xOpacity < 10) {
                        this.clickedComponent = 2;
                    }
                }
                int chromaSpeed = ChromaColour.getSpeed(this.colour);
                int xChroma = mouseX - (this.x + 5 + 64 + valueOffset + opacityOffset + 5);
                if (xChroma > 0 && xChroma < 10) {
                    if (chromaSpeed > 0) {
                        if (y > -5 && y <= 69) {
                            this.clickedComponent = 3;
                        }
                    } else if (mouseY > this.y + 5 + 27 && mouseY < this.y + 5 + 37) {
                        int currentColour = ChromaColour.specialToSimpleRGB(this.colour);
                        Color c = new Color(currentColour, true);
                        this.colour = ChromaColour.special(200, c.getAlpha(), currentColour);
                        this.colourChangedCallback.accept(this.colour);
                    }
                }
            } else {
                this.hexField.unfocus();
                this.closeCallback.run();
                return false;
            }
        }
        if (Mouse.isButtonDown((int)0) && this.clickedComponent >= 0) {
            int currentColour = ChromaColour.specialToSimpleRGB(this.colour);
            Color c = new Color(currentColour, true);
            float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            float xWheel = mouseXF - (float)this.x - 5.0f;
            float yWheel = mouseYF - (float)this.y - 5.0f;
            if (this.clickedComponent == 0) {
                float angle = (float)Math.toDegrees(Math.atan((double)(32.0f - xWheel) / ((double)(yWheel - 32.0f) + 1.0E-5)) + 1.5707963267948966);
                xWheel = Math.max(0.0f, Math.min(64.0f, xWheel));
                yWheel = Math.max(0.0f, Math.min(64.0f, yWheel));
                float radius = (float)Math.sqrt(((xWheel - 32.0f) * (xWheel - 32.0f) + (yWheel - 32.0f) * (yWheel - 32.0f)) / 1024.0f);
                if (yWheel < 32.0f) {
                    angle += 180.0f;
                }
                this.wheelAngle = angle;
                this.wheelRadius = (float)Math.pow(Math.min(1.0f, radius), 1.5);
                int rgb = Color.getHSBColor(angle / 360.0f, this.wheelRadius, hsv[2]).getRGB();
                this.colour = ChromaColour.special(ChromaColour.getSpeed(this.colour), c.getAlpha(), rgb);
                this.colourChangedCallback.accept(this.colour);
                return true;
            }
            float y = mouseYF - (float)this.y - 5.0f;
            y = Math.max(0.0f, Math.min(64.0f, y));
            if (this.clickedComponent == 1) {
                int rgb = Color.getHSBColor(this.wheelAngle / 360.0f, this.wheelRadius, 1.0f - y / 64.0f).getRGB();
                this.colour = ChromaColour.special(ChromaColour.getSpeed(this.colour), c.getAlpha(), rgb);
                this.colourChangedCallback.accept(this.colour);
                return true;
            }
            if (this.clickedComponent == 2) {
                this.colour = ChromaColour.special(ChromaColour.getSpeed(this.colour), 255 - Math.round(y / 64.0f * 255.0f), currentColour);
                this.colourChangedCallback.accept(this.colour);
                return true;
            }
            if (this.clickedComponent == 3) {
                this.colour = ChromaColour.special(255 - Math.round(y / 64.0f * 255.0f), c.getAlpha(), currentColour);
                this.colourChangedCallback.accept(this.colour);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        if (Keyboard.getEventKeyState() && this.hexField.getFocus()) {
            if (Keyboard.getEventKey() == 1) {
                this.hexField.unfocus();
                return true;
            }
            String old = this.hexField.getText();
            this.hexField.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            if (this.hexField.getText().length() > 6) {
                this.hexField.setText(old);
            } else {
                try {
                    String text = this.hexField.getText().toLowerCase();
                    int rgb = Integer.parseInt(text, 16);
                    int alpha = ChromaColour.specialToSimpleRGB(this.colour) >> 24 & 0xFF;
                    this.colour = ChromaColour.special(ChromaColour.getSpeed(this.colour), alpha, rgb);
                    this.colourChangedCallback.accept(this.colour);
                    Color c = new Color(rgb);
                    float[] hsv = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                    this.updateAngleAndRadius(hsv);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }
}

