/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.ginafro.notenoughfakepixel.config.gui.core.GlScissorStack;
import org.ginafro.notenoughfakepixel.config.gui.core.util.StringUtils;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.TextRenderUtils;

public class GuiElementTextField {
    public static final int SCISSOR_TEXT = 128;
    public static final int DISABLE_BG = 64;
    public static final int SCALE_TEXT = 32;
    public static final int NUM_ONLY = 16;
    public static final int NO_SPACE = 8;
    public static final int FORCE_CAPS = 4;
    public static final int COLOUR = 2;
    public static final int MULTILINE = 1;
    private int searchBarYSize;
    private int searchBarXSize;
    private static final int searchBarPadding = 2;
    private int options;
    private boolean focus = false;
    private int x;
    private int y;
    private String prependText = "";
    private int customTextColour = -1;
    private final GuiTextField textField;
    private int customBorderColour;
    private static final Pattern PATTERN_CONTROL_CODE = Pattern.compile("(?i)\\u00A7([^\\u00B6]|$)(?!\\u00B6)");

    public GuiElementTextField(String initialText, int options) {
        this(initialText, 100, 20, options);
    }

    public GuiElementTextField(String initialText, int sizeX, int sizeY, int options) {
        this.textField = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 0);
        this.customBorderColour = -1;
        this.textField.func_146195_b(true);
        this.textField.func_146205_d(false);
        this.textField.func_146203_f(999);
        this.textField.func_146180_a(initialText);
        this.searchBarXSize = sizeX;
        this.searchBarYSize = sizeY;
        this.options = options;
    }

    public void setMaxStringLength(int len) {
        this.textField.func_146203_f(len);
    }

    public void setCustomBorderColour(int colour) {
        this.customBorderColour = colour;
    }

    public void setCustomTextColour(int colour) {
        this.customTextColour = colour;
    }

    public String getText() {
        return this.textField.func_146179_b();
    }

    public String getTextDisplay() {
        Matcher matcher;
        String textNoColour = this.getText();
        while ((matcher = PATTERN_CONTROL_CODE.matcher(textNoColour)).find()) {
            String code = matcher.group(1);
            textNoColour = matcher.replaceFirst("\u00b6" + code);
        }
        return textNoColour;
    }

    public void setPrependText(String text) {
        this.prependText = text;
    }

    public void setText(String text) {
        if (this.textField.func_146179_b() == null || !this.textField.func_146179_b().equals(text)) {
            this.textField.func_146180_a(text);
        }
    }

    public void setSize(int searchBarXSize, int searchBarYSize) {
        this.searchBarXSize = searchBarXSize;
        this.searchBarYSize = searchBarYSize;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public String toString() {
        return this.textField.func_146179_b();
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
        if (!focus) {
            this.textField.func_146190_e(this.textField.func_146198_h());
        }
    }

    public boolean getFocus() {
        return this.focus;
    }

    public int getHeight() {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int paddingUnscaled = 2 / scaledresolution.func_78325_e();
        int numLines = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)this.textField.func_146179_b(), (CharSequence)"\n") + 1;
        int extraSize = (this.searchBarYSize - 8) / 2 + 8;
        int bottomTextBox = this.searchBarYSize + extraSize * (numLines - 1);
        return bottomTextBox + paddingUnscaled * 2;
    }

    public int getWidth() {
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int paddingUnscaled = 2 / scaledresolution.func_78325_e();
        return this.searchBarXSize + paddingUnscaled * 2;
    }

    private float getScaleFactor(String str) {
        return Math.min(1.0f, (float)(this.searchBarXSize - 2) / (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(str));
    }

    private boolean isScaling() {
        return (this.options & 0x20) != 0;
    }

    public int getCursorPos(int mouseX, int mouseY) {
        int pre;
        int padding;
        int cursorIndex;
        String code;
        Matcher matcher;
        int xComp = mouseX - this.x;
        int yComp = mouseY - this.y;
        int extraSize = (this.searchBarYSize - 8) / 2 + 8;
        String renderText = this.prependText + this.textField.func_146179_b();
        int lineNum = Math.round((yComp - (this.searchBarYSize - 8) / 2) / extraSize);
        String text = renderText;
        String textNoColour = renderText;
        if ((this.options & 2) != 0) {
            while ((matcher = PATTERN_CONTROL_CODE.matcher(text)).find() && matcher.groupCount() >= 1) {
                code = matcher.group(1);
                if (code.isEmpty()) {
                    text = matcher.replaceFirst("\u00a7r\u00b6");
                    continue;
                }
                text = matcher.replaceFirst("\u00a7" + code + "\u00b6" + code);
            }
        }
        while ((matcher = PATTERN_CONTROL_CODE.matcher(textNoColour)).find() && matcher.groupCount() >= 1) {
            code = matcher.group(1);
            textNoColour = matcher.replaceFirst("\u00b6" + code);
        }
        int currentLine = 0;
        for (cursorIndex = 0; cursorIndex < textNoColour.length() && currentLine != lineNum; ++cursorIndex) {
            if (textNoColour.charAt(cursorIndex) != '\n') continue;
            ++currentLine;
        }
        String textNC = textNoColour.substring(0, cursorIndex);
        int colorCodes = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)textNC, (CharSequence)"\u00b6");
        String line = text.substring(cursorIndex + ((this.options & 2) != 0 ? colorCodes * 2 : 0)).split("\n")[0];
        String trimmed = Minecraft.func_71410_x().field_71466_p.func_78269_a(line, xComp - (padding = Math.min(5, this.searchBarXSize - this.strLenNoColor(line)) / 2));
        int linePos = this.strLenNoColor(trimmed);
        if (linePos != this.strLenNoColor(line)) {
            int charWidth;
            char after = line.charAt(linePos);
            int trimmedWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(trimmed);
            if (trimmedWidth + (charWidth = Minecraft.func_71410_x().field_71466_p.func_78263_a(after)) / 2 < xComp - padding) {
                ++linePos;
            }
        }
        cursorIndex = (cursorIndex += linePos) < (pre = StringUtils.cleanColour(this.prependText).length()) ? 0 : (cursorIndex -= pre);
        return cursorIndex;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.textField.func_146180_a("");
        } else {
            this.textField.func_146190_e(this.getCursorPos(mouseX, mouseY));
        }
        this.focus = true;
    }

    public void unfocus() {
        this.focus = false;
        this.textField.func_146199_i(this.textField.func_146198_h());
    }

    public int strLenNoColor(String str) {
        return str.replaceAll("(?i)\\u00A7.", "").length();
    }

    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.focus) {
            this.textField.func_146199_i(this.getCursorPos(mouseX, mouseY));
        }
    }

    public void keyTyped(char typedChar, int keyCode) {
        if (this.focus) {
            if ((this.options & 1) != 0) {
                String textNCBeforeCursor;
                String code;
                Matcher matcher;
                Pattern patternControlCode = Pattern.compile("(?i)\\u00A7([^\\u00B6\n]|$)(?!\\u00B6)");
                String text = this.textField.func_146179_b();
                String textNoColour = this.textField.func_146179_b();
                while ((matcher = patternControlCode.matcher(text)).find() && matcher.groupCount() >= 1) {
                    code = matcher.group(1);
                    if (code.isEmpty()) {
                        text = matcher.replaceFirst("\u00a7r\u00b6");
                        continue;
                    }
                    text = matcher.replaceFirst("\u00a7" + code + "\u00b6" + code);
                }
                while ((matcher = patternControlCode.matcher(textNoColour)).find() && matcher.groupCount() >= 1) {
                    code = matcher.group(1);
                    textNoColour = matcher.replaceFirst("\u00b6" + code);
                }
                if (keyCode == 28) {
                    String before = this.textField.func_146179_b().substring(0, this.textField.func_146198_h());
                    String after = this.textField.func_146179_b().substring(this.textField.func_146198_h());
                    int pos = this.textField.func_146198_h();
                    this.textField.func_146180_a(before + "\n" + after);
                    this.textField.func_146190_e(pos + 1);
                    return;
                }
                if (keyCode == 200) {
                    String thisLineBeforeCursor;
                    String lineBefore;
                    int textBeforeCursorWidth;
                    textNCBeforeCursor = textNoColour.substring(0, this.textField.func_146186_n());
                    int colorCodes = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)textNCBeforeCursor, (CharSequence)"\u00b6");
                    String textBeforeCursor = text.substring(0, this.textField.func_146186_n() + colorCodes * 2);
                    int numLinesBeforeCursor = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)textBeforeCursor, (CharSequence)"\n");
                    String[] split = textBeforeCursor.split("\n");
                    if (split.length == numLinesBeforeCursor && split.length > 0) {
                        textBeforeCursorWidth = 0;
                        lineBefore = split[split.length - 1];
                        thisLineBeforeCursor = "";
                    } else if (split.length > 1) {
                        thisLineBeforeCursor = split[split.length - 1];
                        lineBefore = split[split.length - 2];
                        textBeforeCursorWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(thisLineBeforeCursor);
                    } else {
                        return;
                    }
                    String trimmed = Minecraft.func_71410_x().field_71466_p.func_78269_a(lineBefore, textBeforeCursorWidth);
                    int linePos = this.strLenNoColor(trimmed);
                    if (linePos != this.strLenNoColor(lineBefore)) {
                        int charWidth;
                        char after = lineBefore.charAt(linePos);
                        int trimmedWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(trimmed);
                        if (trimmedWidth + (charWidth = Minecraft.func_71410_x().field_71466_p.func_78263_a(after)) / 2 < textBeforeCursorWidth) {
                            ++linePos;
                        }
                    }
                    int newPos = this.textField.func_146186_n() - this.strLenNoColor(thisLineBeforeCursor) - this.strLenNoColor(lineBefore) - 1 + linePos;
                    if (GuiScreen.func_146272_n()) {
                        this.textField.func_146199_i(newPos);
                    } else {
                        this.textField.func_146190_e(newPos);
                    }
                } else if (keyCode == 208) {
                    int textBeforeCursorWidth;
                    String thisLineBeforeCursor;
                    textNCBeforeCursor = textNoColour.substring(0, this.textField.func_146186_n());
                    int colorCodes = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)textNCBeforeCursor, (CharSequence)"\u00b6");
                    String textBeforeCursor = text.substring(0, this.textField.func_146186_n() + colorCodes * 2);
                    int numLinesBeforeCursor = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)textBeforeCursor, (CharSequence)"\n");
                    String[] split = textBeforeCursor.split("\n");
                    if (split.length == numLinesBeforeCursor) {
                        thisLineBeforeCursor = "";
                        textBeforeCursorWidth = 0;
                    } else if (split.length > 0) {
                        thisLineBeforeCursor = split[split.length - 1];
                        textBeforeCursorWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(thisLineBeforeCursor);
                    } else {
                        return;
                    }
                    String[] split2 = textNoColour.split("\n");
                    if (split2.length > numLinesBeforeCursor + 1) {
                        String lineAfter = split2[numLinesBeforeCursor + 1];
                        String trimmed = Minecraft.func_71410_x().field_71466_p.func_78269_a(lineAfter, textBeforeCursorWidth);
                        int linePos = this.strLenNoColor(trimmed);
                        if (linePos != this.strLenNoColor(lineAfter)) {
                            int charWidth;
                            char after = lineAfter.charAt(linePos);
                            int trimmedWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(trimmed);
                            if (trimmedWidth + (charWidth = Minecraft.func_71410_x().field_71466_p.func_78263_a(after)) / 2 < textBeforeCursorWidth) {
                                ++linePos;
                            }
                        }
                        int newPos = this.textField.func_146186_n() - this.strLenNoColor(thisLineBeforeCursor) + this.strLenNoColor(split2[numLinesBeforeCursor]) + 1 + linePos;
                        if (GuiScreen.func_146272_n()) {
                            this.textField.func_146199_i(newPos);
                        } else {
                            this.textField.func_146190_e(newPos);
                        }
                    }
                }
            }
            String old = this.textField.func_146179_b();
            if ((this.options & 4) != 0) {
                typedChar = Character.toUpperCase(typedChar);
            }
            if ((this.options & 8) != 0 && typedChar == ' ') {
                return;
            }
            if (typedChar == '\u00b6') {
                typedChar = (char)167;
            }
            this.textField.func_146195_b(true);
            this.textField.func_146201_a(typedChar, keyCode);
            if ((this.options & 2) != 0) {
                int pos;
                String after;
                String before;
                if (typedChar == '&') {
                    int pos2 = this.textField.func_146198_h() - 2;
                    if (pos2 >= 0 && pos2 < this.textField.func_146179_b().length() && this.textField.func_146179_b().charAt(pos2) == '&') {
                        before = this.textField.func_146179_b().substring(0, pos2);
                        after = "";
                        if (pos2 + 2 < this.textField.func_146179_b().length()) {
                            after = this.textField.func_146179_b().substring(pos2 + 2);
                        }
                        this.textField.func_146180_a(before + "\u00a7" + after);
                        this.textField.func_146190_e(pos2 + 1);
                    }
                } else if (typedChar == '*' && (pos = this.textField.func_146198_h() - 2) >= 0 && pos < this.textField.func_146179_b().length() && this.textField.func_146179_b().charAt(pos) == '*') {
                    before = this.textField.func_146179_b().substring(0, pos);
                    after = "";
                    if (pos + 2 < this.textField.func_146179_b().length()) {
                        after = this.textField.func_146179_b().substring(pos + 2);
                    }
                    this.textField.func_146180_a(before + "\u272a" + after);
                    this.textField.func_146190_e(pos + 1);
                }
            }
            if ((this.options & 0x10) != 0 && this.textField.func_146179_b().matches("[^0-9.]")) {
                this.textField.func_146180_a(old);
            }
        }
    }

    public void render(int x, int y) {
        this.x = x;
        this.y = y;
        this.drawTextbox(x, y, this.searchBarXSize, this.searchBarYSize, 2, this.textField, this.focus);
    }

    private void drawTextbox(int x, int y, int searchBarXSize, int searchBarYSize, int searchBarPadding, GuiTextField textField, boolean focus) {
        String selectedText;
        String code;
        Matcher matcher;
        int borderColour;
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        String renderText = this.prependText + textField.func_146179_b();
        GlStateManager.func_179140_f();
        int paddingUnscaled = searchBarPadding / scaledresolution.func_78325_e();
        if (paddingUnscaled < 1) {
            paddingUnscaled = 1;
        }
        int numLines = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)renderText, (CharSequence)"\n") + 1;
        int extraSize = (searchBarYSize - 8) / 2 + 8;
        int bottomTextBox = y + searchBarYSize + extraSize * (numLines - 1);
        int n = borderColour = focus ? Color.GREEN.getRGB() : Color.WHITE.getRGB();
        if (this.customBorderColour != -1) {
            borderColour = this.customBorderColour;
        }
        if ((this.options & 0x40) == 0) {
            Gui.func_73734_a((int)(x - paddingUnscaled), (int)(y - paddingUnscaled), (int)(x + searchBarXSize + paddingUnscaled), (int)(bottomTextBox + paddingUnscaled), (int)borderColour);
            Gui.func_73734_a((int)x, (int)y, (int)(x + searchBarXSize), (int)bottomTextBox, (int)Color.BLACK.getRGB());
        }
        String text = renderText;
        String textNoColor = renderText;
        if ((this.options & 2) != 0) {
            while ((matcher = PATTERN_CONTROL_CODE.matcher(text)).find() && matcher.groupCount() >= 1) {
                code = matcher.group(1);
                if (code.isEmpty()) {
                    text = matcher.replaceFirst("\u00a7r\u00b6");
                    continue;
                }
                text = matcher.replaceFirst("\u00a7" + code + "\u00b6" + code);
            }
        }
        while ((matcher = PATTERN_CONTROL_CODE.matcher(textNoColor)).find() && matcher.groupCount() >= 1) {
            code = matcher.group(1);
            textNoColor = matcher.replaceFirst("\u00b6" + code);
        }
        int xStartOffset = 5;
        float scale = 1.0f;
        String[] texts = text.split("\n");
        for (int yOffI = 0; yOffI < texts.length; ++yOffI) {
            int yOff = yOffI * extraSize;
            if (this.isScaling() && Minecraft.func_71410_x().field_71466_p.func_78256_a(texts[yOffI]) > searchBarXSize - 10) {
                scale = (float)(searchBarXSize - 2) / (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(texts[yOffI]);
                if (scale > 1.0f) {
                    scale = 1.0f;
                }
                float newLen = (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(texts[yOffI]) * scale;
                xStartOffset = (int)(((float)searchBarXSize - newLen) / 2.0f);
                TextRenderUtils.drawStringCenteredScaledMaxWidth(texts[yOffI], Minecraft.func_71410_x().field_71466_p, (float)x + (float)searchBarXSize / 2.0f, (float)y + (float)searchBarYSize / 2.0f + (float)yOff, false, searchBarXSize - 2, this.customTextColour);
                continue;
            }
            if ((this.options & 0x80) != 0) {
                GlScissorStack.push(x + 5, 0, x + searchBarXSize, scaledresolution.func_78328_b(), scaledresolution);
                Minecraft.func_71410_x().field_71466_p.func_78276_b(texts[yOffI], x + 5, y + (searchBarYSize - 8) / 2 + yOff, this.customTextColour);
                GlScissorStack.pop(scaledresolution);
                continue;
            }
            String toRender = Minecraft.func_71410_x().field_71466_p.func_78269_a(texts[yOffI], searchBarXSize - 10);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(toRender, x + 5, y + (searchBarYSize - 8) / 2 + yOff, this.customTextColour);
        }
        if (focus && System.currentTimeMillis() % 1000L > 500L) {
            String textNCBeforeCursor = textNoColor.substring(0, textField.func_146198_h() + this.prependText.length());
            int colorCodes = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)textNCBeforeCursor, (CharSequence)"\u00b6");
            String textBeforeCursor = text.substring(0, textField.func_146198_h() + this.prependText.length() + ((this.options & 2) != 0 ? colorCodes * 2 : 0));
            int numLinesBeforeCursor = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)textBeforeCursor, (CharSequence)"\n");
            int yOff = numLinesBeforeCursor * extraSize;
            String[] split = textBeforeCursor.split("\n");
            int textBeforeCursorWidth = split.length <= numLinesBeforeCursor || split.length == 0 ? 0 : (int)((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(split[split.length - 1]) * scale);
            Gui.func_73734_a((int)(x + xStartOffset + textBeforeCursorWidth), (int)(y + (searchBarYSize - 8) / 2 - 1 + yOff), (int)(x + xStartOffset + textBeforeCursorWidth + 1), (int)(y + (searchBarYSize - 8) / 2 + 9 + yOff), (int)Color.WHITE.getRGB());
        }
        if (!(selectedText = textField.func_146207_c()).isEmpty()) {
            int leftIndex = Math.min(textField.func_146198_h() + this.prependText.length(), textField.func_146186_n() + this.prependText.length());
            int rightIndex = Math.max(textField.func_146198_h() + this.prependText.length(), textField.func_146186_n() + this.prependText.length());
            float texX = 0.0f;
            int texY = 0;
            boolean sectionSignPrev = false;
            boolean ignoreNext = false;
            boolean bold = false;
            for (int i = 0; i < textNoColor.length(); ++i) {
                if (ignoreNext) {
                    ignoreNext = false;
                    continue;
                }
                char c = textNoColor.charAt(i);
                if (sectionSignPrev) {
                    if (c != 'k' && c != 'K' && c != 'm' && c != 'M' && c != 'n' && c != 'N' && c != 'o' && c != 'O') {
                        bold = c == 'l' || c == 'L';
                    }
                    sectionSignPrev = false;
                    if (i < this.prependText.length()) continue;
                }
                if (c == '\u00b6') {
                    sectionSignPrev = true;
                    if (i < this.prependText.length()) continue;
                }
                if (c == '\n') {
                    if (i >= leftIndex && i < rightIndex) {
                        Gui.func_73734_a((int)(x + xStartOffset + (int)texX), (int)(y + (searchBarYSize - 8) / 2 - 1 + texY), (int)(x + xStartOffset + (int)texX + 3), (int)(y + (searchBarYSize - 8) / 2 + 9 + texY), (int)Color.LIGHT_GRAY.getRGB());
                    }
                    texX = 0.0f;
                    texY += extraSize;
                    continue;
                }
                int len = Minecraft.func_71410_x().field_71466_p.func_78256_a(String.valueOf(c));
                if (bold) {
                    ++len;
                }
                if (i >= leftIndex && i < rightIndex) {
                    Gui.func_73734_a((int)(x + xStartOffset + (int)texX), (int)(y + (searchBarYSize - 8) / 2 - 1 + texY), (int)(x + xStartOffset + (int)(texX + (float)len * scale)), (int)(y + (searchBarYSize - 8) / 2 + 9 + texY), (int)Color.LIGHT_GRAY.getRGB());
                    TextRenderUtils.drawStringScaled(String.valueOf(c), Minecraft.func_71410_x().field_71466_p, (float)(x + xStartOffset) + texX, (float)y + (float)searchBarYSize / 2.0f - scale * 8.0f / 2.0f + (float)texY, false, Color.BLACK.getRGB(), scale);
                    if (bold) {
                        TextRenderUtils.drawStringScaled(String.valueOf(c), Minecraft.func_71410_x().field_71466_p, (float)(x + xStartOffset) + texX + 1.0f, (float)y + (float)searchBarYSize / 2.0f - scale * 8.0f / 2.0f + (float)texY, false, Color.BLACK.getRGB(), scale);
                    }
                }
                texX += (float)len * scale;
            }
        }
    }
}

