/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core.config.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import org.ginafro.notenoughfakepixel.config.gui.GuiTextures;
import org.ginafro.notenoughfakepixel.config.gui.core.ChromaColour;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiElementColour;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditor;
import org.ginafro.notenoughfakepixel.config.gui.core.config.struct.ConfigProcessor;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.RenderUtils;
import org.lwjgl.input.Mouse;

public class GuiOptionEditorColour
extends GuiOptionEditor {
    private String chromaColour;
    private GuiElementColour colourElement = null;

    public GuiOptionEditorColour(ConfigProcessor.ProcessedOption option) {
        super(option);
        this.chromaColour = (String)option.get();
    }

    @Override
    public void render(int x, int y, int width) {
        super.render(x, y, width);
        int height = this.getHeight();
        int argb = ChromaColour.specialToChromaRGB(this.chromaColour);
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.button_white);
        RenderUtils.drawTexturedRect(x + width / 6 - 24, y + height - 7 - 14, 48.0f, 16.0f);
    }

    @Override
    public void renderOverlay(int x, int y, int width) {
        if (this.colourElement != null) {
            this.colourElement.render();
        }
    }

    @Override
    public boolean mouseInputOverlay(int x, int y, int width, int mouseX, int mouseY) {
        return this.colourElement != null && this.colourElement.mouseInput(mouseX, mouseY);
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        int height = this.getHeight();
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0 && mouseX > x + width / 6 - 24 && mouseX < x + width / 6 + 24 && mouseY > y + height - 7 - 14 && mouseY < y + height - 7 + 2) {
            this.colourElement = new GuiElementColour(mouseX, mouseY, (String)this.option.get(), val -> {
                this.option.set(val);
                this.chromaColour = val;
            }, () -> {
                this.colourElement = null;
            });
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        return this.colourElement != null && this.colourElement.keyboardInput();
    }
}

