/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core.config.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditor;
import org.ginafro.notenoughfakepixel.config.gui.core.config.struct.ConfigProcessor;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.RenderUtils;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.TextRenderUtils;
import org.lwjgl.input.Mouse;

public class GuiOptionEditorDropdown
extends GuiOptionEditor {
    protected final String[] values;
    private final boolean useOrdinal;
    protected int selected;
    protected boolean open = false;

    public GuiOptionEditorDropdown(ConfigProcessor.ProcessedOption option, String[] values, int selected, boolean useOrdinal) {
        super(option);
        if (selected >= values.length) {
            selected = values.length;
        }
        this.values = values;
        this.selected = selected;
        this.useOrdinal = useOrdinal;
    }

    @Override
    public void render(int x, int y, int width) {
        super.render(x, y, width);
        if (!this.open) {
            int height = this.getHeight();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int dropdownWidth = Math.min(width / 3 - 10, 80);
            int left = x + width / 6 - dropdownWidth / 2;
            int top = y + height - 7 - 14;
            String selectedString = " - Select - ";
            if (this.selected >= 0 && this.selected < this.values.length) {
                selectedString = this.values[this.selected];
            }
            RenderUtils.drawFloatingRectDark(left, top, dropdownWidth, 14, false);
            TextRenderUtils.drawStringScaled("\u25bc", fr, left + dropdownWidth - 10, y + height - 7 - 15, false, -6250336, 2.0f);
            TextRenderUtils.drawStringScaledMaxWidth(selectedString, fr, left + 3, top + 3, false, dropdownWidth - 16, -6250336);
        }
    }

    @Override
    public void renderOverlay(int x, int y, int width) {
        if (this.open) {
            String selectedString = " - Select - ";
            if (this.selected >= 0 && this.selected < this.values.length) {
                selectedString = this.values[this.selected];
            }
            int height = this.getHeight();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int dropdownWidth = Math.min(width / 3 - 10, 80);
            int left = x + width / 6 - dropdownWidth / 2;
            int top = y + height - 7 - 14;
            int dropdownHeight = 13 + 12 * this.values.length;
            int main = -14671834;
            int blue = -14461523;
            Gui.func_73734_a((int)left, (int)top, (int)(left + 1), (int)(top + dropdownHeight), (int)blue);
            Gui.func_73734_a((int)(left + 1), (int)top, (int)(left + dropdownWidth), (int)(top + 1), (int)blue);
            Gui.func_73734_a((int)(left + dropdownWidth - 1), (int)(top + 1), (int)(left + dropdownWidth), (int)(top + dropdownHeight), (int)blue);
            Gui.func_73734_a((int)(left + 1), (int)(top + dropdownHeight - 1), (int)(left + dropdownWidth - 1), (int)(top + dropdownHeight), (int)blue);
            Gui.func_73734_a((int)(left + 1), (int)(top + 1), (int)(left + dropdownWidth - 1), (int)(top + dropdownHeight - 1), (int)main);
            Gui.func_73734_a((int)(left + 1), (int)(top + 14 - 1), (int)(left + dropdownWidth - 1), (int)(top + 14), (int)blue);
            int dropdownY = 13;
            for (String option : this.values) {
                if (option.isEmpty()) {
                    option = "<NONE>";
                }
                TextRenderUtils.drawStringScaledMaxWidth(option, fr, left + 3, top + 3 + dropdownY, false, dropdownWidth - 6, -6250336);
                dropdownY += 12;
            }
            TextRenderUtils.drawStringScaled("\u25b2", fr, left + dropdownWidth - 10, y + height - 7 - 15, false, -6250336, 2.0f);
            TextRenderUtils.drawStringScaledMaxWidth(selectedString, fr, left + 3, top + 3, false, dropdownWidth - 16, -6250336);
        }
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        int height = this.getHeight();
        int left = x + width / 6 - 40;
        int top = y + height - 7 - 14;
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0 && mouseX >= left && mouseX <= left + 80 && mouseY >= top && mouseY <= top + 14) {
            this.open = !this.open;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseInputOverlay(int x, int y, int width, int mouseX, int mouseY) {
        int height = this.getHeight();
        int left = x + width / 6 - 40;
        int top = y + height - 7 - 14;
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0 && (mouseX < left || mouseX > left + 80 || mouseY < top || mouseY > top + 14) && this.open) {
            this.open = false;
            if (mouseX >= left && mouseX <= left + 80) {
                int dropdownY = 13;
                for (int ordinal = 0; ordinal < this.values.length; ++ordinal) {
                    if (mouseY >= top + 3 + dropdownY && mouseY <= top + 3 + dropdownY + 12) {
                        this.selected = ordinal;
                        if (this.useOrdinal) {
                            this.option.set(this.selected);
                        } else {
                            this.option.set(this.values[this.selected]);
                        }
                        return true;
                    }
                    dropdownY += 12;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        return false;
    }
}

