/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core.config.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.ginafro.notenoughfakepixel.config.gui.GuiTextures;
import org.ginafro.notenoughfakepixel.config.gui.core.config.KeybindHelper;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditor;
import org.ginafro.notenoughfakepixel.config.gui.core.config.struct.ConfigProcessor;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.RenderUtils;
import org.ginafro.notenoughfakepixel.config.gui.core.util.render.TextRenderUtils;
import org.ginafro.notenoughfakepixel.variables.Resources;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiOptionEditorKeybind
extends GuiOptionEditor {
    private static final ResourceLocation RESET = Resources.RESET.getResource();
    private int keyCode;
    private final int defaultKeyCode;
    private boolean editingKeycode;

    public GuiOptionEditorKeybind(ConfigProcessor.ProcessedOption option, int keyCode, int defaultKeyCode) {
        super(option);
        this.keyCode = keyCode;
        this.defaultKeyCode = defaultKeyCode;
    }

    @Override
    public void render(int x, int y, int width) {
        super.render(x, y, width);
        int height = this.getHeight();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.button_tex);
        RenderUtils.drawTexturedRect(x + width / 6 - 24, y + height - 7 - 14, 48.0f, 16.0f);
        String keyName = KeybindHelper.getKeyName(this.keyCode);
        String text = this.editingKeycode ? "> " + keyName + " <" : keyName;
        TextRenderUtils.drawStringCenteredScaledMaxWidth(text, Minecraft.func_71410_x().field_71466_p, x + width / 6, y + height - 7 - 6, false, 40, -13619152);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(RESET);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawTexturedRect(x + width / 6 - 24 + 48 + 3, y + height - 7 - 14 + 3, 10.0f, 11.0f, 9728);
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        if (Mouse.getEventButtonState() && Mouse.getEventButton() != -1 && this.editingKeycode) {
            this.editingKeycode = false;
            this.keyCode = Mouse.getEventButton() - 100;
            this.option.set(this.keyCode);
            return true;
        }
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            int height = this.getHeight();
            if (mouseX > x + width / 6 - 24 && mouseX < x + width / 6 + 24 && mouseY > y + height - 7 - 14 && mouseY < y + height - 7 + 2) {
                this.editingKeycode = true;
                return true;
            }
            if (mouseX > x + width / 6 - 24 + 48 + 3 && mouseX < x + width / 6 - 24 + 48 + 13 && mouseY > y + height - 7 - 14 + 3 && mouseY < y + height - 7 - 14 + 3 + 11) {
                this.keyCode = this.defaultKeyCode;
                this.option.set(this.keyCode);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        if (this.editingKeycode) {
            this.editingKeycode = false;
            this.keyCode = Keyboard.getEventKey() == 1 ? 0 : (Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey());
            this.option.set(this.keyCode);
            return true;
        }
        return false;
    }
}

