/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core.config.gui;

import net.minecraft.client.Minecraft;
import org.ginafro.notenoughfakepixel.config.gui.core.GuiElementTextField;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditor;
import org.ginafro.notenoughfakepixel.config.gui.core.config.struct.ConfigProcessor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiOptionEditorText
extends GuiOptionEditor {
    private final GuiElementTextField textField;

    public GuiOptionEditorText(ConfigProcessor.ProcessedOption option) {
        super(option);
        this.textField = new GuiElementTextField((String)option.get(), 0);
    }

    @Override
    public void render(int x, int y, int width) {
        super.render(x, y, width);
        int height = this.getHeight();
        int fullWidth = Math.min(width / 3 - 10, 80);
        int textFieldX = x + width / 6 - fullWidth / 2;
        if (this.textField.getFocus()) {
            fullWidth = Math.max(fullWidth, Minecraft.func_71410_x().field_71466_p.func_78256_a(this.textField.getText()) + 10);
        }
        this.textField.setSize(fullWidth, 16);
        this.textField.render(textFieldX, y + height - 7 - 14);
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        int height = this.getHeight();
        int fullWidth = Math.min(width / 3 - 10, 80);
        int textFieldX = x + width / 6 - fullWidth / 2;
        if (this.textField.getFocus()) {
            fullWidth = Math.max(fullWidth, Minecraft.func_71410_x().field_71466_p.func_78256_a(this.textField.getText()) + 10);
        }
        int textFieldY = y + height - 7 - 14;
        this.textField.setSize(fullWidth, 16);
        if (Mouse.getEventButtonState() && (Mouse.getEventButton() == 0 || Mouse.getEventButton() == 1)) {
            if (mouseX > textFieldX && mouseX < textFieldX + fullWidth && mouseY > textFieldY && mouseY < textFieldY + 16) {
                this.textField.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                return true;
            }
            this.textField.unfocus();
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        if (Keyboard.getEventKeyState() && this.textField.getFocus()) {
            Keyboard.enableRepeatEvents((boolean)true);
            this.textField.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            try {
                this.textField.setCustomBorderColour(-1);
                this.option.set(this.textField.getText());
            }
            catch (Exception e) {
                this.textField.setCustomBorderColour(-65536);
            }
            return true;
        }
        return false;
    }
}

