/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core.config.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import org.ginafro.notenoughfakepixel.config.gui.core.config.Position;
import org.ginafro.notenoughfakepixel.config.gui.utils.Utils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiPositionEditor
extends GuiScreen {
    private final Position position;
    private final Position originalPosition;
    private final int elementWidth;
    private final int elementHeight;
    private final Runnable renderCallback;
    private final Runnable positionChangedCallback;
    private final Runnable closedCallback;
    private boolean clicked = false;
    private int grabbedX = 0;
    private int grabbedY = 0;
    private int guiScaleOverride = -1;

    public GuiPositionEditor(Position position, int elementWidth, int elementHeight, Runnable renderCallback, Runnable positionChangedCallback, Runnable closedCallback) {
        this.position = position;
        this.originalPosition = position.clone();
        this.elementWidth = elementWidth;
        this.elementHeight = elementHeight;
        this.renderCallback = renderCallback;
        this.positionChangedCallback = positionChangedCallback;
        this.closedCallback = closedCallback;
    }

    public GuiPositionEditor withScale(int scale) {
        this.guiScaleOverride = scale;
        return this;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.closedCallback.run();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ScaledResolution scaledResolution = this.guiScaleOverride >= 0 ? Utils.pushGuiScale(this.guiScaleOverride) : new ScaledResolution(Minecraft.func_71410_x());
        this.field_146294_l = scaledResolution.func_78326_a();
        this.field_146295_m = scaledResolution.func_78328_b();
        mouseX = Mouse.getX() * this.field_146294_l / Minecraft.func_71410_x().field_71443_c;
        mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
        this.func_146276_q_();
        if (this.clicked) {
            this.grabbedX += this.position.moveX(mouseX - this.grabbedX, this.elementWidth, scaledResolution);
            this.grabbedY += this.position.moveY(mouseY - this.grabbedY, this.elementHeight, scaledResolution);
        }
        this.renderCallback.run();
        int x = this.position.getAbsX(scaledResolution, this.elementWidth);
        int y = this.position.getAbsY(scaledResolution, this.elementHeight);
        if (this.position.isCenterX()) {
            x -= this.elementWidth / 2;
        }
        if (this.position.isCenterY()) {
            y -= this.elementHeight / 2;
        }
        Gui.func_73734_a((int)x, (int)y, (int)(x + this.elementWidth), (int)(y + this.elementHeight), (int)-2143272896);
        if (this.guiScaleOverride >= 0) {
            Utils.pushGuiScale(-1);
        }
        scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        Utils.drawStringCentered("Position Editor", Minecraft.func_71410_x().field_71466_p, scaledResolution.func_78326_a() / 2, 8.0f, true, 0xFFFFFF);
        Utils.drawStringCentered("R to Reset - Arrow keys/mouse to move", Minecraft.func_71410_x().field_71466_p, scaledResolution.func_78326_a() / 2, 18.0f, true, 0xFFFFFF);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            ScaledResolution scaledResolution = this.guiScaleOverride >= 0 ? Utils.pushGuiScale(this.guiScaleOverride) : new ScaledResolution(Minecraft.func_71410_x());
            mouseX = Mouse.getX() * this.field_146294_l / Minecraft.func_71410_x().field_71443_c;
            mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
            int x = this.position.getAbsX(scaledResolution, this.elementWidth);
            int y = this.position.getAbsY(scaledResolution, this.elementHeight);
            if (this.position.isCenterX()) {
                x -= this.elementWidth / 2;
            }
            if (this.position.isCenterY()) {
                y -= this.elementHeight / 2;
            }
            if (mouseX >= x && mouseY >= y && mouseX <= x + this.elementWidth && mouseY <= y + this.elementHeight) {
                this.clicked = true;
                this.grabbedX = mouseX;
                this.grabbedY = mouseY;
            }
            if (this.guiScaleOverride >= 0) {
                Utils.pushGuiScale(-1);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        Keyboard.enableRepeatEvents((boolean)true);
        if (keyCode == 19) {
            this.position.set(this.originalPosition);
        } else if (!this.clicked) {
            int dist;
            boolean shiftHeld = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            int n = dist = shiftHeld ? 10 : 1;
            if (keyCode == 208) {
                this.position.moveY(dist, this.elementHeight, new ScaledResolution(Minecraft.func_71410_x()));
            } else if (keyCode == 200) {
                this.position.moveY(-dist, this.elementHeight, new ScaledResolution(Minecraft.func_71410_x()));
            } else if (keyCode == 203) {
                this.position.moveX(-dist, this.elementWidth, new ScaledResolution(Minecraft.func_71410_x()));
            } else if (keyCode == 205) {
                this.position.moveX(dist, this.elementWidth, new ScaledResolution(Minecraft.func_71410_x()));
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.clicked = false;
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.clicked) {
            ScaledResolution scaledResolution = this.guiScaleOverride >= 0 ? Utils.pushGuiScale(this.guiScaleOverride) : new ScaledResolution(Minecraft.func_71410_x());
            mouseX = Mouse.getX() * this.field_146294_l / Minecraft.func_71410_x().field_71443_c;
            mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
            this.grabbedX += this.position.moveX(mouseX - this.grabbedX, this.elementWidth, scaledResolution);
            this.grabbedY += this.position.moveY(mouseY - this.grabbedY, this.elementHeight, scaledResolution);
            this.positionChangedCallback.run();
            if (this.guiScaleOverride >= 0) {
                Utils.pushGuiScale(-1);
            }
        }
    }
}

