/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.core.config.struct;

import com.google.gson.annotations.Expose;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.Category;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigAccordionId;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorAccordion;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorBoolean;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorButton;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorColour;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorDraggableList;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorDropdown;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorKeybind;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorSlider;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorStyle;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigEditorText;
import org.ginafro.notenoughfakepixel.config.gui.core.config.annotations.ConfigOption;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditor;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorAccordion;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorBoolean;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorButton;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorColour;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorDraggableList;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorDropdown;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorKeybind;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorSlider;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorStyle;
import org.ginafro.notenoughfakepixel.config.gui.core.config.gui.GuiOptionEditorText;

public class ConfigProcessor {
    public static LinkedHashMap<String, ProcessedCategory> create(Configuration config) {
        LinkedHashMap<String, ProcessedCategory> processedConfig = new LinkedHashMap<String, ProcessedCategory>();
        for (Field categoryField : config.getClass().getDeclaredFields()) {
            boolean exposePresent = categoryField.isAnnotationPresent(Expose.class);
            boolean categoryPresent = categoryField.isAnnotationPresent(Category.class);
            if (exposePresent && categoryPresent) {
                Object categoryObj;
                try {
                    categoryObj = categoryField.get(config);
                }
                catch (Exception e) {
                    continue;
                }
                Category categoryAnnotation = categoryField.getAnnotation(Category.class);
                ProcessedCategory cat = new ProcessedCategory(categoryAnnotation.name(), categoryAnnotation.desc());
                processedConfig.put(categoryField.getName(), cat);
                for (Field optionField : categoryObj.getClass().getDeclaredFields()) {
                    Annotation configEditorAnnotation;
                    boolean optionPresent = optionField.isAnnotationPresent(ConfigOption.class);
                    if (!optionPresent) continue;
                    ConfigOption optionAnnotation = optionField.getAnnotation(ConfigOption.class);
                    ProcessedOption option = new ProcessedOption(optionAnnotation.name(), optionAnnotation.desc(), optionAnnotation.subcategoryId(), optionField, categoryObj);
                    if (optionField.isAnnotationPresent(ConfigAccordionId.class)) {
                        ConfigAccordionId annotation = optionField.getAnnotation(ConfigAccordionId.class);
                        option.accordionId = annotation.id();
                    }
                    GuiOptionEditor editor = null;
                    Class<Object> optionType = optionField.getType();
                    if (optionType.isAssignableFrom(Integer.TYPE) && optionField.isAnnotationPresent(ConfigEditorKeybind.class)) {
                        configEditorAnnotation = optionField.getAnnotation(ConfigEditorKeybind.class);
                        editor = new GuiOptionEditorKeybind(option, (Integer)option.get(), configEditorAnnotation.defaultKey());
                    }
                    if (optionField.isAnnotationPresent(ConfigEditorButton.class)) {
                        configEditorAnnotation = optionField.getAnnotation(ConfigEditorButton.class);
                        editor = new GuiOptionEditorButton(option, configEditorAnnotation.runnableId(), configEditorAnnotation.buttonText(), config);
                    }
                    if (optionType.isAssignableFrom(Boolean.TYPE) && optionField.isAnnotationPresent(ConfigEditorBoolean.class)) {
                        editor = new GuiOptionEditorBoolean(option);
                    }
                    if (optionType.isAssignableFrom(Boolean.TYPE) && optionField.isAnnotationPresent(ConfigEditorAccordion.class)) {
                        configEditorAnnotation = optionField.getAnnotation(ConfigEditorAccordion.class);
                        editor = new GuiOptionEditorAccordion(option, configEditorAnnotation.id());
                    }
                    if (optionType.isAssignableFrom(Integer.TYPE)) {
                        if (optionField.isAnnotationPresent(ConfigEditorDropdown.class)) {
                            configEditorAnnotation = optionField.getAnnotation(ConfigEditorDropdown.class);
                            editor = new GuiOptionEditorDropdown(option, configEditorAnnotation.values(), (Integer)option.get(), true);
                        } else if (optionField.isAnnotationPresent(ConfigEditorStyle.class)) {
                            editor = new GuiOptionEditorStyle(option, (Integer)option.get());
                        }
                    }
                    if (optionType.isAssignableFrom(List.class) && optionField.isAnnotationPresent(ConfigEditorDraggableList.class)) {
                        configEditorAnnotation = optionField.getAnnotation(ConfigEditorDraggableList.class);
                        editor = new GuiOptionEditorDraggableList(option, configEditorAnnotation.exampleText());
                    }
                    if (optionType.isAssignableFrom(String.class)) {
                        if (optionField.isAnnotationPresent(ConfigEditorDropdown.class)) {
                            configEditorAnnotation = optionField.getAnnotation(ConfigEditorDropdown.class);
                            editor = new GuiOptionEditorDropdown(option, configEditorAnnotation.values(), configEditorAnnotation.initialIndex(), false);
                        } else if (optionField.isAnnotationPresent(ConfigEditorColour.class)) {
                            editor = new GuiOptionEditorColour(option);
                        } else if (optionField.isAnnotationPresent(ConfigEditorText.class)) {
                            editor = new GuiOptionEditorText(option);
                        }
                    }
                    if ((optionType.isAssignableFrom(Integer.TYPE) || optionType.isAssignableFrom(Float.TYPE) || optionType.isAssignableFrom(Double.TYPE)) && optionField.isAnnotationPresent(ConfigEditorSlider.class)) {
                        configEditorAnnotation = optionField.getAnnotation(ConfigEditorSlider.class);
                        editor = new GuiOptionEditorSlider(option, configEditorAnnotation.minValue(), configEditorAnnotation.maxValue(), configEditorAnnotation.minStep());
                    }
                    if (optionType.isAssignableFrom(String.class) && optionField.isAnnotationPresent(ConfigEditorDropdown.class)) {
                        configEditorAnnotation = optionField.getAnnotation(ConfigEditorDropdown.class);
                        editor = new GuiOptionEditorDropdown(option, configEditorAnnotation.values(), 0, false);
                    }
                    if (editor == null) continue;
                    option.editor = editor;
                    cat.options.put(optionField.getName(), option);
                }
                continue;
            }
            if (!exposePresent && !categoryPresent) continue;
        }
        return processedConfig;
    }

    public static class ProcessedOption {
        public final String name;
        public final String desc;
        public final int subcategoryId;
        public GuiOptionEditor editor;
        public int accordionId = -1;
        private final Field field;
        private final Object container;

        public ProcessedOption(String name, String desc, int subcategoryId, Field field, Object container) {
            this.name = name;
            this.desc = desc;
            this.subcategoryId = subcategoryId;
            this.field = field;
            this.container = container;
        }

        public Object get() {
            try {
                return this.field.get(this.container);
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean set(Object value) {
            try {
                if (this.field.getType() == Integer.TYPE && value instanceof Number) {
                    this.field.set(this.container, ((Number)value).intValue());
                } else {
                    this.field.set(this.container, value);
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    public static class ProcessedCategory {
        public final String name;
        public final String desc;
        public final LinkedHashMap<String, ProcessedOption> options = new LinkedHashMap();

        public ProcessedCategory(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

