/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.config.gui.utils;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.nio.FloatBuffer;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class Utils {
    private static final LinkedList<Integer> guiScales = new LinkedList();
    private static ScaledResolution lastScale = new ScaledResolution(Minecraft.func_71410_x());
    private static final FloatBuffer projectionMatrixOld = BufferUtils.createFloatBuffer((int)16);
    private static final FloatBuffer modelviewMatrixOld = BufferUtils.createFloatBuffer((int)16);

    public static boolean overlayShouldRender(RenderGameOverlayEvent.ElementType type, boolean ... booleans) {
        return Utils.overlayShouldRender(false, type, RenderGameOverlayEvent.ElementType.HOTBAR, booleans);
    }

    public static boolean overlayShouldRender(boolean hideOnf3, RenderGameOverlayEvent.ElementType type, RenderGameOverlayEvent.ElementType checkType, boolean ... booleans) {
        Minecraft mc = Minecraft.func_71410_x();
        for (boolean aBoolean : booleans) {
            if (aBoolean) continue;
            return false;
        }
        if (hideOnf3 && (mc.field_71474_y.field_74330_P || mc.field_71474_y.field_74321_H.func_151470_d() && (!mc.func_71387_A() || mc.field_71439_g.field_71174_a.func_175106_d().size() > 1))) {
            return false;
        }
        return type == null && Loader.isModLoaded((String)"labymod") || type == checkType;
    }

    public static void drawStringScaledMaxWidth(String str, FontRenderer fr, float x, float y, boolean shadow, int len, int colour) {
        int strLen = fr.func_78256_a(str);
        float factor = (float)len / (float)strLen;
        factor = Math.min(1.0f, factor);
        Utils.drawStringScaled(str, fr, x, y, shadow, colour, factor);
    }

    public static void drawStringScaled(String str, FontRenderer fr, float x, float y, boolean shadow, int colour, float factor) {
        GlStateManager.func_179152_a((float)factor, (float)factor, (float)1.0f);
        fr.func_175065_a(str, x / factor, y / factor, colour, shadow);
        GlStateManager.func_179152_a((float)(1.0f / factor), (float)(1.0f / factor), (float)1.0f);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax, int filter) {
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181673_a((double)uMin, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)uMax, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a((double)uMax, (double)vMin).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_181673_a((double)uMin, (double)vMin).func_181675_d();
        tessellator.func_78381_a();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRect(float x, float y, float width, float height) {
        Utils.drawTexturedRect(x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, int filter) {
        Utils.drawTexturedRect(x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f, filter);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax) {
        Utils.drawTexturedRect(x, y, width, height, uMin, uMax, vMin, vMax, 9729);
    }

    public static void resetGuiScale() {
        guiScales.clear();
    }

    public static ScaledResolution peekGuiScale() {
        return lastScale;
    }

    public static ScaledResolution pushGuiScale(int scale) {
        int newScale;
        if (guiScales.size() == 0 && Loader.isModLoaded((String)"labymod")) {
            GL11.glGetFloat((int)2983, (FloatBuffer)projectionMatrixOld);
            GL11.glGetFloat((int)2982, (FloatBuffer)modelviewMatrixOld);
        }
        if (scale < 0) {
            if (guiScales.size() > 0) {
                guiScales.pop();
            }
        } else if (scale == 0) {
            guiScales.push(Minecraft.func_71410_x().field_71474_y.field_74335_Z);
        } else {
            guiScales.push(scale);
        }
        int n = newScale = guiScales.size() > 0 ? Math.max(0, Math.min(4, guiScales.peek())) : Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        if (newScale == 0) {
            newScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        }
        int oldScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        Minecraft.func_71410_x().field_71474_y.field_74335_Z = newScale;
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        Minecraft.func_71410_x().field_71474_y.field_74335_Z = oldScale;
        if (guiScales.size() > 0) {
            GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        } else if (Loader.isModLoaded((String)"labymod") && projectionMatrixOld.limit() > 0 && modelviewMatrixOld.limit() > 0) {
            GlStateManager.func_179128_n((int)5889);
            GL11.glLoadMatrix((FloatBuffer)projectionMatrixOld);
            GlStateManager.func_179128_n((int)5888);
            GL11.glLoadMatrix((FloatBuffer)modelviewMatrixOld);
        } else {
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        }
        lastScale = scaledresolution;
        return scaledresolution;
    }

    public static void drawStringCentered(String str, FontRenderer fr, float x, float y, boolean shadow, int colour) {
        int strLen = fr.func_78256_a(str);
        float x2 = x - (float)strLen / 2.0f;
        float y2 = y - (float)fr.field_78288_b / 2.0f;
        GL11.glTranslatef((float)x2, (float)y2, (float)0.0f);
        fr.func_175065_a(str, 0.0f, 0.0f, colour, shadow);
        GL11.glTranslatef((float)(-x2), (float)(-y2), (float)0.0f);
    }

    public static void copyToClipboard(String str) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(str), null);
    }
}

