/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.envcheck;

import java.lang.reflect.Field;
import java.util.Objects;
import javax.swing.JOptionPane;

public class ForgeScan {
    static boolean shouldCheckOnce = true;

    private ForgeScan() {
    }

    public static void checkEnvironmentOnce() {
        if (shouldCheckOnce) {
            ForgeScan.checkEnvironment();
        }
    }

    static void checkEnvironment() {
        shouldCheckOnce = false;
        ForgeScan.checkForgeEnvironment();
    }

    static Class<?> tryToGetClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static boolean isAtLeast(Object left, int right) {
        if (left instanceof Integer) {
            return (Integer)left >= right;
        }
        return false;
    }

    static Object tryToGetField(Class<?> clazz, Object inst, String name) {
        if (clazz == null) {
            return null;
        }
        try {
            Field declaredField = clazz.getDeclaredField(name);
            return declaredField.get(inst);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    static void missingOrOutdatedForgeError() {
        ForgeScan.showErrorMessage("You just launched NotEnoughFakepixel with the wrong (or no) modloader installed.", "", "NotEnoughFakepixel only works in Minecraft 1.8.9, with Forge 11.15.1+", "Please relaunch NotEnoughFakepixel in the correct environment.", "If you are using Minecraft 1.8.9 with Forge 11.15.1+ installed, please contact support.", "Click OK to launch anyways.");
    }

    public static void showErrorMessage(String ... messages) {
        String message = String.join((CharSequence)"\n", messages);
        System.setProperty("java.awt.headless", "false");
        JOptionPane.showMessageDialog(null, message, "NotEnoughFakepixel - Problematic System Configuration", 0);
    }

    static void checkForgeEnvironment() {
        Class<?> forgeVersion = ForgeScan.tryToGetClass("net.minecraftforge.common.ForgeVersion");
        if (!(forgeVersion != null && Objects.equals(ForgeScan.tryToGetField(forgeVersion, null, "majorVersion"), 11) && Objects.equals(ForgeScan.tryToGetField(forgeVersion, null, "minorVersion"), 15) && ForgeScan.isAtLeast(ForgeScan.tryToGetField(forgeVersion, null, "revisionVersion"), 1) && Objects.equals(ForgeScan.tryToGetField(forgeVersion, null, "mcVersion"), "1.8.9"))) {
            System.out.printf("Forge Version : %s%nMajor : %s%nMinor : %s%nRevision : %s%nMinecraft : %s%n", forgeVersion, ForgeScan.tryToGetField(forgeVersion, null, "majorVersion"), ForgeScan.tryToGetField(forgeVersion, null, "minorVersion"), ForgeScan.tryToGetField(forgeVersion, null, "revisionVersion"), ForgeScan.tryToGetField(forgeVersion, null, "mcVersion"));
            ForgeScan.missingOrOutdatedForgeError();
        }
    }
}

