/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.events.handlers;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.ginafro.notenoughfakepixel.utils.ConfigHandler;
import org.ginafro.notenoughfakepixel.utils.Logger;

public class RepoHandler {
    private static final long TTL_MS = TimeUnit.DAYS.toMillis(1L);
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private static final String USER_AGENT = "YourModName/1.0 (Minecraft 1.8.9)";
    private static final ExecutorService IO_POOL = new ThreadPoolExecutor(1, 2, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(64), r -> {
        Thread t = new Thread(r, "RepoHandler-IO-Pool");
        t.setDaemon(true);
        return t;
    }, new ThreadPoolExecutor.DiscardOldestPolicy());
    private static final ScheduledExecutorService EXEC = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "RepoHandler-IO");
        t.setDaemon(true);
        return t;
    });
    private static final Gson gson = ConfigHandler.GSON;
    private static final ConcurrentMap<String, SourceState> SOURCES = new ConcurrentHashMap<String, SourceState>();
    private static final ConcurrentMap<String, ConcurrentMap<Type, ParsedCache>> PARSED = new ConcurrentHashMap<String, ConcurrentMap<Type, ParsedCache>>();

    private RepoHandler() {
    }

    public static void registerSource(String key, String url, long ttlMs) {
        SOURCES.compute(key, (k, prev) -> {
            if (prev == null) {
                return new SourceState(url, ttlMs);
            }
            prev.lastFetch = 0L;
            prev.etag = null;
            prev.lastModified = null;
            return new SourceState(url, ttlMs);
        });
    }

    public static void warmupAllAsync() {
        for (Map.Entry e : SOURCES.entrySet()) {
            RepoHandler.loadIfStaleAsync((String)e.getKey(), false);
        }
    }

    public static void refreshAsync(Set<String> keys) {
        for (String k : keys) {
            RepoHandler.loadIfStaleAsync(k, true);
        }
    }

    public static void ensureLoadedAsync(String key) {
        RepoHandler.loadIfStaleAsync(key, true);
    }

    public static boolean isLoaded(String key) {
        SourceState s = (SourceState)SOURCES.get(key);
        return s != null && s.json.get() != null;
    }

    public static String getJson(String key) {
        SourceState s = (SourceState)SOURCES.get(key);
        return s == null ? null : s.json.get();
    }

    public static <T> T getAs(String key, Class<T> type) {
        String raw = RepoHandler.getJson(key);
        if (raw == null) {
            return null;
        }
        try {
            return (T)gson.fromJson(raw, type);
        }
        catch (Exception ex) {
            Logger.logErrorConsole("JSON parse error (" + key + "): " + ex.getMessage());
            return null;
        }
    }

    public static void shutdown() {
        IO_POOL.shutdownNow();
    }

    private static void loadIfStaleAsync(String key, boolean forceIfExpired) {
        boolean expired;
        SourceState s = (SourceState)SOURCES.get(key);
        if (s == null) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean bl = expired = now - s.lastFetch >= s.ttlMs;
        if (!forceIfExpired && !expired && s.json.get() != null) {
            return;
        }
        if (!s.loading.compareAndSet(false, true)) {
            return;
        }
        IO_POOL.execute(() -> {
            try {
                String result = RepoHandler.downloadWithCache(s);
                if (result != null) {
                    s.json.set(result);
                    s.lastFetch = System.currentTimeMillis();
                } else if (s.json.get() == null) {
                    s.lastFetch = now - (s.ttlMs - TimeUnit.MINUTES.toMillis(1L));
                }
            }
            catch (Exception ex) {
                Logger.logErrorConsole("Fetch fail (" + key + "): " + ex.getMessage());
                s.lastFetch = now - (s.ttlMs - TimeUnit.MINUTES.toMillis(1L));
            }
            finally {
                s.loading.set(false);
            }
        });
    }

    private static String downloadWithCache(SourceState s) throws Exception {
        int code;
        HttpURLConnection conn = (HttpURLConnection)new URL(s.url).openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        conn.setRequestProperty("User-Agent", USER_AGENT);
        if (s.etag != null) {
            conn.setRequestProperty("If-None-Match", s.etag);
        }
        if (s.lastModified != null) {
            conn.setRequestProperty("If-Modified-Since", s.lastModified);
        }
        if ((code = conn.getResponseCode()) == 304) {
            return s.json.get();
        }
        if (code >= 200 && code < 300) {
            String etag = conn.getHeaderField("ETag");
            String lm = conn.getHeaderField("Last-Modified");
            String body = RepoHandler.readAll(conn);
            if (etag != null) {
                s.etag = etag;
            }
            if (lm != null) {
                s.lastModified = lm;
            }
            return body;
        }
        if (s.json.get() != null) {
            return null;
        }
        throw new RuntimeException("HTTP " + code + " on " + s.url);
    }

    private static String readAll(HttpURLConnection conn) throws Exception {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder(4096);
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
            String string = sb.toString();
            return string;
        }
    }

    private static ParsedCache cacheFor(String key, Type type) {
        return PARSED.computeIfAbsent(key, k -> new ConcurrentHashMap()).computeIfAbsent(type, t -> new ParsedCache());
    }

    public static <T> T getData(String key, Type type, T defaultValue) {
        Object result;
        RepoHandler.ensureLoadedAsync(key);
        String json = RepoHandler.getJson(key);
        if (json == null) {
            return defaultValue;
        }
        ParsedCache pc = RepoHandler.cacheFor(key, type);
        if (!Objects.equals(json, pc.lastJsonRef)) {
            try {
                Object parsed = gson.fromJson(json, type);
                if (parsed != null) {
                    pc.parsed = parsed;
                    pc.lastJsonRef = json;
                }
            }
            catch (Exception e) {
                Logger.logErrorConsole("JSON parse error (" + key + "): " + e.getMessage());
            }
        }
        return (T)((result = pc.parsed) != null ? result : defaultValue);
    }

    public static <T> T getData(String key, Class<T> clazz, T defaultValue) {
        return RepoHandler.getData(key, clazz, defaultValue);
    }

    private static final class ParsedCache {
        volatile Object parsed;
        volatile String lastJsonRef;

        private ParsedCache() {
        }
    }

    private static final class SourceState {
        final String url;
        final long ttlMs;
        final AtomicReference<String> json = new AtomicReference<Object>(null);
        final AtomicBoolean loading = new AtomicBoolean(false);
        volatile long lastFetch = 0L;
        volatile String etag = null;
        volatile String lastModified = null;

        SourceState(String url, long ttlMs) {
            this.url = url;
            this.ttlMs = ttlMs;
        }
    }
}

