/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.capes;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import org.ginafro.notenoughfakepixel.features.capes.Cape;

public class CapeManager {
    private static final String CAPES_JSON_URL = "https://raw.githubusercontent.com/GinaFro1/NotEnoughFakepixel-Cape/main/capes.json";
    private static final String GITHUB_CAPE_BASE_URL = "https://raw.githubusercontent.com/GinaFro1/NotEnoughFakepixel-Cape/main/";
    private static final List<Cape> allCapes = new ArrayList<Cape>();
    private static final Map<Integer, Cape> capesByID = new HashMap<Integer, Cape>();
    private static final Map<Integer, ResourceLocation> dynamicTextures = new HashMap<Integer, ResourceLocation>();
    private static Cape currentCape = null;
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private static final Map<UUID, Integer> syncedCapes = new HashMap<UUID, Integer>();
    private static final File CONFIG_DIR = new File(Minecraft.func_71410_x().field_71412_D, "config/Notenoughfakepixel");
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "capes.cfg");

    public static void syncCape(UUID uuid, int capeID) {
        syncedCapes.put(uuid, capeID);
    }

    public static Cape getCapeForPlayer(UUID uuid) {
        Integer id = syncedCapes.get(uuid);
        if (id != null) {
            return CapeManager.getCapeByID(id);
        }
        return null;
    }

    public static Cape getCapeByID(Integer id) {
        return capesByID.get(id);
    }

    public static void loadCapesFromGitHub() {
        executor.execute(() -> {
            try {
                URL url = new URL(CAPES_JSON_URL);
                InputStreamReader reader = new InputStreamReader(url.openStream());
                List data = (List)new Gson().fromJson((Reader)reader, new TypeToken<List<Map<String, Object>>>(){}.getType());
                for (Map entry : data) {
                    int id = Integer.parseInt((String)entry.get("capeID"));
                    String file = (String)entry.get("file");
                    int width = ((Double)entry.get("width")).intValue();
                    int height = ((Double)entry.get("height")).intValue();
                    String name = (String)entry.get("name");
                    Cape cape = new Cape(width, height, id, file, name);
                    allCapes.add(cape);
                    capesByID.put(id, cape);
                }
                if (!allCapes.isEmpty()) {
                    currentCape = allCapes.get(0);
                }
                System.out.println("\u2705 Loaded cape metadata from GitHub (" + allCapes.size() + " capes).");
                CapeManager.loadSelectedCape();
                allCapes.forEach(CapeManager::loadCapeTextureAsync);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static Cape getCape() {
        CapeManager.loadCapeTextureAsync(currentCape);
        return currentCape;
    }

    public static void setCape(int id) {
        currentCape = id == -11 ? null : capesByID.getOrDefault(id, currentCape);
        CapeManager.saveSelectedCape();
    }

    public static List<Cape> getAllCapes() {
        if (capesByID.isEmpty() || allCapes.isEmpty()) {
            CapeManager.loadCapesFromGitHub();
        }
        return allCapes;
    }

    public static ResourceLocation getCapeTexture(Cape cape) {
        return dynamicTextures.get(cape.capeID);
    }

    public static String getCapeURL(Cape cape) {
        return GITHUB_CAPE_BASE_URL + cape.capeFile;
    }

    public static boolean hasCape() {
        return currentCape != null;
    }

    private static void loadCapeTextureAsync(Cape cape) {
        if (cape == null || cape.capeFile == null) {
            return;
        }
        if (dynamicTextures.containsKey(cape.capeID)) {
            return;
        }
        executor.execute(() -> {
            try {
                String url = CapeManager.getCapeURL(cape);
                System.out.println("\u2b07\ufe0f Downloading cape from " + url);
                BufferedImage image = ImageIO.read(new URL(url));
                if (image == null) {
                    System.out.println("\u274c Failed to load image for cape: " + cape.capeFile);
                    return;
                }
                Minecraft.func_71410_x().func_152344_a(() -> {
                    try {
                        DynamicTexture dyn = new DynamicTexture(image);
                        ResourceLocation loc = Minecraft.func_71410_x().func_110434_K().func_110578_a(String.valueOf(cape.capeID), dyn);
                        dynamicTextures.put(cape.capeID, loc);
                        System.out.println("\u2705 Cape loaded and registered: " + cape.capeFile + " \u2192 " + loc);
                    }
                    catch (Exception e) {
                        System.err.println("\u274c GL error while creating cape texture: " + cape.capeFile);
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                System.err.println("\u274c Failed to download cape " + cape.capeFile);
                e.printStackTrace();
            }
        });
    }

    private static void saveSelectedCape() {
        executor.execute(() -> {
            try {
                Properties props = new Properties();
                props.setProperty("selectedCapeID", currentCape != null ? String.valueOf(CapeManager.currentCape.capeID) : "-11");
                CONFIG_DIR.mkdirs();
                try (FileOutputStream out = new FileOutputStream(CONFIG_FILE);){
                    props.store(out, "NotEnoughFakepixel Cape Settings");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static void loadSelectedCape() {
        if (!CONFIG_FILE.exists()) {
            return;
        }
        try (FileInputStream in = new FileInputStream(CONFIG_FILE);){
            Properties props = new Properties();
            props.load(in);
            int savedID = Integer.parseInt(props.getProperty("selectedCapeID", "-11"));
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (savedID != -11) {
                    currentCape = capesByID.get(savedID);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getCapeWidth() {
        return CapeManager.getCape() != null ? CapeManager.getCape().width : 64;
    }

    public static int getCapeHeight() {
        return CapeManager.getCape() != null ? CapeManager.getCape().height : 32;
    }
}

