/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.cosmetics.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Scanner;
import org.ginafro.notenoughfakepixel.features.cosmetics.loader.Obj;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class OBJLoader {
    public int createDisplayList(Obj model) {
        int displayList = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayList, (int)4864);
        this.render(model);
        GL11.glEndList();
        return displayList;
    }

    public void render(Obj model) {
        GL11.glMaterialf((int)1028, (int)5633, (float)120.0f);
        GL11.glBegin((int)4);
        for (Obj.Face face : model.getFaces()) {
            Vector3f[] normals = new Vector3f[]{model.getNormals().get(face.getNormals()[0] - 1), model.getNormals().get(face.getNormals()[1] - 1), model.getNormals().get(face.getNormals()[2] - 1)};
            Vector2f[] texCoords = new Vector2f[]{model.getTextureCoordinates().get(face.getTextureCoords()[0] - 1), model.getTextureCoordinates().get(face.getTextureCoords()[1] - 1), model.getTextureCoordinates().get(face.getTextureCoords()[2] - 1)};
            Vector3f[] vertices = new Vector3f[]{model.getVertices().get(face.getVertices()[0] - 1), model.getVertices().get(face.getVertices()[1] - 1), model.getVertices().get(face.getVertices()[2] - 1)};
            GL11.glNormal3f((float)normals[0].getX(), (float)normals[0].getY(), (float)normals[0].getZ());
            GL11.glTexCoord2f((float)texCoords[0].getX(), (float)texCoords[0].getY());
            GL11.glVertex3f((float)vertices[0].getX(), (float)vertices[0].getY(), (float)vertices[0].getZ());
            GL11.glNormal3f((float)normals[1].getX(), (float)normals[1].getY(), (float)normals[1].getZ());
            GL11.glTexCoord2f((float)texCoords[1].getX(), (float)texCoords[1].getY());
            GL11.glVertex3f((float)vertices[1].getX(), (float)vertices[1].getY(), (float)vertices[1].getZ());
            GL11.glNormal3f((float)normals[2].getX(), (float)normals[2].getY(), (float)normals[2].getZ());
            GL11.glTexCoord2f((float)texCoords[2].getX(), (float)texCoords[2].getY());
            GL11.glVertex3f((float)vertices[2].getX(), (float)vertices[2].getY(), (float)vertices[2].getZ());
        }
        GL11.glEnd();
    }

    public Obj loadModel(File file) throws FileNotFoundException {
        return this.loadModel(new Scanner(file));
    }

    public Obj loadModel(InputStream stream) {
        return this.loadModel(new Scanner(stream));
    }

    public Obj loadModel(Scanner sc) {
        Obj model = new Obj();
        block14: while (sc.hasNextLine()) {
            String ln = sc.nextLine();
            if (ln == null || ln.equals("") || ln.startsWith("#")) continue;
            String[] split = ln.split(" ");
            switch (split[0]) {
                case "v": {
                    model.getVertices().add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    continue block14;
                }
                case "vn": {
                    model.getNormals().add(new Vector3f(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3])));
                    continue block14;
                }
                case "vt": {
                    model.getTextureCoordinates().add(new Vector2f(Float.parseFloat(split[1]), Float.parseFloat(split[2])));
                    continue block14;
                }
                case "f": {
                    model.getFaces().add(new Obj.Face(new int[]{Integer.parseInt(split[1].split("/")[0]), Integer.parseInt(split[2].split("/")[0]), Integer.parseInt(split[3].split("/")[0])}, new int[]{Integer.parseInt(split[1].split("/")[1]), Integer.parseInt(split[2].split("/")[1]), Integer.parseInt(split[3].split("/")[1])}, new int[]{Integer.parseInt(split[1].split("/")[2]), Integer.parseInt(split[2].split("/")[2]), Integer.parseInt(split[3].split("/")[2])}));
                    continue block14;
                }
                case "s": {
                    model.setSmoothShadingEnabled(!ln.contains("off"));
                    continue block14;
                }
            }
            System.err.println("[OBJ] Unknown Line: " + ln);
        }
        sc.close();
        return model;
    }
}

