/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.duels;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.Gamemode;

@RegisterEvents
public class KDCounter {
    private static int kills = 0;
    private static int deaths = 0;
    private String opponent = "";
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onChat(ClientChatReceivedEvent e) {
        String[] parts;
        if (ScoreboardUtils.currentGamemode != Gamemode.DUELS) {
            return;
        }
        String msg = e.message.func_150260_c();
        if (msg.contains("Opponents: ")) {
            this.opponent = msg.replace("Opponents: ", "").trim();
        }
        if ((parts = msg.split(" ")).length > 0) {
            String firstWord = parts[0];
            if (this.opponent.equals(firstWord)) {
                ++kills;
            } else if (this.mc.field_71439_g.func_70005_c_().equals(firstWord)) {
                ++deaths;
            }
        }
        if (msg.contains("WINNER")) {
            kills = 0;
            deaths = 0;
            this.opponent = "";
        }
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!Config.feature.duels.kdCounterEnabled) {
            return;
        }
        if (ScoreboardUtils.currentGamemode != Gamemode.DUELS) {
            return;
        }
        this.draw(Config.feature.duels.kdCounterOffsetX, Config.feature.duels.kdCounterOffsetY, Config.feature.duels.kdCounterScale, false);
    }

    private void draw(float x, float y, float scale, boolean example) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        String text = example ? "K/D: 3/2" : "K/D: " + kills + "/" + deaths;
        this.mc.field_71466_p.func_78276_b(text, 0, 0, -1);
        GlStateManager.func_179121_F();
    }

    public void renderDummy() {
        this.draw(Config.feature.duels.kdCounterOffsetX, Config.feature.duels.kdCounterOffsetY, Config.feature.duels.kdCounterScale, true);
    }

    public float getWidth() {
        return 45.0f * Config.feature.duels.kdCounterScale;
    }

    public float getHeight() {
        return 11.0f * Config.feature.duels.kdCounterScale;
    }
}

