/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.mlf;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.Gamemode;

@RegisterEvents
public class Map {
    private String inc = "";
    private String bal = "";
    private String e1 = "";
    private String e2 = "";
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!Config.feature.mlf.mlfInfoHud) {
            return;
        }
        if (ScoreboardUtils.currentGamemode != Gamemode.MLF) {
            return;
        }
        ScaledResolution sr = new ScaledResolution(this.mc);
        int x = (int)Config.feature.mlf.mlfInfoOffsetX;
        int y = (int)Config.feature.mlf.mlfInfoOffsetY;
        String[] colorParts = Config.feature.mlf.mlfInfoBackgroundColor.split(":");
        int alpha = Integer.parseInt(colorParts[1]);
        int red = Integer.parseInt(colorParts[2]);
        int green = Integer.parseInt(colorParts[3]);
        int blue = Integer.parseInt(colorParts[4]);
        int bgColor = alpha << 24 | red << 16 | green << 8 | blue;
        List<String> sideBarLines = ScoreboardUtils.getScoreboardLines();
        this.updateLines(sideBarLines);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Income: " + this.inc);
        lines.add("Balance: " + this.bal);
        lines.add("Events: ");
        if (!this.e1.isEmpty()) {
            lines.add("- " + this.e1);
        }
        if (!this.e2.isEmpty()) {
            lines.add("- " + this.e2);
        }
        int textWidth = 0;
        for (String line : lines) {
            int lineWidth = this.mc.field_71466_p.func_78256_a(line);
            if (lineWidth <= textWidth) continue;
            textWidth = lineWidth;
        }
        int textHeight = lines.size() * 9;
        Gui.func_73734_a((int)x, (int)y, (int)(x + (textWidth += 4)), (int)(y + textHeight), (int)bgColor);
        for (int i = 0; i < lines.size(); ++i) {
            this.mc.field_71466_p.func_78276_b((String)lines.get(i), x + 2, y + i * 9, -1);
        }
    }

    private void updateLines(List<String> sideBarLines) {
        if (sideBarLines == null) {
            return;
        }
        this.e1 = "";
        this.e2 = "";
        for (String s : sideBarLines) {
            if (s.contains("- ")) {
                if (this.e1.isEmpty()) {
                    this.e1 = StringUtils.func_76338_a((String)s.replace("- ", ""));
                } else {
                    this.e2 = StringUtils.func_76338_a((String)s.replace("- ", ""));
                }
            }
            if (s.contains("Balance")) {
                this.bal = StringUtils.func_76338_a((String)s.replace("Balance: ", ""));
            }
            if (!s.contains("Income")) continue;
            this.inc = StringUtils.func_76338_a((String)s.replace("Income: ", ""));
        }
    }

    public void renderDummy() {
        ScaledResolution sr = new ScaledResolution(this.mc);
        int x = (int)Config.feature.mlf.mlfInfoOffsetX;
        int y = (int)Config.feature.mlf.mlfInfoOffsetY;
        String[] colorParts = Config.feature.mlf.mlfInfoBackgroundColor.split(":");
        int alpha = Integer.parseInt(colorParts[1]);
        int red = Integer.parseInt(colorParts[2]);
        int green = Integer.parseInt(colorParts[3]);
        int blue = Integer.parseInt(colorParts[4]);
        int bgColor = alpha << 24 | red << 16 | green << 8 | blue;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Income: 100");
        lines.add("Balance: 500");
        lines.add("Events: ");
        lines.add("- Event 1");
        lines.add("- Event 2");
        int textWidth = 0;
        for (String line : lines) {
            int lineWidth = this.mc.field_71466_p.func_78256_a(line);
            if (lineWidth <= textWidth) continue;
            textWidth = lineWidth;
        }
        int textHeight = lines.size() * 9;
        Gui.func_73734_a((int)x, (int)y, (int)(x + (textWidth += 4)), (int)(y + textHeight), (int)bgColor);
        for (int i = 0; i < lines.size(); ++i) {
            this.mc.field_71466_p.func_78276_b((String)lines.get(i), x + 2, y + i * 9, -1);
        }
    }
}

