/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.accessories;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.serverdata.AccessoriesData;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.Logger;
import org.ginafro.notenoughfakepixel.utils.ReflectionUtils;
import org.ginafro.notenoughfakepixel.utils.StringUtils;
import org.ginafro.notenoughfakepixel.variables.Rarity;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class MissingAccessories {
    private static int ticks = 0;
    private int accScroll = 0;
    private int accMaxScroll = 0;
    private int accPanelX;
    private int accPanelY;
    private int accPanelW;
    private int accPanelH;
    private static final Field F_GUI_LEFT = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_147003_i", "guiLeft"});
    private static final Field F_GUI_TOP = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_147009_r", "guiTop"});
    private static final Field F_XSIZE = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_146999_f", "xSize"});
    private static final Field F_YSIZE = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_147000_g", "ySize"});
    private GuiScreen lastScreen = null;

    @SubscribeEvent
    public void onOpen(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (!(e.gui instanceof GuiChest)) {
            return;
        }
        GuiChest chestGui = (GuiChest)e.gui;
        Container container = chestGui.field_147002_h;
        if (!(container instanceof ContainerChest)) {
            return;
        }
        if (!this.checkEssentials()) {
            return;
        }
        ContainerChest containerChest = (ContainerChest)container;
        if (++ticks < 10) {
            return;
        }
        ticks = 0;
        String name = containerChest.func_85151_d().func_145748_c_().func_150260_c();
        if (name.equals("Accessory Bag")) {
            AccessoriesData.show = true;
            for (Slot slot : containerChest.field_75151_b) {
                ItemStack item;
                if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || (item = slot.func_75211_c()) == null) continue;
                if (ItemUtils.isSkyblockItem(item)) {
                    AccessoriesData.Accessory acc = new AccessoriesData.Accessory(ItemUtils.getRarity(item).name(), StringUtils.stripFormattingFast(item.func_82833_r()));
                    AccessoriesData.INSTANCE.addAccessory(acc);
                }
                if (slot.getSlotIndex() != containerChest.field_75151_b.size() - 37 || item.func_82833_r().equals("\u00a7aNext Page")) continue;
                AccessoriesData.finalPage = true;
            }
            AccessoriesData.calculateMp();
        } else {
            AccessoriesData.show = false;
        }
    }

    public boolean checkEssentials() {
        return Config.feature.accessories.enable;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        if (this.lastScreen instanceof GuiChest && !(current instanceof GuiChest)) {
            if (!AccessoriesData.INSTANCE.getCurrentAccessories().isEmpty()) {
                AccessoriesData.INSTANCE.clearAccessories();
            }
            AccessoriesData.finalPage = false;
            AccessoriesData.show = false;
        }
        this.lastScreen = current;
    }

    @SubscribeEvent
    public void onMouseWheel(GuiScreenEvent.MouseInputEvent.Pre e) {
        if (!(e.gui instanceof GuiChest)) {
            return;
        }
        if (!AccessoriesData.show) {
            return;
        }
        int dWheel = Mouse.getDWheel();
        if (dWheel == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int mouseX = Mouse.getX() * e.gui.field_146294_l / mc.field_71443_c;
        int mouseY = e.gui.field_146295_m - Mouse.getY() * e.gui.field_146295_m / mc.field_71440_d - 1;
        if (mouseX < this.accPanelX || mouseX > this.accPanelX + this.accPanelW || mouseY < this.accPanelY || mouseY > this.accPanelY + this.accPanelH) {
            return;
        }
        int step = mc.field_71466_p.field_78288_b + 2;
        this.accScroll = MissingAccessories.clamp(this.accScroll - Integer.signum(dWheel) * step, 0, this.accMaxScroll);
    }

    private static int clamp(int v, int lo, int hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    @SubscribeEvent
    public void onKeyDown(GuiScreenEvent.KeyboardInputEvent.Pre e) {
        if (!(e.gui instanceof GuiChest)) {
            return;
        }
        if (!AccessoriesData.show) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int key = Keyboard.getEventKey();
        if (key == 0) {
            return;
        }
        if (!Keyboard.getEventKeyState()) {
            return;
        }
        int step = mc.field_71466_p.field_78288_b + 2;
        if (key == 200) {
            this.accScroll = MissingAccessories.clamp(this.accScroll - step, 0, this.accMaxScroll);
            e.setCanceled(true);
        } else if (key == 208) {
            this.accScroll = MissingAccessories.clamp(this.accScroll + step, 0, this.accMaxScroll);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDrawChestPanel(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (!(e.gui instanceof GuiChest)) {
            return;
        }
        if (!this.checkEssentials()) {
            return;
        }
        if (!AccessoriesData.show) {
            return;
        }
        if (!Config.feature.accessories.showMissingAccessoriesList) {
            return;
        }
        GuiChest chest = (GuiChest)e.gui;
        try {
            int xSize = ReflectionUtils.getInt(F_XSIZE, chest, 176);
            int ySize = ReflectionUtils.getInt(F_YSIZE, chest, 222);
            int guiLeft = ReflectionUtils.getInt(F_GUI_LEFT, chest, (e.gui.field_146294_l - xSize) / 2);
            int guiTop = ReflectionUtils.getInt(F_GUI_TOP, chest, (e.gui.field_146295_m - ySize) / 2);
            int pad = 6;
            int panelX = guiLeft + xSize + 6;
            int panelY = guiTop;
            int panelW = 140;
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            HashMap<String, Rarity> accessories = this.getMissingByRarity();
            int headerH = fr.field_78288_b + 6;
            int lineH = fr.field_78288_b + 2;
            int visibleListH = Math.min(180, ySize - headerH - 6);
            int panelH = headerH + Math.max(0, visibleListH) + 6;
            this.accPanelX = panelX;
            this.accPanelY = panelY;
            this.accPanelW = 140;
            this.accPanelH = panelH;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
            Gui.func_73734_a((int)panelX, (int)panelY, (int)(panelX + 140), (int)(panelY + panelH), (int)-1342177280);
            Gui.func_73734_a((int)panelX, (int)panelY, (int)(panelX + 140), (int)(panelY + 1), (int)0x40FFFFFF);
            Gui.func_73734_a((int)panelX, (int)(panelY + panelH - 1), (int)(panelX + 140), (int)(panelY + panelH), (int)0x40000000);
            Gui.func_73734_a((int)panelX, (int)panelY, (int)(panelX + 1), (int)(panelY + panelH), (int)0x40000000);
            Gui.func_73734_a((int)(panelX + 140 - 1), (int)panelY, (int)(panelX + 140), (int)(panelY + panelH), (int)0x40000000);
            fr.func_175063_a("\u00a77Missing Accessories", (float)(panelX + 6), (float)(panelY + 4), 0xFFFFFF);
            Gui.func_73734_a((int)(panelX + 6), (int)(panelY + headerH - 2), (int)(panelX + 140 - 6), (int)(panelY + headerH - 1), (int)0x40FFFFFF);
            if (!AccessoriesData.finalPage || accessories.isEmpty()) {
                String line = AccessoriesData.finalPage ? "None! You're all set!" : "Visit all pages to see";
                String clipped = fr.func_78269_a(line, 128);
                int textW = fr.func_78256_a(clipped);
                int textX = panelX + (140 - textW) / 2;
                int textY = panelY + (panelH - fr.field_78288_b) / 2;
                fr.func_78276_b(clipped, textX, textY, -5592406);
                GlStateManager.func_179126_j();
                GlStateManager.func_179145_e();
                this.accScroll = 0;
                this.accMaxScroll = 0;
                return;
            }
            ArrayList<Map.Entry<String, Rarity>> entries = new ArrayList<Map.Entry<String, Rarity>>(accessories.entrySet());
            entries.sort((a, b) -> {
                int c = ((Rarity)((Object)((Object)((Object)b.getValue())))).ordinal() - ((Rarity)((Object)((Object)((Object)a.getValue())))).ordinal();
                if (c != 0) {
                    return c;
                }
                return ((String)a.getKey()).compareToIgnoreCase((String)b.getKey());
            });
            int contentH = entries.size() * lineH + 8;
            int viewH = Math.max(0, panelH - headerH - 6);
            this.accMaxScroll = Math.max(0, contentH - viewH);
            if (this.accScroll < 0) {
                this.accScroll = 0;
            }
            if (this.accScroll > this.accMaxScroll) {
                this.accScroll = this.accMaxScroll;
            }
            int listX = panelX + 6;
            int listY = panelY + headerH;
            this.enableScissor(listX - 2, listY, 132, viewH);
            int y = listY + 4 - this.accScroll;
            for (Map.Entry entry : entries) {
                String name = (String)entry.getKey();
                Rarity rar = (Rarity)((Object)entry.getValue());
                String line = Rarity.getColor(rar) + "\u25a0 " + name;
                if (y > listY - lineH && y < listY + viewH) {
                    fr.func_78276_b(fr.func_78269_a(line, 128), listX, y, -1);
                }
                y += lineH;
            }
            this.disableScissor();
            if (this.accMaxScroll > 0) {
                int trackX = panelX + 140 - 3;
                int n = listY + 2;
                int trackH = viewH - 4;
                int barH = Math.max(16, (int)((float)trackH * ((float)viewH / (float)contentH)));
                int barY = n + (int)((float)(trackH - barH) * ((float)this.accScroll / (float)this.accMaxScroll));
                Gui.func_73734_a((int)trackX, (int)n, (int)(trackX + 2), (int)(n + trackH), (int)0x40FFFFFF);
                Gui.func_73734_a((int)trackX, (int)barY, (int)(trackX + 2), (int)(barY + barH), (int)-1);
            }
            GlStateManager.func_179126_j();
            GlStateManager.func_179145_e();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
        }
        catch (Exception ex) {
            Logger.logConsole("Error drawing accessories panel" + ex.getMessage());
        }
    }

    private void enableScissor(int x, int y, int w, int h) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc);
        int scale = sr.func_78325_e();
        int fbH = mc.field_71440_d;
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(x * scale), (int)(fbH - (y + h) * scale), (int)(w * scale), (int)(h * scale));
    }

    private void disableScissor() {
        GL11.glDisable((int)3089);
    }

    @SubscribeEvent
    public void onDrawChestPanelLeft(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (!(e.gui instanceof GuiChest)) {
            return;
        }
        if (!this.checkEssentials()) {
            return;
        }
        GuiChest chest = (GuiChest)e.gui;
        if (!AccessoriesData.show) {
            return;
        }
        int xSize = ReflectionUtils.getInt(F_XSIZE, chest, 176);
        int ySize = ReflectionUtils.getInt(F_YSIZE, chest, 222);
        int guiLeft = ReflectionUtils.getInt(F_GUI_LEFT, chest, (e.gui.field_146294_l - xSize) / 2);
        int guiTop = ReflectionUtils.getInt(F_GUI_TOP, chest, (e.gui.field_146295_m - ySize) / 2);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("\u00a76MP Estimation");
        if (AccessoriesData.finalPage) {
            if (AccessoriesData.totalMp < AccessoriesData.maxMp) {
                lines.add("\u00a77Your Mp: " + AccessoriesData.getColorLevel(AccessoriesData.maxMp) + AccessoriesData.totalMp + "\u00a77 / \u00a7b" + AccessoriesData.maxMp);
            }
            lines.add("\u00a77Your Mp (\u00a76Recomb\u00a77): " + AccessoriesData.getColorLevel(AccessoriesData.maxMpRec) + AccessoriesData.totalMp + "\u00a77 / \u00a7b" + AccessoriesData.maxMpRec);
        } else {
            lines.add("\u00a7cVisit All pages first");
            lines.add("Max mp is: \u00a7b" + AccessoriesData.maxMpRec);
        }
        int maxWidth = lines.stream().map(arg_0 -> ((FontRenderer)fr).func_78256_a(arg_0)).max(Integer::compare).orElse(0);
        int panelW = maxWidth + 12;
        int lineH = fr.field_78288_b + 2;
        int panelH = lineH * lines.size() + 6;
        int pad = 6;
        int panelX = guiLeft - panelW - pad;
        int panelY = guiTop + (ySize - panelH) / 2;
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        Gui.func_73734_a((int)panelX, (int)panelY, (int)(panelX + panelW), (int)(panelY + panelH), (int)-1342177280);
        Gui.func_73734_a((int)panelX, (int)panelY, (int)(panelX + panelW), (int)(panelY + 1), (int)0x40FFFFFF);
        Gui.func_73734_a((int)panelX, (int)(panelY + panelH - 1), (int)(panelX + panelW), (int)(panelY + panelH), (int)0x40000000);
        Gui.func_73734_a((int)panelX, (int)panelY, (int)(panelX + 1), (int)(panelY + panelH), (int)0x40000000);
        Gui.func_73734_a((int)(panelX + panelW - 1), (int)panelY, (int)(panelX + panelW), (int)(panelY + panelH), (int)0x40000000);
        int textX = panelX + 6;
        int textY = panelY + 4;
        for (String line : lines) {
            fr.func_175063_a(line, (float)textX, (float)textY, 0xFFFFFF);
            textY += lineH;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
    }

    private HashMap<String, Rarity> getMissingByRarity() {
        HashMap<String, Rarity> map = new HashMap<String, Rarity>();
        List<AccessoriesData.Accessory> missing = AccessoriesData.INSTANCE.getMissingAccessories();
        for (AccessoriesData.Accessory accessory : missing) {
            Rarity rarity = Rarity.fromString(accessory.getRarity());
            map.put(accessory.getName(), rarity);
        }
        return map;
    }

    private List<String> getMissing() {
        AccessoriesData data = AccessoriesData.INSTANCE;
        return data.getRepoAccessories().stream().map(AccessoriesData.Accessory::getName).collect(Collectors.toList());
    }

    static {
        F_GUI_LEFT.setAccessible(true);
        F_GUI_TOP.setAccessible(true);
        F_XSIZE.setAccessible(true);
        F_YSIZE.setAccessible(true);
    }
}

