/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.chocolate;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ChatUtils;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.utils.Waypoint;
import org.ginafro.notenoughfakepixel.variables.Skins;
import org.jetbrains.annotations.NotNull;

@RegisterEvents
public class ChocolateFactory {
    private final Pattern upgradeCostPattern = Pattern.compile("(\u00a7.)(?<cost>[0-9,]+) Chocolate");
    private Pattern pattern = Pattern.compile("Id:\"([^\"]+)\"");
    private final ArrayList<Waypoint> waypoints = new ArrayList();

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (!Config.feature.chocolateFactory.chocolateChocolateEggWaypoints) {
            return;
        }
        this.checkForEggs();
        this.drawWaypoints(event.partialTicks);
        this.drawTags(event.partialTicks);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!Config.feature.chocolateFactory.chocolateChocolateShowBestUpgrade || !(event.gui instanceof GuiChest)) {
            return;
        }
        TreeMap<Float, Slot> upgradeCosts = new TreeMap<Float, Slot>();
        GuiChest chest = (GuiChest)event.gui;
        Container container = chest.field_147002_h;
        String chestName = TablistParser.currentOpenChestName;
        if (chestName == null || !chestName.startsWith("Chocolate Factory")) {
            return;
        }
        int index = 0;
        ContainerChest containerChest = (ContainerChest)container;
        for (Slot slot : containerChest.field_75151_b) {
            String upgradeCost;
            if (slot.getSlotIndex() < 28 || slot.getSlotIndex() > 34) continue;
            ++index;
            ItemStack item = slot.func_75211_c();
            if (item == null || !(item.func_77973_b() instanceof ItemSkull) || (upgradeCost = ItemUtils.getLoreLine(item, this.upgradeCostPattern)) == null) continue;
            upgradeCost = ColorUtils.cleanColor(upgradeCost).replaceAll(",", "").replaceAll(" Chocolate", "");
            float costRatio = Float.parseFloat(upgradeCost) / (float)index;
            upgradeCosts.put(Float.valueOf(costRatio), slot);
        }
        if (upgradeCosts.isEmpty()) {
            return;
        }
        float lowestValue = ((Float)upgradeCosts.firstKey()).floatValue();
        Slot associatedSlot = (Slot)upgradeCosts.get(Float.valueOf(lowestValue));
        RenderUtils.drawOnSlot(containerChest.field_75151_b.size(), associatedSlot.field_75223_e, associatedSlot.field_75221_f, new Color(0, 255, 0, 100).getRGB());
    }

    @SubscribeEvent
    public void onChat(@NotNull ClientChatReceivedEvent e) {
        Waypoint w;
        if (!Config.feature.chocolateFactory.chocolateChocolateEggWaypoints) {
            return;
        }
        if (!ScoreboardUtils.currentGamemode.isSkyblock()) {
            return;
        }
        if (ChatUtils.middleBar.matcher(e.message.func_150254_d()).matches()) {
            return;
        }
        Matcher matcher = Pattern.compile("HOPPITY'S HUNT You found").matcher(e.message.func_150260_c());
        Matcher matcher2 = Pattern.compile("HOPPITY'S HUNT A Chocolate .* Egg has appeared").matcher(e.message.func_150260_c());
        Matcher matcher3 = Pattern.compile("You have already collected this Chocolate .* Egg! Try again when it respawns!").matcher(e.message.func_150260_c());
        int[] playerCoords = new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()};
        if (matcher.find()) {
            w = Waypoint.getClosestWaypoint(this.waypoints, playerCoords);
            if (w == null) {
                return;
            }
            w.setHidden(true);
        }
        if (matcher2.find()) {
            ArrayList<Waypoint> waypointsToRemove = new ArrayList<Waypoint>();
            for (Waypoint w2 : this.waypoints) {
                if (!w2.isHidden() || !(Waypoint.distance(playerCoords, w2.getCoordinates()) > 64.0)) continue;
                waypointsToRemove.add(w2);
            }
            this.waypoints.removeAll(waypointsToRemove);
        }
        if (matcher3.find() && (w = Waypoint.getClosestWaypoint(this.waypoints, playerCoords)) != null && Waypoint.distance(playerCoords, w.getCoordinates()) < 6.0) {
            w.setHidden(true);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (Config.feature.chocolateFactory.chocolateChocolateEggWaypoints) {
            this.waypoints.clear();
        }
    }

    private void checkForEggs() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            int[] entityCoords;
            Waypoint waypoint;
            String texture;
            ItemStack it;
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (entity == null || entity.func_70005_c_() == null || !(entity instanceof EntityArmorStand) || (it = ((EntityArmorStand)entity).func_71124_b(4)) == null || it.func_77973_b() != Items.field_151144_bL || (texture = ItemUtils.getSkullTexture(it)).isEmpty() || !this.isEgg(texture) || this.checkIfAdded(waypoint = new Waypoint("EGG", entityCoords = new int[]{entity.func_180425_c().func_177958_n(), entity.func_180425_c().func_177956_o(), entity.func_180425_c().func_177952_p()}))) continue;
            this.waypoints.add(waypoint);
            SoundUtils.playSound(entityCoords, "random.pop", 4.0f, 2.5f);
        }
    }

    private void drawWaypoints(float partialTicks) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        for (Waypoint waypoint : this.waypoints) {
            if (waypoint == null || waypoint.isHidden()) continue;
            Color colorDrawWaypoint = ColorUtils.getColor(Config.feature.chocolateFactory.chocolateChocolateEggWaypointsColor);
            colorDrawWaypoint = new Color(colorDrawWaypoint.getRed(), colorDrawWaypoint.getGreen(), colorDrawWaypoint.getBlue(), 150);
            AxisAlignedBB bb = new AxisAlignedBB((double)waypoint.getCoordinates()[0] - viewerX, (double)waypoint.getCoordinates()[1] - viewerY + 1.0, (double)waypoint.getCoordinates()[2] - viewerZ, (double)(waypoint.getCoordinates()[0] + 1) - viewerX, (double)(waypoint.getCoordinates()[1] + 1) - viewerY + 150.0, (double)(waypoint.getCoordinates()[2] + 1) - viewerZ).func_72314_b((double)0.01f, (double)0.01f, (double)0.01f);
            GlStateManager.func_179129_p();
            RenderUtils.drawFilledBoundingBox(bb, 1.0f, colorDrawWaypoint);
            GlStateManager.func_179089_o();
            GlStateManager.func_179098_w();
        }
    }

    private void drawTags(float partialTicks) {
        for (Waypoint waypoint : this.waypoints) {
            if (waypoint == null || waypoint.isHidden()) continue;
            GlStateManager.func_179129_p();
            RenderUtils.drawTag("Egg", new double[]{waypoint.getCoordinates()[0], waypoint.getCoordinates()[1], waypoint.getCoordinates()[2]}, Color.WHITE, partialTicks);
            GlStateManager.func_179089_o();
            GlStateManager.func_179098_w();
        }
    }

    private boolean checkIfAdded(Waypoint waypoint) {
        return this.waypoints.stream().anyMatch(w -> Arrays.equals(w.getCoordinates(), waypoint.getCoordinates()));
    }

    private boolean isEgg(String texture) {
        for (Skins skin : new Skins[]{Skins.EASTER_EGG_BREAKFAST, Skins.EASTER_EGG_LUNCH, Skins.EASTER_EGG_DINNER}) {
            if (!Skins.equalsSkin(texture, skin)) continue;
            return true;
        }
        return false;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }
}

