/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.crimson;

import java.awt.Color;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.PacketReadEvent;
import org.ginafro.notenoughfakepixel.features.skyblock.crimson.BossNotifier;
import org.ginafro.notenoughfakepixel.features.skyblock.crimson.Crimson;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.Waypoint;
import org.ginafro.notenoughfakepixel.variables.MobDisplayTypes;
import org.ginafro.notenoughfakepixel.variables.Skins;
import org.jetbrains.annotations.NotNull;

@RegisterEvents
public class AshfangHelper {
    private final Waypoint[] waypoints = new Waypoint[2];
    private static int blazingSoulsCounter = 0;
    private final Queue<S2APacketParticles> particlesQueue = new ConcurrentLinkedQueue<S2APacketParticles>();
    private final String underling = "\u00a7c\u00a7cAshfang Underling";
    private final String follower = "\u00a7c\u00a78Ashfang Follower";
    private final String acolyte = "\u00a7c\u00a79Ashfang Acolyte";
    private final String ashfangName = "ASHFANG";
    private static Entity currentAshfang;
    private static Entity currentGravityOrb;
    private Waypoint waypointAshfang;
    private Waypoint waypointGravityOrb;
    private static final Pattern ashfangHPPattern;
    private float lastHP = 5.0E7f;

    public AshfangHelper() {
        this.waypoints[0] = new Waypoint("ASHFANG", new int[]{-484, 141, -1015});
        this.waypoints[1] = new Waypoint("GRAVITYORB", new int[]{-490, -200, -1015});
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (Crimson.checkEssentials()) {
            return;
        }
        int[] position = new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()};
        if (!Crimson.checkAshfangArea(position)) {
            return;
        }
        if (Config.feature.crimson.crimsonAshfangWaypoint || Config.feature.crimson.crimsonGravityOrbWaypoint) {
            this.drawWaypoints(event.partialTicks);
        }
        this.renderEntities(event.partialTicks);
        this.checkHPForSound();
    }

    @SubscribeEvent
    public void onChat(@NotNull ClientChatReceivedEvent e) {
        Matcher matcher3;
        if (Crimson.checkEssentials()) {
            return;
        }
        if (Config.feature.crimson.crimsonAshfangMuteChat) {
            Matcher matcher = Pattern.compile("can only be damaged by").matcher(e.message.func_150260_c());
            Matcher matcher2 = Pattern.compile("hit you for").matcher(e.message.func_150260_c());
            if (matcher.find() || matcher2.find()) {
                e.setCanceled(true);
                return;
            }
        }
        if (Config.feature.crimson.crimsonAshfangMuteChat && (matcher3 = Pattern.compile("The Blazing Soul dealt").matcher(e.message.func_150260_c())).find()) {
            int[] position = new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()};
            if (Config.feature.crimson.crimsonAshfangMuteChat) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onSoundPacketReceive(PacketReadEvent event) {
        S29PacketSoundEffect soundEffect;
        String soundName;
        if (Crimson.checkEssentials()) {
            return;
        }
        if (!Config.feature.crimson.crimsonAshfangMuteSound) {
            return;
        }
        Packet packet = event.packet;
        if (packet instanceof S29PacketSoundEffect && (soundName = (soundEffect = (S29PacketSoundEffect)packet).func_149212_c()).equals("mob.bat.hurt") && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    private void renderEntities(float partialTicks) {
        Color[] newColor = new Color[]{new Color(255, 0, 0, 100)};
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        AtomicInteger blazingSoulCounter = new AtomicInteger();
        AtomicInteger ashfangFollowerCounter = new AtomicInteger();
        boolean gravityFound = false;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (entity == null || entity.func_70005_c_() == null) continue;
            int[] position = new int[]{entity.func_180425_c().func_177958_n(), entity.func_180425_c().func_177956_o(), entity.func_180425_c().func_177952_p()};
            String entityName = entity.func_70005_c_();
            if (!(entity instanceof EntityArmorStand) || !Crimson.checkAshfangArea(position)) continue;
            ItemStack it = ((EntityArmorStand)entity).func_71124_b(4);
            String blazingSoul = "Blazing Soul";
            if (it != null && it.func_77973_b() == Items.field_151144_bL) {
                String texture;
                if (!Config.feature.crimson.crimsonGravityOrbWaypoint || (texture = ItemUtils.getSkullTexture(it)) == null || texture.isEmpty() || !Skins.equalsSkin(texture, Skins.GRAVITY_ORB)) continue;
                this.waypointGravityOrb = new Waypoint("GRAVITYORB", position);
                gravityFound = true;
                if (currentGravityOrb == null) {
                    SoundUtils.playSound(position, "random.pop", 5.0f, 1.5f);
                } else if (entity.func_110124_au() != currentGravityOrb.func_110124_au()) {
                    SoundUtils.playSound(position, "random.pop", 5.0f, 1.5f);
                }
                currentGravityOrb = entity;
                continue;
            }
            if (entityName.contains("Ashfang") && !this.isNameAshfangMinion(entityName) && (currentAshfang == null || currentAshfang.func_110124_au() != entity.func_110124_au())) {
                if (!Config.feature.crimson.crimsonAshfangWaypoint || !Crimson.checkAshfangArea(position)) continue;
                this.waypointAshfang = new Waypoint("ASHFANG", position);
                currentAshfang = entity;
                continue;
            }
            if (this.isNameAshfangMinion(entityName)) {
                if (!Config.feature.crimson.crimsonAshfangHitboxes) continue;
                if (entityName.contains("\u00a7c\u00a7cAshfang Underling")) {
                    newColor[0] = new Color(255, 0, 0, 150);
                } else if (entityName.contains("\u00a7c\u00a79Ashfang Acolyte")) {
                    newColor[0] = new Color(0, 0, 255, 150);
                } else if (entityName.contains("\u00a7c\u00a78Ashfang Follower")) {
                    ashfangFollowerCounter.getAndIncrement();
                    newColor[0] = new Color(255, 255, 255, 255);
                }
                RenderUtils.renderEntityHitbox(entity, partialTicks, newColor[0], MobDisplayTypes.BLAZE);
                continue;
            }
            if (!entityName.contains(blazingSoul) || !Config.feature.crimson.crimsonAshfangHitboxes) continue;
            blazingSoulCounter.getAndIncrement();
            newColor[0] = new Color(255, 255, 0, 255);
            RenderUtils.renderEntityHitbox(entity, partialTicks, newColor[0], MobDisplayTypes.BLAZINGSOUL);
        }
        blazingSoulsCounter = blazingSoulCounter.get();
        if (!gravityFound) {
            this.waypointGravityOrb = null;
        }
    }

    private boolean isNameAshfangMinion(String name) {
        return name.contains("\u00a7c\u00a7cAshfang Underling") || name.contains("\u00a7c\u00a79Ashfang Acolyte") || name.contains("\u00a7c\u00a78Ashfang Follower");
    }

    private void drawWaypoint(Waypoint waypoint, float partialTicks) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)partialTicks;
        if (waypoint == null) {
            return;
        }
        Color colorDrawWaypoint = new Color(255, 255, 255);
        int offsetBossY = 0;
        if (waypoint.getType().equals("GRAVITYORB")) {
            colorDrawWaypoint = ColorUtils.getColor(Config.feature.crimson.crimsonBlazingSoulWaypointColor);
        }
        if (waypoint.getType().equals("ASHFANG")) {
            colorDrawWaypoint = ColorUtils.getColor(Config.feature.crimson.crimsonAshfangWaypointColor);
            offsetBossY = -6;
        }
        colorDrawWaypoint = new Color(colorDrawWaypoint.getRed(), colorDrawWaypoint.getGreen(), colorDrawWaypoint.getBlue(), 75);
        AxisAlignedBB bb = new AxisAlignedBB((double)waypoint.getCoordinates()[0] - viewerX, (double)waypoint.getCoordinates()[1] - viewerY + (double)offsetBossY, (double)waypoint.getCoordinates()[2] - viewerZ, (double)(waypoint.getCoordinates()[0] + 1) - viewerX, (double)(waypoint.getCoordinates()[1] + 1) - viewerY + 150.0, (double)(waypoint.getCoordinates()[2] + 1) - viewerZ).func_72314_b((double)0.01f, (double)0.01f, (double)0.01f);
        GlStateManager.func_179129_p();
        if (waypoint.getType().equals("ASHFANG")) {
            GlStateManager.func_179097_i();
        }
        RenderUtils.drawFilledBoundingBox(bb, 1.0f, colorDrawWaypoint);
        if (waypoint.getType().equals("ASHFANG")) {
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
    }

    private void drawWaypoints(float partialTicks) {
        if (Config.feature.crimson.crimsonAshfangWaypoint && !BossNotifier.getAshfangScheduled()[0]) {
            this.drawWaypoint(this.waypointAshfang, partialTicks);
        }
        if (Config.feature.crimson.crimsonGravityOrbWaypoint) {
            this.drawWaypoint(this.waypointGravityOrb, partialTicks);
        }
    }

    private void checkHPForSound() {
        float currentHP = AshfangHelper.getAshfangHP();
        if (currentHP < this.lastHP && currentHP != -1.0f) {
            int[] position = new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()};
            SoundUtils.playSound(position, "mob.wither.hurt", 0.7f, 0.7f);
        }
        this.lastHP = currentHP;
    }

    public static float getAshfangHP() {
        if (currentAshfang == null) {
            return -1.0f;
        }
        Matcher matcher = ashfangHPPattern.matcher(currentAshfang.func_70005_c_());
        if (matcher.find()) {
            String numberString = matcher.group(1).replace(",", "");
            String ordinalString = matcher.group(2);
            try {
                float number = Float.parseFloat(numberString);
                if (ordinalString == null) {
                    return number;
                }
                if (ordinalString.equals("M")) {
                    return number * (float)Math.pow(10.0, 6.0);
                }
                if (ordinalString.equals("k")) {
                    return number * (float)Math.pow(10.0, 3.0);
                }
                return number;
            }
            catch (NumberFormatException e) {
                System.err.println("Error when converting " + numberString);
                return -1.0f;
            }
        }
        return -1.0f;
    }

    public static int getHitsNeeded() {
        return (int)Math.ceil((double)AshfangHelper.getAshfangHP() / (2.0 * Math.pow(10.0, 6.0)));
    }

    public static int getBlazingSoulsCounter() {
        return blazingSoulsCounter;
    }

    static {
        ashfangHPPattern = Pattern.compile("([0-9]*[.,]?[0-9]*)([Mk])");
    }
}

