/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.crimson;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.config.gui.core.config.Position;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.crimson.AshfangHelper;
import org.ginafro.notenoughfakepixel.features.skyblock.crimson.Crimson;

@RegisterEvents
public class AshfangOverlay {
    private final Position position;
    private static final char[] SUFFIXES = new char[]{'k', 'M'};

    public AshfangOverlay() {
        this.position = Config.feature.crimson.ashfangOverlayPos;
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!this.shouldShow()) {
            return;
        }
        this.render();
    }

    public void render() {
        if (!this.shouldShow()) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        this.getLines(lines, false);
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int x = this.position.getAbsX(sr, 100);
        int y = this.position.getAbsY(sr, 20);
        for (String line : lines) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(line, x, y, 0xFFFFFF);
            y += 10;
        }
    }

    public void renderDummy() {
        ArrayList<String> lines = new ArrayList<String>();
        this.getLines(lines, true);
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int x = this.position.getAbsX(sr, 100);
        int y = this.position.getAbsY(sr, 20);
        for (int i = 0; i < lines.size(); ++i) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b((String)lines.get(i), x, y + i * 10, 0xFFFFFF);
        }
    }

    private void getLines(List<String> lines, boolean example) {
        if (Crimson.checkEssentials()) {
            return;
        }
        if (Config.feature.crimson.crimsonAshfangOverlay) {
            lines.add("\u00a77Ashfang HP: \u00a7r" + AshfangOverlay.formatAshfangHP(AshfangHelper.getAshfangHP()));
            lines.add("\u00a77Blazing souls: \u00a7r" + AshfangHelper.getBlazingSoulsCounter() + " / " + AshfangHelper.getHitsNeeded());
        }
    }

    private boolean shouldShow() {
        return Config.feature.crimson.crimsonAshfangOverlay && Crimson.checkAshfangArea(new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()});
    }

    private static String formatAshfangHP(double hp) {
        double percentage = hp / 5.0E7;
        String prefix = percentage > 0.5 ? "\u00a7a" : (percentage > 0.1 ? "\u00a7e" : "\u00a7c");
        return prefix + AshfangOverlay.coolFormat(hp, 0);
    }

    private static String coolFormat(double n, int iteration) {
        boolean isRound;
        double d = (double)((long)n) / 100.0 / 10.0;
        boolean bl = isRound = d * 10.0 % 10.0 == 0.0;
        return d < 1000.0 ? (isRound || d > 9.99 ? (double)((int)d * 10 / 10) : d) + "" + SUFFIXES[iteration] : AshfangOverlay.coolFormat(d, iteration + 1);
    }
}

