/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.crimson;

import java.util.Arrays;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.crimson.Crimson;
import org.ginafro.notenoughfakepixel.utils.ChatUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.jetbrains.annotations.NotNull;

@RegisterEvents
public class BossNotifier {
    private static final String countdownSound = "random.orb";
    private static final String titleSoundMageOutlawReady = "mob.wither.spawn";
    private static final String titleTextBossReady = " Ready";
    private final boolean[] bladesoulScheduled = new boolean[6];
    private final boolean[] mageOutlawScheduled = new boolean[6];
    private static final boolean[] ashfangScheduled = new boolean[6];
    private static final boolean[] barbarianDukeXScheduled = new boolean[6];
    private long mageOutlawLastKill = -1L;
    private long mageOutlawReady = -1L;
    private long ashfangLastKill = -1L;
    private long ashfangReady = -1L;
    private long barbarianDukeXLastKill = -1L;
    private long barbarianDukeXReady = -1L;
    private long bladesoulLastKill = -1L;
    private long bladesoulReady = -1L;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (Crimson.checkEssentials()) {
            return;
        }
        if (Config.feature.crimson.crimsonBladesoulNotifier) {
            this.playCountdown("Bladesoul", this.bladesoulReady, this.bladesoulLastKill, this.bladesoulScheduled);
        }
        if (Config.feature.crimson.crimsonMageOutlawNotifier) {
            this.playCountdown("Mage Outlaw", this.mageOutlawReady, this.mageOutlawLastKill, this.mageOutlawScheduled);
        }
        if (Config.feature.crimson.crimsonAshfangNotifier) {
            this.playCountdown("Ashfang", this.ashfangReady, this.ashfangLastKill, ashfangScheduled);
        }
        if (Config.feature.crimson.crimsonBarbarianDukeXNotifier) {
            this.playCountdown("Barbarian Duke X", this.barbarianDukeXReady, this.barbarianDukeXLastKill, barbarianDukeXScheduled);
        }
    }

    @SubscribeEvent
    public void onChat(@NotNull ClientChatReceivedEvent e) {
        Matcher matcher;
        if (Crimson.checkEssentials()) {
            return;
        }
        int spawnBossMilliseconds = 125000;
        if (Config.feature.crimson.crimsonBladesoulNotifier && (matcher = Pattern.compile("BLADESOUL DOWN!").matcher(e.message.func_150260_c())).find()) {
            this.bladesoulLastKill = System.currentTimeMillis();
            this.bladesoulReady = this.bladesoulLastKill + (long)spawnBossMilliseconds;
            Arrays.fill(this.bladesoulScheduled, true);
            return;
        }
        if (Config.feature.crimson.crimsonMageOutlawNotifier && (matcher = Pattern.compile("MAGE OUTLAW DOWN!").matcher(e.message.func_150260_c())).find()) {
            this.mageOutlawLastKill = System.currentTimeMillis();
            this.mageOutlawReady = this.mageOutlawLastKill + (long)spawnBossMilliseconds;
            Arrays.fill(this.mageOutlawScheduled, true);
            return;
        }
        if (Config.feature.crimson.crimsonAshfangNotifier && (matcher = Pattern.compile("ASHFANG DOWN!").matcher(e.message.func_150260_c())).find()) {
            this.ashfangLastKill = System.currentTimeMillis();
            this.ashfangReady = this.ashfangLastKill + (long)spawnBossMilliseconds;
            Arrays.fill(ashfangScheduled, true);
            return;
        }
        if (Config.feature.crimson.crimsonBarbarianDukeXNotifier && (matcher = Pattern.compile("BARBARIAN DUKE X DOWN!").matcher(e.message.func_150260_c())).find()) {
            this.barbarianDukeXLastKill = System.currentTimeMillis();
            this.barbarianDukeXReady = this.barbarianDukeXLastKill + (long)spawnBossMilliseconds;
            Arrays.fill(barbarianDukeXScheduled, true);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (Crimson.checkEssentials()) {
            return;
        }
        if (Config.feature.crimson.crimsonBladesoulNotifier) {
            Arrays.fill(this.bladesoulScheduled, false);
            this.bladesoulReady = -1L;
            this.bladesoulLastKill = -1L;
        }
        if (Config.feature.crimson.crimsonMageOutlawNotifier) {
            Arrays.fill(this.mageOutlawScheduled, false);
            this.mageOutlawReady = -1L;
            this.mageOutlawLastKill = -1L;
        }
        if (Config.feature.crimson.crimsonAshfangNotifier) {
            Arrays.fill(ashfangScheduled, false);
            this.ashfangReady = -1L;
            this.ashfangLastKill = -1L;
        }
        if (Config.feature.crimson.crimsonBarbarianDukeXNotifier) {
            Arrays.fill(barbarianDukeXScheduled, false);
            this.barbarianDukeXReady = -1L;
            this.barbarianDukeXLastKill = -1L;
        }
    }

    private void playCountdown(String boss, long timeBossReady, long bossLastKill, boolean[] bossScheduled) {
        if (timeBossReady != -1L && bossLastKill != -1L) {
            if (bossScheduled[0] && System.currentTimeMillis() > timeBossReady) {
                this.notifyTitle(boss);
                bossScheduled[0] = false;
            } else if (bossScheduled[1] && System.currentTimeMillis() > timeBossReady - 123000L) {
                this.notifyChat(boss, 120);
                bossScheduled[1] = false;
            } else if (bossScheduled[2] && System.currentTimeMillis() > timeBossReady - 60000L) {
                this.notifyChat(boss, 60);
                bossScheduled[2] = false;
            } else if (bossScheduled[3] && System.currentTimeMillis() > timeBossReady - 30000L) {
                this.notifyChat(boss, 30);
                bossScheduled[3] = false;
            } else if (bossScheduled[4] && System.currentTimeMillis() > timeBossReady - 10000L) {
                this.notifyChat(boss, 10);
                bossScheduled[4] = false;
            } else if (bossScheduled[5] && System.currentTimeMillis() > timeBossReady - 5000L) {
                this.notifyChat(boss, 5);
                bossScheduled[5] = false;
            }
        }
    }

    private void notifyChat(String boss, int seconds) {
        String joinText = " spawning in ";
        if (seconds == 120) {
            ChatUtils.notifyChat(EnumChatFormatting.YELLOW + boss + joinText + "2 minutes");
        } else if (seconds == 60) {
            ChatUtils.notifyChat(EnumChatFormatting.YELLOW + boss + joinText + "1 minute");
        } else {
            ChatUtils.notifyChat(EnumChatFormatting.YELLOW + boss + joinText + seconds + " seconds");
        }
        SoundUtils.playSound(new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()}, countdownSound, 2.0f, 1.0f);
    }

    private void notifyTitle(String boss) {
        Minecraft.func_71410_x().field_71456_v.func_175178_a(EnumChatFormatting.GOLD + boss + titleTextBossReady, "", 2, 25, 2);
        SoundUtils.playSound(new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()}, titleSoundMageOutlawReady, 2.0f, 1.0f);
        switch (boss) {
            case "Bladesoul": {
                this.bladesoulScheduled[0] = false;
                break;
            }
            case "Mage Outlaw": {
                this.mageOutlawScheduled[0] = false;
                break;
            }
            case "Ashfang": {
                BossNotifier.ashfangScheduled[0] = false;
                break;
            }
            case "Barbarian Duke X": {
                BossNotifier.barbarianDukeXScheduled[0] = false;
            }
        }
    }

    private static void playCountdownSound(final int times) {
        ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(4);
        for (int i = 0; i < times; ++i) {
            exec.schedule(new Runnable(){

                @Override
                public void run() {
                    SoundUtils.playSound(Minecraft.func_71410_x().field_71439_g.func_180425_c(), BossNotifier.countdownSound, 2.0f, 1.0f + (float)(times * 2) / 10.0f);
                }
            }, (long)i, TimeUnit.SECONDS);
        }
    }

    public static boolean[] getAshfangScheduled() {
        return ashfangScheduled;
    }
}

