/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.diana;

import java.awt.Color;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.PacketReadEvent;
import org.ginafro.notenoughfakepixel.events.RenderEntityModelEvent;
import org.ginafro.notenoughfakepixel.features.skyblock.diana.GaiaConstruct;
import org.ginafro.notenoughfakepixel.features.skyblock.diana.ParticleProcessor;
import org.ginafro.notenoughfakepixel.features.skyblock.diana.SiameseLynx;
import org.ginafro.notenoughfakepixel.utils.ChatUtils;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.EntityHighlightUtils;
import org.ginafro.notenoughfakepixel.utils.InventoryUtils;
import org.ginafro.notenoughfakepixel.utils.OutlineUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.utils.Waypoint;
import org.ginafro.notenoughfakepixel.variables.MobDisplayTypes;

@RegisterEvents
public class Diana {
    ParticleProcessor processor = new ParticleProcessor();
    private final Queue<GaiaConstruct> listGaiaAlive = new ConcurrentLinkedQueue<GaiaConstruct>();
    private final ConcurrentHashMap<UUID, GaiaConstruct> gaiaById = new ConcurrentHashMap();
    private final Queue<SiameseLynx> listSiameseAlive = new ConcurrentLinkedQueue<SiameseLynx>();
    private final Pattern cooldownPattern = Pattern.compile("\u00a7r\u00a7cThis ability is on cooldown for \\d+ more second(?:s)?\\.\u00a7r");
    private final Pattern minosInquisitorPartyChat = Pattern.compile("\u00a79Party \u00a78> (?:\u00a7[0-9a-f])*\\[?(?:(?:\u00a7[0-9a-f])?[A-Z](?:\u00a7[0-9a-f])?\\+*(?:\u00a7[0-9a-f])?)*\\]?(?:\u00a7[0-9a-f])*.*?: Minos Inquisitor found at .*,? ?x:(-?\\d+), y:(-?\\d+), z:(-?\\d+) in HUB-(1[0-9]|[1-9])");
    private final String inquisitorSound = "mob.enderdragon.growl";
    Instant lastCaptureTime = Instant.now();
    private final Map<String, int[]> locations = new HashMap<String, int[]>();
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    private final Set<EntityLivingBase> isInq = new HashSet<EntityLivingBase>();
    private volatile long lastOutlineScanNs = 0L;

    @SubscribeEvent
    public void onParticlePacketReceive(PacketReadEvent event) {
        if (!Config.feature.diana.dianaShowWaypointsBurrows) {
            return;
        }
        if (!TablistParser.currentLocation.isHub()) {
            return;
        }
        Packet packet = event.packet;
        if (packet instanceof S2APacketParticles) {
            Entity closestSiamese;
            S2APacketParticles particles = (S2APacketParticles)packet;
            if (particles.func_179749_a().func_179346_b().equals("crit") || particles.func_179749_a().func_179346_b().equals("magicCrit") || particles.func_179749_a().func_179346_b().equals("dripLava") || particles.func_179749_a().func_179346_b().equals("enchantmenttable") || particles.func_179749_a().func_179346_b().equals("footstep")) {
                this.processor.addParticle(particles);
            } else if (particles.func_179749_a().func_179346_b().equals("angryVillager") && (closestSiamese = this.getClosestSiamese(new int[]{(int)particles.func_149220_d(), (int)particles.func_149226_e(), (int)particles.func_149225_f()})) != null) {
                for (SiameseLynx siamese : this.listSiameseAlive) {
                    if (siamese.getEntity1() != null && siamese.getEntity1().func_110124_au() == closestSiamese.func_110124_au()) {
                        siamese.setHittable(closestSiamese);
                        break;
                    }
                    if (siamese.getEntity2() != null && siamese.getEntity2().func_110124_au() == closestSiamese.func_110124_au()) {
                        siamese.setHittable(closestSiamese);
                        break;
                    }
                    siamese.setHittable(closestSiamese);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (!TablistParser.currentLocation.isHub()) {
            return;
        }
        if (Config.feature.diana.dianaShowWaypointsBurrows) {
            this.drawWaypoints(event.partialTicks);
        }
        if (Config.feature.diana.dianaShowTracersWaypoints) {
            this.drawTracers(event.partialTicks);
        }
        if (Config.feature.diana.dianaShowLabelsWaypoints) {
            this.drawLabels(event.partialTicks);
        }
        if (Config.feature.diana.dianaGaiaConstruct || Config.feature.diana.dianaSiamese) {
            this.dianaMobCheck();
            this.dianaMobRemover();
            this.dianaMobRender(event.partialTicks);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!TablistParser.currentLocation.isHub()) {
            return;
        }
        if (!Config.feature.diana.dianaMinosInquisitorAlert) {
            return;
        }
        this.initializeLocations();
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre<EntityLivingBase> event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        if (!TablistParser.currentLocation.isHub()) {
            return;
        }
        if (!Config.feature.diana.dianaMinosInquisitorAlert && !Config.feature.diana.dianaMinosInquisitorOutline) {
            return;
        }
        try {
            String entityName = this.getSafeEntityName((Entity)event.entity);
            if (Config.feature.diana.dianaMinosInquisitorAlert && this.containsInquisitor(entityName)) {
                Instant now = Instant.now();
                if (this.lastCaptureTime == null || now.isAfter(this.lastCaptureTime.plusSeconds(63L))) {
                    mc.field_71456_v.func_175178_a("\u00a1Inquisidor detectado!", "", 10, 40, 20);
                    int ex = event.entity.func_180425_c().func_177958_n();
                    int ey = event.entity.func_180425_c().func_177956_o() - 2;
                    int ez = event.entity.func_180425_c().func_177952_p();
                    String loc = this.findNearestLocation(ex, ey, ez);
                    String hub = String.valueOf(ScoreboardUtils.getHubNumber());
                    String msgBase = "Minos Inquisitor found";
                    String where = loc != null && !loc.isEmpty() ? " at " + loc + ", x:" + ex + ", y:" + ey + ", z:" + ez : " at x:" + ex + ", y:" + ey + ", z:" + ez;
                    mc.field_71439_g.func_71165_d("/pc Minos Inquisitor found" + where + " in HUB-" + hub);
                    this.lastCaptureTime = now;
                }
            }
            if (Config.feature.diana.dianaMinosInquisitorOutline) {
                if (Configuration.isPojav()) {
                    return;
                }
                if (System.nanoTime() - this.lastOutlineScanNs < 250000000L) {
                    return;
                }
                this.lastOutlineScanNs = System.nanoTime();
                this.pruneInqCache();
                WorldClient world = mc.field_71441_e;
                if (world == null) {
                    return;
                }
                for (Entity e : world.field_72996_f) {
                    EntityLivingBase inq;
                    EntityArmorStand as;
                    String asName;
                    if (!(e instanceof EntityArmorStand) || !this.containsInquisitor(asName = this.getSafeEntityName((Entity)(as = (EntityArmorStand)e))) || (inq = this.findAssociatedMob(as)) == null) continue;
                    this.isInq.add(inq);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean containsInquisitor(String s) {
        if (s == null) {
            return false;
        }
        String x = s.toLowerCase(Locale.ROOT);
        return x.contains("minos inquisitor");
    }

    private String getSafeEntityName(Entity entity) {
        try {
            String cn;
            if (entity == null) {
                return "";
            }
            if (entity.func_145818_k_() && (cn = entity.func_95999_t()) != null && !cn.isEmpty()) {
                return EnumChatFormatting.func_110646_a((String)cn);
            }
            String n = entity.func_70005_c_();
            return n == null ? "" : EnumChatFormatting.func_110646_a((String)n);
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    private void pruneInqCache() {
        if (this.isInq == null) {
            return;
        }
        this.isInq.removeIf(e -> e == null || e.field_70128_L || e.field_70170_p == null);
    }

    public void clearCache() {
        this.isInq.clear();
    }

    private EntityLivingBase findAssociatedMob(EntityArmorStand armorStand) {
        return armorStand.field_70170_p.func_175647_a(EntityLivingBase.class, armorStand.func_174813_aQ().func_72314_b(1.5, 3.0, 1.5), e -> e != null && !(e instanceof EntityArmorStand) && e != Minecraft.func_71410_x().field_71439_g).stream().findFirst().orElse(null);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderEntityModel(RenderEntityModelEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        EntityLivingBase entity = event.getEntity();
        if (!this.isInq.contains(entity)) {
            return;
        }
        if (entity.func_82150_aj()) {
            return;
        }
        Color color = new Color(ColorUtils.getColor(Config.feature.dungeons.dungeonsStarredBoxColor).getRGB());
        if (Configuration.isPojav()) {
            EntityHighlightUtils.renderEntityOutline(event, color);
        } else {
            OutlineUtils.outlineEntity(event, 5.0f, color, true);
        }
    }

    public Set<EntityLivingBase> getCurrentEntities() {
        return this.isInq;
    }

    private String findNearestLocation(int playerX, int playerY, int playerZ) {
        String nearestLocation = null;
        double minDistance = Double.MAX_VALUE;
        for (Map.Entry<String, int[]> entry : this.locations.entrySet()) {
            int[] coords = entry.getValue();
            double distance = Math.sqrt(Math.pow(playerX - coords[0], 2.0) + Math.pow(playerY - coords[1], 2.0) + Math.pow(playerZ - coords[2], 2.0));
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestLocation = entry.getKey();
        }
        return nearestLocation;
    }

    private void initializeLocations() {
        this.locations.put("Farm", new int[]{60, 72, -173});
        this.locations.put("Above Coal mine", new int[]{-40, 85, -196});
        this.locations.put("Farm", new int[]{81, 72, -140});
        this.locations.put("2pb NPC", new int[]{83, 72, -102});
        this.locations.put("Colosseum left side", new int[]{101, 72, -73});
        this.locations.put("Wizard tower", new int[]{53, 72, 66});
        this.locations.put("Spider den portal", new int[]{-120, 76, -177});
        this.locations.put("Crypt entrance", new int[]{-173, 74, -92});
        this.locations.put("Dante statue in the graveyard", new int[]{-98, 72, -135});
        this.locations.put("Graveyard entrance", new int[]{-120, 71, -77});
        this.locations.put("Lumber jack npc", new int[]{-114, 74, -32});
        this.locations.put("Park portal", new int[]{-192, 74, -23});
        this.locations.put("Castle / ruins", new int[]{-209, 91, 70});
        this.locations.put("Museum", new int[]{-108, 68, 102});
        this.locations.put("High level", new int[]{-6, 71, 164});
        this.locations.put("Dark auction hut", new int[]{84, 74, 176});
        this.locations.put("Fairy lake in wilderness", new int[]{110, 66, 114});
        this.locations.put("Colosseum", new int[]{143, 76, -17});
    }

    private void drawWaypoints(float partialTicks) {
        ArrayList<Waypoint> safeResults = new ArrayList<Waypoint>(this.processor.getWaypoints());
        if (safeResults.isEmpty()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        int[] playerPos = new int[]{(int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v)};
        for (Waypoint result : safeResults) {
            if (result.isHidden()) continue;
            Color newColor = this.burrowColor(result.getType());
            BlockPos posAbsolute = new BlockPos(result.getCoordinates()[0], result.getCoordinates()[1] - 1, result.getCoordinates()[2]);
            int[] waypointPos = result.getCoordinates();
            boolean isClose = Math.abs(playerPos[0] - waypointPos[0]) <= 5 && Math.abs(playerPos[2] - waypointPos[2]) <= 5;
            RenderUtils.highlightBlock(posAbsolute, newColor, true, partialTicks);
            if (!isClose) {
                RenderUtils.renderBeaconBeam(posAbsolute, newColor.getRGB(), 1.0f, partialTicks);
            }
            GlStateManager.func_179098_w();
        }
    }

    private Color burrowColor(String type) {
        Color burrowColor = new Color(255, 255, 255, 100);
        switch (type) {
            case "EMPTY": {
                burrowColor = ColorUtils.getColor(Config.feature.diana.dianaEmptyBurrowColor);
                break;
            }
            case "MOB": {
                burrowColor = ColorUtils.getColor(Config.feature.diana.dianaMobBurrowColor);
                break;
            }
            case "TREASURE": {
                burrowColor = ColorUtils.getColor(Config.feature.diana.dianaTreasureBurrowColor);
                break;
            }
            case "MINOS": {
                burrowColor = new Color(243, 225, 107);
            }
        }
        burrowColor = new Color(burrowColor.getRed(), burrowColor.getGreen(), burrowColor.getBlue(), 100);
        return burrowColor;
    }

    private void drawTracers(float partialTicks) {
        List<Waypoint> safeResults = this.processor.getWaypoints();
        if (safeResults.isEmpty()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        for (Waypoint result : safeResults) {
            if (result.isHidden()) continue;
            Color newColor = this.burrowColor(result.getType());
            newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), 255);
            RenderUtils.draw3DLine(new Vec3((double)result.getCoordinates()[0] + 0.5, (double)result.getCoordinates()[1], (double)result.getCoordinates()[2] + 0.5), player.func_174824_e(partialTicks), newColor, 4, true, partialTicks);
        }
    }

    private void drawLabels(float partialTicks) {
        List<Waypoint> safeResults = this.processor.getWaypoints();
        if (safeResults.isEmpty()) {
            return;
        }
        for (Waypoint result : safeResults) {
            String displayName;
            if (result.isHidden()) continue;
            switch (result.getType()) {
                case "MINOS": {
                    displayName = "Inquisitor";
                    break;
                }
                case "EMPTY": {
                    displayName = "EMPTY";
                    break;
                }
                case "MOB": {
                    displayName = "MOB";
                    break;
                }
                case "TREASURE": {
                    displayName = "TREASURE";
                    break;
                }
                default: {
                    displayName = result.getType();
                }
            }
            BlockPos pos = new BlockPos(result.getCoordinates()[0], result.getCoordinates()[1] + 1, result.getCoordinates()[2]);
            RenderUtils.renderWaypointText(displayName, pos, partialTicks);
        }
    }

    private void dianaMobRender(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        for (Entity entity : new ArrayList(world.field_72996_f)) {
            if (entity == null) {
                return;
            }
            if (entity.func_70005_c_() == null) {
                return;
            }
            if (entity instanceof EntityGolem) {
                GaiaConstruct gaia = this.gaiaById.get(entity.func_110124_au());
                if (gaia == null) continue;
                Entity gaiaEntity = gaia.getEntity();
                if (gaia.canBeHit()) {
                    RenderUtils.renderEntityHitbox(gaiaEntity, partialTicks, new Color(ColorUtils.getColor(Config.feature.diana.dianaGaiaHittableColor).getRed(), ColorUtils.getColor(Config.feature.diana.dianaGaiaHittableColor).getGreen(), ColorUtils.getColor(Config.feature.diana.dianaGaiaHittableColor).getBlue(), 150), MobDisplayTypes.GAIA);
                    continue;
                }
                RenderUtils.renderEntityHitbox(gaiaEntity, partialTicks, new Color(ColorUtils.getColor(Config.feature.diana.dianaGaiaUnhittableColor).getRed(), ColorUtils.getColor(Config.feature.diana.dianaGaiaUnhittableColor).getGreen(), ColorUtils.getColor(Config.feature.diana.dianaGaiaUnhittableColor).getBlue(), 150), MobDisplayTypes.GAIA);
                continue;
            }
            if (!(entity instanceof EntityOcelot)) continue;
            for (SiameseLynx siamese : this.listSiameseAlive) {
                if (siamese.getHittable() == null) continue;
                RenderUtils.renderEntityHitbox(siamese.getHittable(), partialTicks, new Color(ColorUtils.getColor(Config.feature.diana.dianaSiameseHittableColor).getRed(), ColorUtils.getColor(Config.feature.diana.dianaSiameseHittableColor).getGreen(), ColorUtils.getColor(Config.feature.diana.dianaSiameseHittableColor).getBlue(), 150), MobDisplayTypes.SIAMESE);
            }
        }
    }

    private void dianaMobCheck() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        new ArrayList<Entity>(world.field_72996_f).forEach(entity -> {
            if (entity == null) {
                return;
            }
            if (entity.func_70005_c_() == null) {
                return;
            }
            if (entity instanceof EntityGolem) {
                UUID id = entity.func_110124_au();
                this.gaiaById.computeIfAbsent(id, k -> new GaiaConstruct((Entity)entity));
            } else if (entity instanceof EntityArmorStand) {
                if (!entity.func_145748_c_().func_150260_c().contains("Bagheera") && !entity.func_145748_c_().func_150260_c().contains("Azrael")) {
                    return;
                }
                for (SiameseLynx siamese : this.listSiameseAlive) {
                    if (siamese.getEntity1() == null) {
                        return;
                    }
                    if (siamese.getEntity1().func_110124_au() == entity.func_110124_au()) {
                        return;
                    }
                    if (siamese.getEntity2() == null) {
                        siamese.setEntity2((Entity)entity);
                    }
                    if (siamese.getEntity2().func_110124_au() != entity.func_110124_au()) continue;
                    return;
                }
                this.listSiameseAlive.add(new SiameseLynx((Entity)entity));
            }
        });
    }

    private void dianaMobRemover() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        int[] playerCoords = new int[]{(int)mc.field_71439_g.field_70165_t, (int)mc.field_71439_g.field_70163_u, (int)mc.field_71439_g.field_70161_v};
        int distanceRenderHitbox = 64;
        this.listGaiaAlive.removeIf(gaia -> {
            Entity e = gaia.getEntity();
            if (e == null) {
                return true;
            }
            int[] c = new int[]{e.func_180425_c().func_177958_n(), e.func_180425_c().func_177956_o(), e.func_180425_c().func_177952_p()};
            return !this.processor.areCoordinatesClose(playerCoords, c, 64.0f);
        });
        this.listSiameseAlive.removeIf(s -> {
            boolean allGone = true;
            if (s.getEntity1() != null) {
                int[] c1 = new int[]{s.getEntity1().func_180425_c().func_177958_n(), s.getEntity1().func_180425_c().func_177956_o(), s.getEntity1().func_180425_c().func_177952_p()};
                if (!this.processor.areCoordinatesClose(playerCoords, c1, 64.0f)) {
                    s.setEntity1(null);
                }
                allGone &= s.getEntity1() == null;
            }
            if (s.getEntity2() != null) {
                int[] c2 = new int[]{s.getEntity2().func_180425_c().func_177958_n(), s.getEntity2().func_180425_c().func_177956_o(), s.getEntity2().func_180425_c().func_177952_p()};
                if (!this.processor.areCoordinatesClose(playerCoords, c2, 64.0f)) {
                    s.setEntity2(null);
                }
                allGone &= s.getEntity2() == null;
            }
            return allGone;
        });
    }

    @SubscribeEvent
    public void onSoundPacketReceive(PacketReadEvent event) {
        if (!TablistParser.currentLocation.isHub()) {
            return;
        }
        Packet packet = event.packet;
        if (packet instanceof S29PacketSoundEffect) {
            String soundName;
            S29PacketSoundEffect soundEffect = (S29PacketSoundEffect)packet;
            int[] coordsSound = new int[]{(int)Math.floor(soundEffect.func_149207_d()), (int)Math.floor(soundEffect.func_149211_e()), (int)Math.floor(soundEffect.func_149210_f())};
            switch (soundName = soundEffect.func_149212_c()) {
                case "random.explode": {
                    if (!Config.feature.diana.dianaDisableDianaExplosionSounds) {
                        return;
                    }
                    if (Math.floor(soundEffect.func_149209_h() * 1000.0f) / 1000.0 != 1.19 || !event.isCancelable()) break;
                    event.setCanceled(true);
                    break;
                }
                case "note.pling": {
                    if (!Config.feature.diana.dianaShowWaypointsBurrows) break;
                    this.deleteClosestWaypoint(coordsSound[0], coordsSound[1], coordsSound[2]);
                    break;
                }
                case "mob.zombie.metal": 
                case "mob.irongolem.death": 
                case "mob.irongolem.hit": {
                    if (!Config.feature.diana.dianaGaiaConstruct) {
                        return;
                    }
                    final GaiaConstruct closestGaia = this.getClosestGaia(coordsSound);
                    if (closestGaia == null) {
                        return;
                    }
                    if (soundName.equals("mob.zombie.metal")) {
                        closestGaia.addHit();
                        break;
                    }
                    if (soundName.equals("mob.irongolem.hit")) {
                        closestGaia.hurtAction();
                        break;
                    }
                    this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            Diana.this.listGaiaAlive.remove(closestGaia);
                        }
                    }, 1L, TimeUnit.SECONDS);
                    break;
                }
            }
        }
    }

    private GaiaConstruct getClosestGaia(int[] coords) {
        GaiaConstruct returnedGaia = null;
        float distance = Float.MAX_VALUE;
        for (GaiaConstruct gaia : this.listGaiaAlive) {
            int[] nArray = new int[]{gaia.getEntity().func_180425_c().func_177958_n(), gaia.getEntity().func_180425_c().func_177956_o(), gaia.getEntity().func_180425_c().func_177952_p()};
            int[] coordsGaia = nArray;
            if (!(ParticleProcessor.getDistance(coords, coordsGaia) < distance)) continue;
            distance = ParticleProcessor.getDistance(coords, coordsGaia);
            returnedGaia = gaia;
        }
        return returnedGaia;
    }

    private Entity getClosestSiamese(int[] coords) {
        Entity returnedSiamese = null;
        float distance = Float.MAX_VALUE;
        for (SiameseLynx siamese : this.listSiameseAlive) {
            if (siamese.getEntity1() != null) {
                int[] nArray = new int[]{siamese.getEntity1().func_180425_c().func_177958_n(), siamese.getEntity1().func_180425_c().func_177956_o(), siamese.getEntity1().func_180425_c().func_177952_p()};
                int[] coordsSiamese1 = nArray;
                if (ParticleProcessor.getDistance(coords, coordsSiamese1) < distance) {
                    distance = ParticleProcessor.getDistance(coords, coordsSiamese1);
                    returnedSiamese = siamese.getEntity1();
                }
            }
            if (siamese.getEntity2() == null) continue;
            int[] nArray = new int[]{siamese.getEntity2().func_180425_c().func_177958_n(), siamese.getEntity2().func_180425_c().func_177956_o(), siamese.getEntity2().func_180425_c().func_177952_p()};
            int[] coordsSiamese2 = nArray;
            if (!(ParticleProcessor.getDistance(coords, coordsSiamese2) < distance)) continue;
            distance = ParticleProcessor.getDistance(coords, coordsSiamese2);
            returnedSiamese = siamese.getEntity2();
        }
        return returnedSiamese;
    }

    private void deleteClosestWaypoint(int x, int y, int z) {
        int[] coords = new int[]{x, y, z};
        Waypoint res = this.processor.getClosestWaypoint(coords);
        if (res != null && this.processor.areCoordinatesClose(res.getCoordinates(), coords, 3.0f)) {
            res.setHidden(true);
            this.scheduler.schedule(() -> this.processor.deleteWaypoint(res), 30L, TimeUnit.SECONDS);
        }
    }

    @SubscribeEvent
    public void onChatRecieve(ClientChatReceivedEvent event) {
        Matcher matcher;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!TablistParser.currentLocation.isHub()) {
            return;
        }
        if (ChatUtils.middleBar.matcher(event.message.func_150254_d()).matches()) {
            return;
        }
        if (Config.feature.diana.dianaCancelCooldownSpadeMessage && InventoryUtils.getSlot("Ancestral Spade") == InventoryUtils.getCurrentSlot()) {
            this.cancelMessage(true, event, this.cooldownPattern, true);
        }
        if (Config.feature.diana.dianaMinosInquisitorAlert && (matcher = this.minosInquisitorPartyChat.matcher(event.message.func_150254_d())).find()) {
            int x = Integer.parseInt(matcher.group(1));
            int y = Integer.parseInt(matcher.group(2));
            int z = Integer.parseInt(matcher.group(3));
            int hubNumber = Integer.parseInt(matcher.group(4));
            int[] coords = new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()};
            SoundUtils.playSound(coords, "mob.enderdragon.growl", 3.0f, 0.8f);
            if (ScoreboardUtils.getHubNumber() == hubNumber) {
                final Waypoint wp = new Waypoint("MINOS", new int[]{x, y, z});
                this.processor.deleteWaypoint(this.processor.getClosestWaypoint(new int[]{x, y, z}));
                this.processor.addWaypoint(wp);
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "30 seconds for despawn!"));
                    }
                }, 30L, TimeUnit.SECONDS);
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "10 seconds for despawn!"));
                    }
                }, 50L, TimeUnit.SECONDS);
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Diana.this.processor.deleteWaypoint(wp);
                    }
                }, 60L, TimeUnit.SECONDS);
            }
        }
    }

    private void cancelMessage(boolean option, ClientChatReceivedEvent e, Pattern pattern, boolean formatted) {
        if (!option) {
            return;
        }
        String message = e.message.func_150260_c();
        if (formatted) {
            message = e.message.func_150254_d();
        }
        if (pattern.matcher(message).find() || pattern.matcher(message).matches()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (Config.feature.diana.dianaShowWaypointsBurrows) {
            this.processor.clearWaypoints();
        }
        if (Config.feature.diana.dianaGaiaConstruct) {
            this.listGaiaAlive.clear();
        }
        if (Config.feature.diana.dianaSiamese) {
            this.listSiameseAlive.clear();
        }
        this.scheduler.getQueue().clear();
    }
}

