/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.diana;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class GaiaConstruct {
    private final Entity entity;
    private float maxHp;
    private int state;
    private boolean canBeHit;
    private int hits;
    private final int[] hitsNeeded;

    public GaiaConstruct(Entity entity) {
        this.entity = entity;
        this.state = 0;
        this.canBeHit = false;
        this.hits = 0;
        this.hitsNeeded = new int[]{6, 7, 8};
        EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
        float hp = entityLivingBase.func_110143_aJ();
        float hpGaiaConstruct140 = 300000.0f;
        float diffTo140 = Math.abs(hp - hpGaiaConstruct140);
        float hpGaiaConstruct260 = 1500000.0f;
        float diffTo260 = Math.abs(hp - hpGaiaConstruct260);
        this.maxHp = hpGaiaConstruct260;
        if (diffTo140 < diffTo260) {
            this.maxHp = hpGaiaConstruct140;
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public float getMaxHp() {
        return this.maxHp;
    }

    public int getState() {
        return this.state;
    }

    public void setStateFromHp() {
        EntityLivingBase entityLivingBase = (EntityLivingBase)this.entity;
        int previousState = this.state;
        if ((double)(entityLivingBase.func_110143_aJ() / this.maxHp) >= 0.66) {
            this.state = 0;
        } else if (0.33 <= (double)(entityLivingBase.func_110143_aJ() / this.maxHp) && (double)(entityLivingBase.func_110143_aJ() / this.maxHp) < 0.66) {
            this.state = 1;
        } else if ((double)(entityLivingBase.func_110143_aJ() / this.maxHp) < 0.33) {
            this.state = 2;
        }
    }

    public int getHits() {
        return this.hits;
    }

    public void addHit() {
        this.setStateFromHp();
        ++this.hits;
        if (this.hits < this.hitsNeeded[this.state] - 1) {
            this.canBeHit = false;
        } else if (this.hits == this.hitsNeeded[this.state] - 1) {
            this.canBeHit = true;
        } else if (this.hits >= this.hitsNeeded[this.state]) {
            this.canBeHit = false;
            this.hits = 0;
        }
    }

    public void hurtAction() {
        this.setHits(0);
        this.setStateFromHp();
        int n = this.state;
        this.hitsNeeded[n] = this.hitsNeeded[n] + 1;
        this.canBeHit = false;
    }

    public void setHits(int hits) {
        this.hits = hits;
        this.setStateFromHp();
    }

    public boolean canBeHit() {
        return this.canBeHit;
    }

    public int[] getHitsNeeded() {
        return this.hitsNeeded;
    }
}

