/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.diana;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.init.Blocks;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.config.gui.core.config.KeybindHelper;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.PacketReadEvent;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class GuessBurrow {
    int dingIndex = 0;
    boolean hasDinged = false;
    Float firstPitch = Float.valueOf(0.0f);
    Float lastDingPitch = Float.valueOf(0.0f);
    Vec3 lastSoundPoint = null;
    Vec3 guessPoint = null;
    ArrayList<Float> dingSlope = new ArrayList();
    Float distance = null;
    private final Queue<S2APacketParticles> particleDripLavaQueue = new LinkedList<S2APacketParticles>();
    private final ArrayList<Vec3> particleLocations = new ArrayList();
    private String displayText = null;
    private String warpCommand = null;
    private long cooldownEndTime = 0L;
    private boolean wasKeyPressed = false;
    private static final WarpLocation[] WARP_LOCATIONS = new WarpLocation[]{new WarpLocation("Crypts", new Vec3(-187.0, 74.0, -86.0), "/warp crypts"), new WarpLocation("Hub", new Vec3(-2.0, 70.0, -68.0), "/warp hub"), new WarpLocation("Castle", new Vec3(-248.0, 130.0, 44.0), "/warp castle"), new WarpLocation("Dark Auction", new Vec3(91.0, 74.0, 173.0), "/warp da"), new WarpLocation("Museum", new Vec3(-69.0, 76.0, 80.0), "/warp museum")};

    @SubscribeEvent
    public void onPacketRead(PacketReadEvent event) {
        if (!TablistParser.currentLocation.isHub()) {
            return;
        }
        if (event.packet instanceof S29PacketSoundEffect) {
            S29PacketSoundEffect soundPacket = (S29PacketSoundEffect)event.packet;
            if (!"note.harp".equals(soundPacket.func_149212_c())) {
                return;
            }
            float pitch = soundPacket.func_149209_h();
            Vec3 pos = new Vec3(soundPacket.func_149207_d(), soundPacket.func_149211_e(), soundPacket.func_149210_f());
            if (!this.hasDinged) {
                this.firstPitch = Float.valueOf(pitch);
            }
            this.hasDinged = true;
            if (pitch < this.lastDingPitch.floatValue()) {
                this.firstPitch = Float.valueOf(pitch);
                this.dingIndex = 0;
                this.dingSlope.clear();
                this.lastDingPitch = Float.valueOf(pitch);
                this.lastSoundPoint = null;
                this.distance = null;
                this.particleLocations.clear();
            }
            if (this.lastDingPitch.floatValue() == 0.0f) {
                this.lastDingPitch = Float.valueOf(pitch);
                this.distance = null;
                this.lastSoundPoint = null;
                this.particleLocations.clear();
                return;
            }
            ++this.dingIndex;
            if (this.dingIndex > 1) {
                this.dingSlope.add(Float.valueOf(pitch - this.lastDingPitch.floatValue()));
            }
            if (this.dingSlope.size() > 20) {
                this.dingSlope.remove(0);
            }
            Float slope = Float.valueOf(this.dingSlope.isEmpty() ? 0.0f : this.dingSlope.stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue() / (float)this.dingSlope.size());
            this.lastSoundPoint = pos;
            this.lastDingPitch = Float.valueOf(pitch);
            this.distance = Float.valueOf(slope.floatValue() == 0.0f ? 0.0f : (float)(Math.E / (double)slope.floatValue() / 2.8));
            if (pitch > 0.0f) {
                this.distance = Float.valueOf(this.distance.floatValue() * Math.max(0.1f, 2.0f - pitch));
            }
            if (this.distance.floatValue() < 0.0f) {
                this.distance = Float.valueOf(0.0f);
                this.guessPoint = null;
            }
        } else if (event.packet instanceof S2APacketParticles) {
            S2APacketParticles particlePacket = (S2APacketParticles)event.packet;
            this.addParticle(particlePacket);
        }
    }

    public void addParticle(S2APacketParticles particle) {
        switch (particle.func_179749_a().func_179346_b()) {
            case "dripLava": {
                this.particleDripLavaQueue.add(particle);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || !TablistParser.currentLocation.isHub()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || this.lastSoundPoint == null) {
            return;
        }
        while (!this.particleDripLavaQueue.isEmpty()) {
            Vec3 currLoc;
            S2APacketParticles particle = this.particleDripLavaQueue.poll();
            if (particle == null || (currLoc = new Vec3(particle.func_149220_d(), particle.func_149226_e(), particle.func_149225_f())) == null || this.lastSoundPoint == null || !(Math.abs(currLoc.field_72450_a - this.lastSoundPoint.field_72450_a) < 2.0) || !(Math.abs(currLoc.field_72448_b - this.lastSoundPoint.field_72448_b) < 0.5) || !(Math.abs(currLoc.field_72449_c - this.lastSoundPoint.field_72449_c) < 2.0) || this.particleLocations.size() >= 100 || !this.particleLocations.isEmpty() && GuessBurrow.distance(this.particleLocations.get(this.particleLocations.size() - 1), currLoc) == 0.0) continue;
            double distMultiplier = 1.0;
            if (this.particleLocations.size() > 2) {
                double predictedDist = 0.06507 * (double)this.particleLocations.size() + 0.259;
                Vec3 lastPos = this.particleLocations.get(this.particleLocations.size() - 1);
                double actualDist = GuessBurrow.distance(currLoc, lastPos);
                distMultiplier = actualDist / predictedDist;
            }
            this.particleLocations.add(currLoc);
            if (this.particleLocations.size() <= 5 || this.distance == null) continue;
            ArrayList<Double> slopeThing = new ArrayList<Double>();
            for (int i = 0; i < this.particleLocations.size() - 1; ++i) {
                Vec3 a = this.particleLocations.get(i);
                Vec3 b = this.particleLocations.get(i + 1);
                slopeThing.add(Math.atan2(b.field_72449_c - a.field_72449_c, b.field_72450_a - a.field_72450_a));
            }
            Vec3 abc = this.solveEquationThing(new Vec3((double)(slopeThing.size() - 5), (double)(slopeThing.size() - 3), (double)(slopeThing.size() - 1)), new Vec3(((Double)slopeThing.get(slopeThing.size() - 5)).doubleValue(), ((Double)slopeThing.get(slopeThing.size() - 3)).doubleValue(), ((Double)slopeThing.get(slopeThing.size() - 1)).doubleValue()));
            double a = abc.field_72450_a;
            double b = abc.field_72448_b;
            double c = abc.field_72449_c;
            Vec3 lastParticle = this.particleLocations.get(this.particleLocations.size() - 1);
            Vec3 secondLastParticle = this.particleLocations.get(this.particleLocations.size() - 2);
            double dx = lastParticle.field_72450_a - secondLastParticle.field_72450_a;
            double dz = lastParticle.field_72449_c - secondLastParticle.field_72449_c;
            double magnitude = Math.hypot(dx, dz);
            dx /= magnitude;
            dz /= magnitude;
            double[] lastPos = new double[]{lastParticle.field_72450_a, lastParticle.field_72448_b, lastParticle.field_72449_c};
            double distCovered = 0.0;
            for (int i = slopeThing.size() - 1; distCovered < (double)this.distance.floatValue() && i < 10000; ++i) {
                double distStep = distMultiplier * (0.06507 * (double)i + 0.259);
                lastPos[0] = lastPos[0] + dx * distStep;
                lastPos[1] = this.lastSoundPoint.field_72448_b;
                lastPos[2] = lastPos[2] + dz * distStep;
                distCovered = Math.hypot(lastPos[0] - this.lastSoundPoint.field_72450_a, lastPos[2] - this.lastSoundPoint.field_72449_c);
            }
            Vec3 predictedPoint = new Vec3(lastPos[0], lastPos[1], lastPos[2]);
            this.guessPoint = this.findNearestDirtWithAirAbove(mc, predictedPoint);
        }
        if (this.guessPoint != null && Config.feature.diana.dianaWarpHelper && TablistParser.currentLocation.isHub() && mc.field_71441_e != null && mc.field_71439_g != null) {
            Vec3 playerPos = new Vec3(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
            double playerDist = GuessBurrow.distance(playerPos, this.guessPoint);
            WarpLocation bestWarp = null;
            double minWarpDist = Double.MAX_VALUE;
            for (WarpLocation warp : WARP_LOCATIONS) {
                double warpDist;
                boolean isEnabled = true;
                if (warp.command.equals("/warp da")) {
                    isEnabled = Config.feature.diana.dianaWarpDa;
                } else if (warp.command.equals("/warp museum")) {
                    isEnabled = Config.feature.diana.dianaWarpMuseum;
                } else if (warp.command.equals("/warp crypts")) {
                    isEnabled = Config.feature.diana.dianaWarpCrypts;
                } else if (warp.command.equals("/warp castle")) {
                    isEnabled = Config.feature.diana.dianaWarpCastle;
                }
                if (!isEnabled || !((warpDist = GuessBurrow.distance(warp.pos, this.guessPoint)) < minWarpDist)) continue;
                minWarpDist = warpDist;
                bestWarp = warp;
            }
            if (bestWarp != null && minWarpDist < playerDist) {
                String keyName = KeybindHelper.getKeyName(Config.feature.diana.warpKeybind);
                this.displayText = "Warp to " + bestWarp.name + " (" + (keyName != null ? keyName : "None") + ")";
                this.warpCommand = bestWarp.command;
            } else {
                this.displayText = null;
                this.warpCommand = null;
            }
        } else {
            this.displayText = null;
            this.warpCommand = null;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChat) {
            return;
        }
        if (Config.feature.diana.dianaWarpHelper && this.warpCommand != null) {
            boolean keyPressed = KeybindHelper.isKeyDown(Config.feature.diana.warpKeybind);
            if (keyPressed && !this.wasKeyPressed && System.currentTimeMillis() > this.cooldownEndTime) {
                mc.field_71439_g.func_71165_d(this.warpCommand);
                this.cooldownEndTime = System.currentTimeMillis() + 5000L;
                System.out.println("Executed warp: " + this.warpCommand);
                this.resetState();
            }
            this.wasKeyPressed = keyPressed;
        }
    }

    private Vec3 solveEquationThing(Vec3 x, Vec3 y) {
        double a = (-y.field_72450_a * x.field_72448_b * x.field_72450_a - y.field_72448_b * x.field_72448_b * x.field_72449_c + y.field_72448_b * x.field_72448_b * x.field_72450_a + x.field_72448_b * x.field_72449_c * y.field_72449_c + x.field_72450_a * x.field_72449_c * y.field_72450_a - x.field_72450_a * x.field_72449_c * y.field_72449_c) / (x.field_72448_b * y.field_72450_a - x.field_72448_b * y.field_72449_c + x.field_72450_a * y.field_72449_c - y.field_72450_a * x.field_72449_c + y.field_72448_b * x.field_72449_c - y.field_72448_b * x.field_72450_a);
        double b = (y.field_72450_a - y.field_72448_b) * (x.field_72450_a + a) * (x.field_72448_b + a) / (x.field_72448_b - x.field_72450_a);
        double c = y.field_72450_a - b / (x.field_72450_a + a);
        return new Vec3(a, b, c);
    }

    private Vec3 findNearestDirtWithAirAbove(Minecraft mc, Vec3 point) {
        Block blockAbove;
        Block block;
        BlockPos pos;
        int yStart;
        int y;
        int x = (int)Math.floor(point.field_72450_a);
        int z = (int)Math.floor(point.field_72449_c);
        for (y = yStart = Math.max(1, Math.min(255, (int)Math.floor(point.field_72448_b))); y > 0; --y) {
            pos = new BlockPos(x, y, z);
            block = mc.field_71441_e.func_180495_p(pos).func_177230_c();
            blockAbove = mc.field_71441_e.func_180495_p(pos.func_177984_a()).func_177230_c();
            if (block != Blocks.field_150346_d && block != Blocks.field_150349_c || blockAbove != Blocks.field_150350_a) continue;
            return new Vec3((double)x + 0.5, (double)y, (double)z + 0.5);
        }
        for (y = yStart + 1; y < 255; ++y) {
            pos = new BlockPos(x, y, z);
            block = mc.field_71441_e.func_180495_p(pos).func_177230_c();
            blockAbove = mc.field_71441_e.func_180495_p(pos.func_177984_a()).func_177230_c();
            if (block != Blocks.field_150346_d && block != Blocks.field_150349_c || blockAbove != Blocks.field_150350_a) continue;
            return new Vec3((double)x + 0.5, (double)y, (double)z + 0.5);
        }
        double playerY = mc.field_71439_g.field_70163_u;
        int yFallback = Math.max(1, Math.min(255, (int)Math.floor(playerY)));
        BlockPos pos2 = new BlockPos(x, yFallback, z);
        Block block2 = mc.field_71441_e.func_180495_p(pos2).func_177230_c();
        Block blockAbove2 = mc.field_71441_e.func_180495_p(pos2.func_177984_a()).func_177230_c();
        if ((block2 == Blocks.field_150346_d || block2 == Blocks.field_150349_c) && blockAbove2 == Blocks.field_150350_a) {
            return new Vec3((double)x + 0.5, (double)yFallback, (double)z + 0.5);
        }
        return new Vec3((double)x + 0.5, (double)yFallback, (double)z + 0.5);
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent event) {
        if (this.guessPoint != null && Config.feature.diana.dianaBurrowGuess) {
            BlockPos loc = new BlockPos(this.guessPoint.field_72450_a, this.guessPoint.field_72448_b + 1.0, this.guessPoint.field_72449_c);
            AxisAlignedBB aabb = new AxisAlignedBB((double)loc.func_177958_n(), (double)loc.func_177956_o(), (double)loc.func_177952_p(), (double)(loc.func_177958_n() + 1), (double)(loc.func_177956_o() + 1), (double)(loc.func_177952_p() + 1));
            RenderUtils.renderWaypointText("Burrow Guess", loc, event.partialTicks);
            RenderUtils.drawOutlinedBoundingBox(aabb, Color.GREEN, 2.0f, event.partialTicks);
        }
    }

    public static double distance(Vec3 d1, Vec3 d2) {
        return d1.func_72438_d(d2);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.guessPoint = null;
        this.resetState();
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL || this.displayText == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc);
        int textWidth = mc.field_71466_p.func_78256_a(this.displayText);
        int textHeight = mc.field_71466_p.field_78288_b;
        int x = Config.feature.diana.warpHelperPos.getAbsX(sr, textWidth);
        int y = Config.feature.diana.warpHelperPos.getAbsY(sr, textHeight);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)Config.feature.diana.warpHelperScale, (float)Config.feature.diana.warpHelperScale, (float)1.0f);
        mc.field_71466_p.func_175063_a(this.displayText, 0.0f, 0.0f, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void resetState() {
        this.displayText = null;
        this.warpCommand = null;
        this.wasKeyPressed = false;
    }

    public static class WarpLocation {
        public String name;
        public Vec3 pos;
        public String command;

        public WarpLocation(String name, Vec3 pos, String command) {
            this.name = name;
            this.pos = pos;
            this.command = command;
        }
    }
}

