/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.diana;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.BlockPos;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.Waypoint;

public class ParticleProcessor {
    private final String waypointSound = "random.pop";
    private final String waypointTreasureSound = "random.pop";
    private final float volumeWaypointSound = 4.0f;
    private final float volumeWaypointTreasureSound = 3.0f;
    private final float distanceThreshold = 2.0f;
    private final int particleThreshold = 6;
    private final Queue<S2APacketParticles> particleEnchantmentTableQueue = new ConcurrentLinkedQueue<S2APacketParticles>();
    private final Queue<S2APacketParticles> particleCritQueue = new ConcurrentLinkedQueue<S2APacketParticles>();
    private final Queue<S2APacketParticles> particleMagicCritQueue = new ConcurrentLinkedQueue<S2APacketParticles>();
    private final Queue<S2APacketParticles> particleDripLavaQueue = new ConcurrentLinkedQueue<S2APacketParticles>();
    private final List<Waypoint> waypoints = new CopyOnWriteArrayList<Waypoint>();
    private final Executor particleExecutor = Executors.newSingleThreadExecutor();

    public void addParticle(S2APacketParticles particle) {
        if (particle == null) {
            return;
        }
        switch (particle.func_179749_a().func_179346_b()) {
            case "crit": {
                this.particleCritQueue.add(particle);
                break;
            }
            case "magicCrit": {
                this.particleMagicCritQueue.add(particle);
                break;
            }
            case "enchantmenttable": {
                this.particleEnchantmentTableQueue.add(particle);
                break;
            }
            case "dripLava": {
                this.particleDripLavaQueue.add(particle);
                break;
            }
            default: {
                return;
            }
        }
        this.particleExecutor.execute(this::processParticles);
    }

    public void processParticles() {
        if (this.particleEnchantmentTableQueue.isEmpty()) {
            return;
        }
        int[] playerPos = new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()};
        this.waypoints.removeIf(waypoint -> !waypoint.getType().equals("MINOS") && !this.areCoordinatesClose(playerPos, waypoint.getCoordinates(), 64.0f));
        Waypoint result = this.detectResult();
        if (result == null) {
            return;
        }
        BlockPos block = new BlockPos(result.getCoordinates()[0], result.getCoordinates()[1] - 1, result.getCoordinates()[2]);
        if (!this.isDuplicateResult(result) && !Minecraft.func_71410_x().field_71441_e.func_175623_d(block)) {
            this.waypoints.add(result);
            if (Config.feature.diana.dianaWaypointSounds) {
                if (result.getType().equals("EMPTY") || result.getType().equals("MOB")) {
                    SoundUtils.playSound(result.getCoordinates(), "random.pop", 4.0f, 2.0f);
                } else if (result.getType().equals("TREASURE")) {
                    SoundUtils.playSound(result.getCoordinates(), "random.pop", 3.0f, 0.5f);
                }
            }
        }
    }

    private Waypoint detectResult() {
        if (this.particleEnchantmentTableQueue.isEmpty()) {
            return null;
        }
        Queue<S2APacketParticles> largestQueue = this.getLargestQueue();
        if (largestQueue == null || largestQueue.size() < 6) {
            return null;
        }
        S2APacketParticles enchParticle = this.particleEnchantmentTableQueue.poll();
        ArrayList<S2APacketParticles> combinedParticles = new ArrayList<S2APacketParticles>();
        combinedParticles.add(enchParticle);
        this.particleEnchantmentTableQueue.clear();
        largestQueue.removeIf(particle -> particle == null || !this.areCoordinatesClose(this.roundToCoords(particle.func_149220_d(), particle.func_149226_e(), particle.func_149225_f()), this.roundToCoords(enchParticle.func_149220_d(), enchParticle.func_149226_e(), enchParticle.func_149225_f()), 2.0f));
        combinedParticles.addAll(largestQueue);
        largestQueue.clear();
        this.particleCritQueue.clear();
        this.particleMagicCritQueue.clear();
        this.particleDripLavaQueue.clear();
        Waypoint waypoint = this.classifyGroup(combinedParticles);
        return waypoint != null && this.isDevPetClose(waypoint.getCoordinates()) ? null : waypoint;
    }

    private Queue<S2APacketParticles> getLargestQueue() {
        return Arrays.asList(this.particleCritQueue, this.particleMagicCritQueue, this.particleDripLavaQueue).stream().max(Comparator.comparingInt(Collection::size)).orElse(null);
    }

    private Waypoint classifyGroup(List<S2APacketParticles> group) {
        if (group == null || group.isEmpty()) {
            return null;
        }
        HashSet<String> groupTypes = new HashSet<String>();
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (S2APacketParticles particle : group) {
            String particleName;
            if (particle == null || particle.func_179749_a() == null || (particleName = particle.func_179749_a().func_179346_b()) == null) continue;
            groupTypes.add(particleName);
            sumX += particle.func_149220_d();
            sumY += particle.func_149226_e();
            sumZ += particle.func_149225_f();
        }
        if (groupTypes.isEmpty()) {
            return null;
        }
        int size = group.size();
        int[] avgCoordinates = new int[]{(int)Math.floor(sumX / (double)size), (int)Math.floor(sumY / (double)size), (int)Math.floor(sumZ / (double)size)};
        if (groupTypes.containsAll(Arrays.asList("magicCrit", "enchantmenttable"))) {
            return new Waypoint("EMPTY", avgCoordinates);
        }
        if (groupTypes.containsAll(Arrays.asList("crit", "enchantmenttable"))) {
            return new Waypoint("MOB", avgCoordinates);
        }
        if (groupTypes.containsAll(Arrays.asList("dripLava", "enchantmenttable"))) {
            return new Waypoint("TREASURE", avgCoordinates);
        }
        return null;
    }

    private boolean isDuplicateResult(Waypoint result) {
        if (result == null) {
            return false;
        }
        return this.waypoints.stream().filter(Objects::nonNull).anyMatch(waypoint -> this.areCoordinatesClose(waypoint.getCoordinates(), result.getCoordinates(), 2.0f));
    }

    public boolean areCoordinatesClose(int[] coords1, int[] coords2, float threshold) {
        double distance = Math.sqrt(Math.pow(coords1[0] - coords2[0], 2.0) + Math.pow(coords1[1] - coords2[1], 2.0) + Math.pow(coords1[2] - coords2[2], 2.0));
        return distance < (double)threshold;
    }

    public static float getDistance(int[] coords1, int[] coords2) {
        return (float)Math.sqrt(Math.pow(coords1[0] - coords2[0], 2.0) + Math.pow(coords1[1] - coords2[1], 2.0) + Math.pow(coords1[2] - coords2[2], 2.0));
    }

    private int[] roundToCoords(double x, double y, double z) {
        return new int[]{(int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z)};
    }

    public void addWaypoint(Waypoint waypoint) {
        if (waypoint != null) {
            this.waypoints.add(waypoint);
        }
    }

    public void deleteWaypoint(Waypoint result) {
        this.waypoints.remove(result);
    }

    public void clearWaypoints() {
        this.waypoints.clear();
    }

    public Waypoint getClosestWaypoint(int[] coords) {
        return this.waypoints.stream().min(Comparator.comparing(waypoint -> Float.valueOf(ParticleProcessor.getDistance(coords, waypoint.getCoordinates())))).orElse(null);
    }

    /*
     * Exception decompiling
     */
    private boolean isDevPetClose(int[] coords) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    private static /* synthetic */ boolean lambda$isDevPetClose$6(int[] coords, int[] entityCoords) {
        return ParticleProcessor.getDistance(coords, entityCoords) <= 5.0f;
    }
}

