/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;

@RegisterEvents
public class AutoReadyDungeon {
    private static boolean clicked = false;
    private static int timesClicked = 0;
    private static final Pattern nickedNamePattern = Pattern.compile("\u00a7r\u00a7aYou have successfully changed your nickname to (?<rank>(.+) |\u00a7r\u00a77)(?<name>(.+))\u00a7r\u00a7a!\u00a7r");

    @SubscribeEvent
    public void onGuiOpen(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (clicked) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsAutoReady) {
            return;
        }
        if (!TablistParser.currentLocation.isDungeon()) {
            return;
        }
        if (event.gui == null) {
            return;
        }
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        GuiChest chest = (GuiChest)event.gui;
        Container container = chest.field_147002_h;
        String chestName = TablistParser.currentOpenChestName;
        if (chestName == null || chestName.isEmpty()) {
            return;
        }
        if (chestName.startsWith("Catacombs -")) {
            if (timesClicked >= 7) {
                clicked = true;
                return;
            }
            ContainerChest containerChest = (ContainerChest)container;
            for (Slot slot : containerChest.field_75151_b) {
                ItemStack itemReady;
                String itemName;
                ItemStack item;
                if (slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || (item = slot.func_75211_c()) == null || !(item.func_77973_b() instanceof ItemSkull) || !(itemName = item.func_82833_r()).contains(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) && !itemName.contains(Config.feature.dungeons.dungeonsAutoReadyName) || (itemReady = containerChest.func_75139_a(slot.getSlotIndex() + 9).func_75211_c()) == null) continue;
                if (itemReady.func_77960_j() == 13) {
                    clicked = true;
                    return;
                }
                boolean isNotReady = itemReady.func_77960_j() == 14;
                if (!isNotReady) continue;
                ++timesClicked;
                Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, slot.getSlotIndex() + 9, 0, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, slot.getSlotIndex() + 9, 0, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        clicked = false;
        timesClicked = 0;
    }

    @SubscribeEvent
    public void onChatRecieve(ClientChatReceivedEvent e) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (TablistParser.currentLocation != Location.NONE) {
            return;
        }
        Matcher matcher = nickedNamePattern.matcher(e.message.func_150254_d());
        if (matcher.matches()) {
            Config.feature.dungeons.dungeonsAutoReadyName = matcher.group("name");
        }
        if (e.message.func_150254_d().startsWith("\u00a7r\u00a7aYou have successfully reset your nickname!")) {
            Config.feature.dungeons.dungeonsAutoReadyName = "example name";
        }
    }
}

