/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.RenderEntityModelEvent;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.M7RelicWaypoints;
import org.ginafro.notenoughfakepixel.utils.EntityHighlightUtils;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.MapUtils;
import org.ginafro.notenoughfakepixel.utils.OutlineUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.DungeonFloor;
import org.ginafro.notenoughfakepixel.variables.Location;
import org.ginafro.notenoughfakepixel.variables.Skins;

@RegisterEvents
public class DragonCloseAlert {
    public static DragonCloseAlert INSTANCE;
    private static final List<Orb> ORBS;
    private static final Map<EntityDragon, Color> DRAGON_COLOR_MAP;
    private static final Map<EntityDragon, String> DRAGON_HEALTH_MAP;
    public static final Map<String, Color> DRAGON_COLORS;
    private final Minecraft mc = Minecraft.func_71410_x();

    public DragonCloseAlert() {
        INSTANCE = this;
    }

    @SubscribeEvent
    public void onUnLoad(WorldEvent.Unload e) {
        DRAGON_COLOR_MAP.clear();
        DRAGON_HEALTH_MAP.clear();
    }

    public List<EntityDragon> getDragonsByColor(Color color) {
        return DRAGON_COLOR_MAP.entrySet().stream().filter(entry -> ((Color)entry.getValue()).equals(color)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void registerDragon(EntityDragon dragon, String health) {
        DRAGON_HEALTH_MAP.put(dragon, health);
    }

    @SubscribeEvent
    public void onRender(RenderWorldLastEvent e) {
        if (TablistParser.currentLocation != Location.DUNGEON || ScoreboardUtils.currentFloor != DungeonFloor.M7 || !M7RelicWaypoints.isFinalPhase) {
            return;
        }
        DRAGON_COLOR_MAP.keySet().removeIf(this::isDying);
        DRAGON_HEALTH_MAP.keySet().removeIf(this::isDying);
        this.renderBoxes(e);
        this.renderDragonDistance(e);
    }

    private void renderDragonDistance(RenderWorldLastEvent e) {
        ORBS.forEach(orb -> {
            BlockPos pos = orb.getPos().func_177982_a(0, 20, 0);
            for (EntityDragon dragon : DRAGON_COLOR_MAP.keySet()) {
                double distance;
                Color color;
                if (this.isDying((EntityLivingBase)dragon) || (color = DRAGON_COLOR_MAP.get(dragon)) == null || !color.equals(orb.getColor())) continue;
                String health = DRAGON_HEALTH_MAP.get(dragon);
                if (health != null && !health.isEmpty()) {
                    RenderUtils.renderWaypointText(health, dragon.func_180425_c(), e.partialTicks, false);
                }
                if (!((distance = new Vec3((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_72438_d(new Vec3(dragon.field_70165_t, dragon.field_70163_u, dragon.field_70161_v))) < 20.0)) continue;
                String string = DRAGON_COLORS.entrySet().stream().filter(entry -> ((Color)entry.getValue()).equals(color)).map(Map.Entry::getKey).findFirst().orElse("Dragon");
            }
        });
    }

    private void renderBoxes(RenderWorldLastEvent e) {
        if (!M7RelicWaypoints.isFinalPhase) {
            return;
        }
        this.drawDragonBox(e);
        if (!Config.feature.dungeons.m7Relics) {
            return;
        }
        ORBS.forEach(orb -> {
            Color color = orb.getColor();
            BlockPos position = orb.getPos().func_177982_a(0, 20, 0);
            if (orb.getSkin().equals((Object)Skins.BLUE_RELIC) || orb.getSkin().equals((Object)Skins.ORANGE_RELIC)) {
                RenderUtils.renderBoxAtCoords(position.func_177958_n() - 21, position.func_177956_o() - 11, position.func_177952_p() - 11, position.func_177958_n() + 11, position.func_177956_o() + 11, position.func_177952_p() + 13, e.partialTicks, color, false);
            }
            if (orb.getSkin().equals((Object)Skins.GREEN_RELIC) || orb.getSkin().equals((Object)Skins.RED_RELIC)) {
                RenderUtils.renderBoxAtCoords(position.func_177958_n() - 11, position.func_177956_o() - 11, position.func_177952_p() - 11, position.func_177958_n() + 21, position.func_177956_o() + 11, position.func_177952_p() + 13, e.partialTicks, color, false);
            }
            if (orb.getSkin().equals((Object)Skins.PURPLE_RELIC)) {
                RenderUtils.renderBoxAtCoords(position.func_177958_n() - 11, position.func_177956_o() - 11, position.func_177952_p() - 21, position.func_177958_n() + 13, position.func_177956_o() + 11, position.func_177952_p() + 11, e.partialTicks, color, false);
            }
        });
    }

    private void drawDragonBox(RenderWorldLastEvent e) {
        if (!Config.feature.dungeons.dragOutline) {
            return;
        }
        this.mc.field_71441_e.func_72910_y().forEach(entity -> {
            if (entity instanceof EntityArmorStand) {
                EntityArmorStand stand = (EntityArmorStand)entity;
                ItemStack skull = stand.func_82169_q(3);
                if (skull == null || skull.func_77973_b() == null || !skull.func_77973_b().func_77658_a().contains("skull")) {
                    return;
                }
                String texture = ItemUtils.getSkullTexture(skull);
                if (texture == null || texture.isEmpty()) {
                    return;
                }
                List skins = ORBS.stream().map(Orb::getSkin).collect(Collectors.toList());
                Skins skin = Skins.getSkinByValue(texture);
                if (skin == null || !skins.contains((Object)skin)) {
                    return;
                }
                Color color = ORBS.stream().filter(orb -> orb.getSkin().equals((Object)skin)).map(Orb::getColor).findFirst().orElse(Color.WHITE);
                EntityLivingBase entityLiving = stand.field_70170_p.func_175647_a(EntityLivingBase.class, stand.func_174813_aQ().func_72314_b(1.5, 3.0, 1.5), e1 -> e1 instanceof EntityDragon && !e1.field_70128_L && e1 != this.mc.field_71439_g).stream().findFirst().orElse(null);
                if (entityLiving instanceof EntityDragon) {
                    EntityDragon dragon = (EntityDragon)entityLiving;
                    if (this.isDying((EntityLivingBase)dragon)) {
                        return;
                    }
                    DRAGON_COLOR_MAP.put(dragon, color);
                }
            }
        });
    }

    @SubscribeEvent
    public void render(RenderEntityModelEvent e) {
        if (!Config.feature.dungeons.dragOutline) {
            return;
        }
        EntityLivingBase entity = e.getEntity();
        if (this.mc.field_71439_g == null || this.mc.field_71441_e == null) {
            return;
        }
        if (!(entity instanceof EntityDragon) || entity.func_82150_aj() || this.isDying(entity)) {
            return;
        }
        EntityDragon dragon = (EntityDragon)entity;
        if (dragon.field_70128_L || dragon.func_110143_aJ() <= 0.1f) {
            return;
        }
        Color c = DRAGON_COLOR_MAP.get(dragon);
        if (c != null) {
            if (Configuration.isPojav()) {
                EntityHighlightUtils.renderEntityOutline(e, c);
            } else {
                OutlineUtils.outlineEntity(e, 4.0f, c, true);
            }
        }
    }

    private boolean isDying(EntityLivingBase entity) {
        return entity == null || entity.field_70128_L || entity.func_110143_aJ() <= 0.1f;
    }

    public static DragonCloseAlert getINSTANCE() {
        return INSTANCE;
    }

    static {
        ORBS = Arrays.asList(new Orb(new BlockPos(43, 6, 64), Skins.RED_RELIC, Color.RED), new Orb(new BlockPos(43, 6, 102), Skins.GREEN_RELIC, Color.GREEN), new Orb(new BlockPos(85, 6, 102), Skins.BLUE_RELIC, Color.CYAN), new Orb(new BlockPos(85, 6, 64), Skins.ORANGE_RELIC, Color.ORANGE), new Orb(new BlockPos(64, 6, 125), Skins.PURPLE_RELIC, Color.PINK));
        DRAGON_COLOR_MAP = new HashMap<EntityDragon, Color>();
        DRAGON_HEALTH_MAP = new HashMap<EntityDragon, String>();
        DRAGON_COLORS = MapUtils.mapOf(new MapUtils.Pair<String, Color>("Apex Dragon", Color.GREEN), new MapUtils.Pair<String, Color>("Flame Dragon", Color.ORANGE), new MapUtils.Pair<String, Color>("Power Dragon", Color.RED), new MapUtils.Pair<String, Color>("Soul Dragon", Color.PINK), new MapUtils.Pair<String, Color>("Ice Dragon", Color.CYAN));
    }

    private static class Orb {
        private final BlockPos pos;
        private final Skins skin;
        private final Color color;

        public Orb(BlockPos pos, Skins skin, Color color) {
            this.pos = pos;
            this.skin = skin;
            this.color = color;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Skins getSkin() {
            return this.skin;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Orb)) {
                return false;
            }
            Orb other = (Orb)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            Skins this$skin = this.getSkin();
            Skins other$skin = other.getSkin();
            if (this$skin == null ? other$skin != null : !((Object)((Object)this$skin)).equals((Object)other$skin)) {
                return false;
            }
            Color this$color = this.getColor();
            Color other$color = other.getColor();
            return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Orb;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            Skins $skin = this.getSkin();
            result = result * 59 + ($skin == null ? 43 : ((Object)((Object)$skin)).hashCode());
            Color $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
            return result;
        }

        public String toString() {
            return "DragonCloseAlert.Orb(pos=" + this.getPos() + ", skin=" + (Object)((Object)this.getSkin()) + ", color=" + this.getColor() + ")";
        }
    }
}

