/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons;

import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;

@RegisterEvents
public class DungeonManager {
    private static boolean isBossStage = false;
    private static boolean isFinalStage = false;

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        if (event.message.func_150260_c().contains("> EXTRA STATS <")) {
            isFinalStage = true;
            isBossStage = false;
        } else if (event.message.func_150260_c().contains("[BOSS]")) {
            isBossStage = true;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        isBossStage = false;
        isFinalStage = false;
    }

    public static boolean checkEssentials() {
        return ScoreboardUtils.currentGamemode.isSkyblock() && TablistParser.currentLocation.isDungeon();
    }

    public static boolean checkEssentialsF7() {
        return DungeonManager.checkEssentials() && (ScoreboardUtils.currentFloor.name().equals("F7") || ScoreboardUtils.currentFloor.name().equals("M7"));
    }

    public static boolean isBossStage() {
        return isBossStage;
    }

    public static boolean isFinalStage() {
        return isFinalStage;
    }
}

