/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec4b;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.variables.Resources;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class DungeonsMap {
    private static final float playerMarkerScale = 1.4f;
    private static final float othersMarkerScale = 1.25f;
    private double playerPositionX;
    private double playerPositionY = 0.0;
    private static final ResourceLocation mapIconsTexture = Resources.MAP_ICONS.getResource();
    private final Minecraft mc = Minecraft.func_71410_x();
    private boolean finalScreen = false;
    private final Tessellator tessellator = Tessellator.func_178181_a();
    private final WorldRenderer worldrenderer = this.tessellator.func_178180_c();

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsMap) {
            return;
        }
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        ItemStack map = this.mc.field_71439_g.field_71071_by.func_70301_a(8);
        if (map == null || !(map.func_77973_b() instanceof ItemMap)) {
            return;
        }
        MapData data = ((ItemMap)map.func_77973_b()).func_77873_a(map, (World)this.mc.field_71441_e);
        if (data != null) {
            this.drawMap(data);
            this.drawBorderMap();
            this.drawMarkers(data.field_76203_h);
        }
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        String message = event.message.func_150260_c();
        if (message.contains("> EXTRA STATS <")) {
            this.finalScreen = true;
        } else if (message.equals("[NPC] Mort: Good luck.")) {
            this.finalScreen = false;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        this.finalScreen = false;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!DungeonManager.checkEssentials()) {
            return;
        }
        this.finalScreen = false;
    }

    public void drawMap(MapData data) {
        GlStateManager.func_179094_E();
        ScaledResolution sr = new ScaledResolution(this.mc);
        int mapWidth = (int)(128.0f * Config.feature.dungeons.dungeonsMapScale);
        int mapHeight = (int)(128.0f * Config.feature.dungeons.dungeonsMapScale);
        float x = Config.feature.dungeons.dungeonsMapPos.getAbsX(sr, mapWidth);
        float y = Config.feature.dungeons.dungeonsMapPos.getAbsY(sr, mapHeight);
        if (Config.feature.dungeons.dungeonsMapPos.isCenterX()) {
            x -= (float)(mapWidth / 2);
        }
        if (Config.feature.dungeons.dungeonsMapPos.isCenterY()) {
            y -= (float)(mapHeight / 2);
        }
        float x1 = x;
        float y1 = y;
        float x2 = x1 + (float)mapWidth;
        float y2 = y1 + (float)mapHeight;
        int scaleFactor = sr.func_78325_e();
        int scissorX = (int)(x1 * (float)scaleFactor);
        int scissorY = (int)(y1 * (float)scaleFactor);
        int scissorWidth = (int)((x2 - x1) * (float)scaleFactor);
        int scissorHeight = (int)((y2 - y1) * (float)scaleFactor);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorX, (int)(this.mc.field_71440_d - (scissorY + scissorHeight)), (int)scissorWidth, (int)scissorHeight);
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)Config.feature.dungeons.dungeonsMapScale, (float)Config.feature.dungeons.dungeonsMapScale, (float)Config.feature.dungeons.dungeonsMapScale);
        if (data == null) {
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            this.worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            this.worldrenderer.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            this.worldrenderer.func_181662_b(128.0, 0.0, 0.0).func_181675_d();
            this.worldrenderer.func_181662_b(128.0, 128.0, 0.0).func_181675_d();
            this.worldrenderer.func_181662_b(0.0, 128.0, 0.0).func_181675_d();
            this.tessellator.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            if (Config.feature.dungeons.dungeonsRotateMap && !this.finalScreen) {
                float angle = -MathHelper.func_76142_g((float)this.mc.field_71439_g.field_70177_z);
                GlStateManager.func_179109_b((float)64.0f, (float)64.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(angle + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-64.0f, (float)-64.0f, (float)0.0f);
                float translateX = 64.0f - (float)this.playerPositionX;
                float translateY = 64.0f - (float)this.playerPositionY;
                GlStateManager.func_179109_b((float)translateX, (float)translateY, (float)0.0f);
            }
            this.mc.field_71460_t.func_147701_i().func_148250_a(data, false);
        }
        GL11.glDisable((int)3089);
        GlStateManager.func_179121_F();
    }

    private void drawBorderMap() {
        GlStateManager.func_179094_E();
        ScaledResolution sr = new ScaledResolution(this.mc);
        int mapWidth = (int)(128.0f * Config.feature.dungeons.dungeonsMapScale);
        int mapHeight = (int)(128.0f * Config.feature.dungeons.dungeonsMapScale);
        float x = Config.feature.dungeons.dungeonsMapPos.getAbsX(sr, mapWidth);
        float y = Config.feature.dungeons.dungeonsMapPos.getAbsY(sr, mapHeight);
        if (Config.feature.dungeons.dungeonsMapPos.isCenterX()) {
            x -= (float)mapWidth / 2.0f;
        }
        if (Config.feature.dungeons.dungeonsMapPos.isCenterY()) {
            y -= (float)mapHeight / 2.0f;
        }
        GlStateManager.func_179090_x();
        String[] colorParts = Config.feature.dungeons.dungeonsMapBorderColor.split(":");
        float alpha = Float.parseFloat(colorParts[1]) / 255.0f;
        float red = Float.parseFloat(colorParts[2]) / 255.0f;
        float green = Float.parseFloat(colorParts[3]) / 255.0f;
        float blue = Float.parseFloat(colorParts[4]) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        GL11.glLineWidth((float)2.0f);
        float x1 = x;
        float y1 = y;
        float x2 = x1 + (float)mapWidth;
        float y2 = y1 + (float)mapHeight;
        this.worldrenderer.func_181668_a(2, DefaultVertexFormats.field_181705_e);
        this.worldrenderer.func_181662_b((double)x1, (double)y1, 0.0).func_181675_d();
        this.worldrenderer.func_181662_b((double)x2, (double)y1, 0.0).func_181675_d();
        this.worldrenderer.func_181662_b((double)x2, (double)y2, 0.0).func_181675_d();
        this.worldrenderer.func_181662_b((double)x1, (double)y2, 0.0).func_181675_d();
        this.tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private void drawMarkers(Map<String, Vec4b> mapDecorations) {
        ScaledResolution sr = new ScaledResolution(this.mc);
        int scaleFactor = sr.func_78325_e();
        int mapWidth = (int)(128.0f * Config.feature.dungeons.dungeonsMapScale);
        int mapHeight = (int)(128.0f * Config.feature.dungeons.dungeonsMapScale);
        float x = Config.feature.dungeons.dungeonsMapPos.getAbsX(sr, mapWidth);
        float y = Config.feature.dungeons.dungeonsMapPos.getAbsY(sr, mapHeight);
        if (Config.feature.dungeons.dungeonsMapPos.isCenterX()) {
            x -= (float)mapWidth / 2.0f;
        }
        if (Config.feature.dungeons.dungeonsMapPos.isCenterY()) {
            y -= (float)mapHeight / 2.0f;
        }
        float x1 = x;
        float y1 = y;
        float x2 = x1 + (float)mapWidth;
        float y2 = y1 + (float)mapHeight;
        int scissorX = (int)(x1 * (float)scaleFactor);
        int scissorY = (int)(y1 * (float)scaleFactor);
        int scissorWidth = (int)((x2 - x1) * (float)scaleFactor);
        int scissorHeight = (int)((y2 - y1) * (float)scaleFactor);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorX, (int)(this.mc.field_71440_d - (scissorY + scissorHeight)), (int)scissorWidth, (int)scissorHeight);
        int colorIndex = 0;
        for (Map.Entry<String, Vec4b> entry : mapDecorations.entrySet()) {
            GlStateManager.func_179094_E();
            byte iconType = entry.getValue().func_176110_a();
            if (iconType == 3) {
                iconType = 0;
            }
            double markerX = (float)entry.getValue().func_176112_b() / 2.0f + 64.0f;
            double markerY = (float)entry.getValue().func_176113_c() / 2.0f + 64.0f;
            float playerAngle = MathHelper.func_76142_g((float)this.mc.field_71439_g.field_70177_z);
            if (iconType == 1) {
                this.playerPositionX = markerX;
                this.playerPositionY = markerY;
            }
            if (!Config.feature.dungeons.dungeonsRotateMap || this.finalScreen) {
                GlStateManager.func_179137_b((double)((double)x + markerX * (double)Config.feature.dungeons.dungeonsMapScale), (double)((double)y + markerY * (double)Config.feature.dungeons.dungeonsMapScale), (double)0.0);
            } else if (iconType == 1) {
                GlStateManager.func_179137_b((double)(x + 64.0f * Config.feature.dungeons.dungeonsMapScale), (double)(y + 64.0f * Config.feature.dungeons.dungeonsMapScale), (double)0.0);
            } else if (iconType == 0) {
                float relativeX = (float)(markerX - 64.0);
                float relativeY = (float)(markerY - 64.0);
                float angleRad = (float)Math.toRadians(-playerAngle);
                float rotatedX = (float)((double)(relativeX += 64.0f - (float)this.playerPositionX) * Math.cos(angleRad) - (double)(relativeY += 64.0f - (float)this.playerPositionY) * Math.sin(angleRad));
                float rotatedY = (float)((double)relativeX * Math.sin(angleRad) + (double)relativeY * Math.cos(angleRad));
                GlStateManager.func_179137_b((double)(x + (64.0f - rotatedX) * Config.feature.dungeons.dungeonsMapScale), (double)(y + (64.0f - rotatedY) * Config.feature.dungeons.dungeonsMapScale), (double)0.0);
            }
            float angle = 180.0f;
            if ((!Config.feature.dungeons.dungeonsRotateMap || this.finalScreen) && iconType == 1) {
                angle = playerAngle;
            }
            if (iconType == 0) {
                angle = (float)(entry.getValue().func_176111_d() * 360) / 16.0f;
            }
            if (Config.feature.dungeons.dungeonsRotateMap && !this.finalScreen && iconType == 0) {
                angle = angle + 180.0f - playerAngle;
            }
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            if (iconType == 1) {
                GlStateManager.func_179152_a((float)(Config.feature.dungeons.dungeonsMapScale * 4.0f * 1.4f), (float)(Config.feature.dungeons.dungeonsMapScale * 4.0f * 1.4f), (float)4.2f);
            }
            if (iconType == 0) {
                GlStateManager.func_179152_a((float)(Config.feature.dungeons.dungeonsMapScale * 4.0f * 1.25f), (float)(Config.feature.dungeons.dungeonsMapScale * 4.0f * 1.25f), (float)3.75f);
            }
            float g = (float)(iconType % 4) / 4.0f;
            float h = (float)(iconType / 4) / 4.0f;
            float l = (float)(iconType % 4 + 1) / 4.0f;
            float m = (float)(iconType / 4 + 1) / 4.0f;
            GlStateManager.func_179109_b((float)-0.125f, (float)0.125f, (float)0.0f);
            this.mc.func_110434_K().func_110577_a(mapIconsTexture);
            if (iconType == 0) {
                switch (colorIndex) {
                    case 0: {
                        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                        break;
                    }
                    case 1: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case 2: {
                        GlStateManager.func_179131_c((float)1.0f, (float)0.5f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case 3: {
                        GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                }
                colorIndex = mapDecorations.size() > 1 ? (colorIndex + 1) % (mapDecorations.size() - 1) : 0;
            }
            this.worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float eachDecorationZOffset = -0.001f;
            this.worldrenderer.func_181662_b(-1.0, 1.0, (double)eachDecorationZOffset).func_181673_a((double)g, (double)h).func_181675_d();
            this.worldrenderer.func_181662_b(1.0, 1.0, (double)eachDecorationZOffset).func_181673_a((double)l, (double)h).func_181675_d();
            this.worldrenderer.func_181662_b(1.0, -1.0, (double)eachDecorationZOffset).func_181673_a((double)l, (double)m).func_181675_d();
            this.worldrenderer.func_181662_b(-1.0, -1.0, (double)eachDecorationZOffset).func_181673_a((double)g, (double)m).func_181675_d();
            this.tessellator.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        GL11.glDisable((int)3089);
    }
}

