/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.ScoreboardUtils;
import org.ginafro.notenoughfakepixel.variables.DungeonFloor;
import org.ginafro.notenoughfakepixel.variables.Skins;

@RegisterEvents
public class M7RelicWaypoints {
    private static final Map<RelicColor, BlockPos> relicPositions = new HashMap<RelicColor, BlockPos>();
    private static final Map<RelicColor, BlockPos> cauldronPositions = new HashMap<RelicColor, BlockPos>();
    public static boolean isFinalPhase = false;
    private final Set<RelicColor> pickedRelics = new HashSet<RelicColor>();

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (ScoreboardUtils.currentFloor != DungeonFloor.M7) {
            return;
        }
        if (!isFinalPhase) {
            return;
        }
        if (!Config.feature.dungeons.m7Relics) {
            return;
        }
        float partialTicks = event.partialTicks;
        for (RelicColor color : RelicColor.values()) {
            int rgb;
            if (!this.pickedRelics.contains((Object)color)) {
                BlockPos pos = relicPositions.get((Object)color);
                rgb = this.getColorRGB(color);
                RenderUtils.highlightBlock(pos, new Color(rgb), true, partialTicks);
                RenderUtils.renderBeaconBeam(pos, rgb, 1.0f, partialTicks);
                continue;
            }
            if (!this.hasRelicInInventory(color)) continue;
            BlockPos cauldronPos = cauldronPositions.get((Object)color);
            rgb = this.getColorRGB(color);
            RenderUtils.renderBoundingBox(cauldronPos, rgb, partialTicks);
        }
    }

    @SubscribeEvent
    public void onChatReceived(ClientChatReceivedEvent event) {
        String message = event.message.func_150260_c().toLowerCase();
        if (message.contains("picked the corrupted")) {
            for (RelicColor color : RelicColor.values()) {
                String colorStr = color.name().toLowerCase();
                if (!message.contains(colorStr + " relic!")) continue;
                this.pickedRelics.add(color);
                break;
            }
        }
        if (event.message.func_150260_c().contains("The Catacombs... are no more")) {
            isFinalPhase = true;
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        isFinalPhase = false;
        this.pickedRelics.clear();
    }

    private int getColorRGB(RelicColor color) {
        switch (color) {
            case PURPLE: {
                return 0x800080;
            }
            case GREEN: {
                return 32768;
            }
            case RED: {
                return 0xFF0000;
            }
            case ORANGE: {
                return 16753920;
            }
            case BLUE: {
                return 255;
            }
        }
        return 0xFFFFFF;
    }

    private boolean hasRelicInInventory(RelicColor color) {
        Skins skin = this.getSkinForColor(color);
        if (skin == null) {
            return false;
        }
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(i);
            if (!this.isRelicSkull(stack, skin)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelicSkull(ItemStack stack, Skins targetSkin) {
        if (stack == null || stack.func_77973_b() != Items.field_151144_bL || stack.func_77960_j() != 3) {
            return false;
        }
        String value = ItemUtils.getSkullTexture(stack);
        if (value.isEmpty()) {
            return false;
        }
        Skins skin = Skins.getSkinByValue(value);
        if (skin == null) {
            return false;
        }
        return skin.equals((Object)targetSkin);
    }

    private Skins getSkinForColor(RelicColor color) {
        switch (color) {
            case PURPLE: {
                return Skins.PURPLE_RELIC;
            }
            case GREEN: {
                return Skins.GREEN_RELIC;
            }
            case RED: {
                return Skins.RED_RELIC;
            }
            case ORANGE: {
                return Skins.ORANGE_RELIC;
            }
            case BLUE: {
                return Skins.BLUE_RELIC;
            }
        }
        return null;
    }

    static {
        relicPositions.put(RelicColor.PURPLE, new BlockPos(64, 8, 140));
        relicPositions.put(RelicColor.GREEN, new BlockPos(28, 6, 102));
        relicPositions.put(RelicColor.RED, new BlockPos(28, 6, 67));
        relicPositions.put(RelicColor.ORANGE, new BlockPos(100, 6, 64));
        relicPositions.put(RelicColor.BLUE, new BlockPos(99, 6, 102));
        cauldronPositions.put(RelicColor.PURPLE, new BlockPos(62, 7, 49));
        cauldronPositions.put(RelicColor.GREEN, new BlockPos(57, 7, 52));
        cauldronPositions.put(RelicColor.RED, new BlockPos(59, 7, 50));
        cauldronPositions.put(RelicColor.ORANGE, new BlockPos(65, 7, 50));
        cauldronPositions.put(RelicColor.BLUE, new BlockPos(67, 7, 52));
    }

    public static enum RelicColor {
        PURPLE,
        GREEN,
        RED,
        ORANGE,
        BLUE;

    }
}

