/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.RenderEntityModelEvent;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.EntityHighlightUtils;
import org.ginafro.notenoughfakepixel.utils.OutlineUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.utils.TitleUtils;

@RegisterEvents
public class MiscDungFeatures {
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent(receiveCanceled=true)
    public void onChat(ClientChatReceivedEvent event) {
        String message = StringUtils.func_76338_a((String)event.message.func_150260_c());
        if (!TablistParser.currentLocation.isDungeon()) {
            return;
        }
        if (message.startsWith("[BOSS] The Watcher: That will be enough for now.") && Config.feature.dungeons.dungeonsBloodReady) {
            TitleUtils.showTitle(EnumChatFormatting.RED + "BLOOD READY!", 2000);
            if (this.mc.field_71441_e != null) {
                SoundUtils.playSound(this.mc.field_71439_g.func_180425_c(), "note.pling", 2.0f, 1.0f);
                Minecraft.func_71410_x().field_71439_g.func_71165_d("/pc Blood Ready!");
            }
        }
        if (message.startsWith("A Spirit Bear has appeared!") && this.mc.field_71441_e != null && Config.feature.dungeons.dungeonsSpiritBow) {
            SoundUtils.playSound(this.mc.field_71439_g.func_180425_c(), "mob.enderdragon.growl", 2.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (!TablistParser.currentLocation.isDungeon()) {
            return;
        }
        for (Entity entity : world.field_72996_f) {
            EntityArmorStand armorStand;
            if (!(entity instanceof EntityArmorStand) || !(armorStand = (EntityArmorStand)entity).func_70005_c_().contains("Spirit Bow")) continue;
            if (!Config.feature.dungeons.dungeonsSpiritBow) {
                return;
            }
            RenderUtils.draw3DLine(new Vec3(entity.field_70165_t, entity.field_70163_u + 0.5, entity.field_70161_v), Minecraft.func_71410_x().field_71439_g.func_174824_e(event.partialTicks), Color.RED, 8, true, event.partialTicks);
        }
    }

    @SubscribeEvent
    public void render(RenderEntityModelEvent e) {
        String name;
        EntityLivingBase entity = e.getEntity();
        if (this.mc.field_71439_g == null || this.mc.field_71441_e == null) {
            return;
        }
        if (entity instanceof EntityWither && ((name = EnumChatFormatting.func_110646_a((String)entity.func_70005_c_())).equals("Maxor") || name.equals("Storm") || name.equals("Goldor") || name.equals("Necron"))) {
            if (!Config.feature.dungeons.dungeonsWithersBox) {
                return;
            }
            Color color = ColorUtils.getColor(Config.feature.dungeons.dungeonsWithersBoxColor);
            GlStateManager.func_179097_i();
            GlStateManager.func_179129_p();
            if (Configuration.isPojav()) {
                EntityHighlightUtils.renderEntityOutline(e, color);
            } else {
                OutlineUtils.outlineEntity(e, 4.0f, color, true);
            }
            GlStateManager.func_179126_j();
            GlStateManager.func_179089_o();
        }
    }
}

