/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ChatUtils;
import org.ginafro.notenoughfakepixel.utils.ItemUtils;
import org.ginafro.notenoughfakepixel.utils.SoundUtils;
import org.ginafro.notenoughfakepixel.utils.StringUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.ginafro.notenoughfakepixel.variables.Location;
import org.lwjgl.input.Mouse;

@RegisterEvents
public class SalvageItemsSaver {
    String legendaryPattern = "LEGENDARY";
    String mythicPattern = "MYTHIC";
    String[] starredItems = new String[]{"Wither Cloak Sword", "Jerry-chine Gun", "Bonzo's Staff", "Bonzo's Mask", "Spirit Mask", "Juju Shortbow", "Shadow Assassin", "Tarantula"};

    @SubscribeEvent
    public void onGuiRender(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (TablistParser.currentLocation != Location.DUNGEON_HUB) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsSalvageItemsPrevention) {
            return;
        }
        if (event.gui instanceof GuiChest) {
            GuiChest chest = (GuiChest)event.gui;
            Container container = chest.field_147002_h;
            if (container instanceof ContainerChest) {
                String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
                if (!title.startsWith("Salvage Item")) {
                    return;
                }
                if (container.func_75139_a(31) == null || container.func_75139_a(31).func_75211_c() == null) {
                    return;
                }
                if (Block.func_149634_a((Item)container.func_75139_a(31).func_75211_c().func_77973_b()) == Blocks.field_150461_bJ) {
                    if (ItemUtils.getLoreLine(container.func_75139_a(31).func_75211_c(), "[NEF]") != null) {
                        return;
                    }
                    ItemUtils.addLoreLine(container.func_75139_a(31).func_75211_c(), "");
                    ItemUtils.addLoreLine(container.func_75139_a(31).func_75211_c(), "[NEF] Salvage prevention enabled");
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (TablistParser.currentLocation != Location.DUNGEON_HUB) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsSalvageItemsPrevention) {
            return;
        }
        if (!Mouse.getEventButtonState()) {
            return;
        }
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest chestGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        Container container = chestGui.field_147002_h;
        if (container instanceof ContainerChest) {
            String title = ((ContainerChest)container).func_85151_d().func_145748_c_().func_150260_c();
            if (!title.equals("Salvage Item")) {
                return;
            }
            Slot slot = chestGui.getSlotUnderMouse();
            if (slot == null || slot.func_75211_c() == null || slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by) {
                return;
            }
            if (Block.func_149634_a((Item)slot.func_75211_c().func_77973_b()) == Blocks.field_150461_bJ) {
                ItemStack itemToSavage = container.func_75139_a(22).func_75211_c();
                if (itemToSavage == null) {
                    return;
                }
                String loreLegendary = ItemUtils.getLoreLine(itemToSavage, this.legendaryPattern);
                String loreMythic = ItemUtils.getLoreLine(itemToSavage, this.mythicPattern);
                int stars = ItemUtils.getExtraAttributesIntTag(container.func_75139_a(22).func_75211_c(), "stars");
                boolean starredItem = StringUtils.containsSubstring(this.starredItems, itemToSavage.func_82833_r());
                if (loreLegendary != null || loreMythic != null || stars > 0 || starredItem) {
                    event.setCanceled(true);
                    int[] cords = new int[]{Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177956_o(), Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p()};
                    SoundUtils.playSound(cords, "mob.villager.no", 2.0f, 1.0f);
                    ChatUtils.notifyChat(EnumChatFormatting.BLUE + "[NEF] " + EnumChatFormatting.RED + "Saved you from salvaging an important item (legendary+ or starred one). You can disable this feature in Dungeons QOL section.");
                }
            }
        }
    }
}

