/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class SpiritLeapHandler {
    private static final Pattern PLAYER_PATTERN = Pattern.compile("(?:\\[.+?] )?(\\w+)");
    private static final List<PlayerData> playerDataList = new ArrayList<PlayerData>();

    private static String cleanSB(String scoreboard) {
        return StringUtils.func_76338_a((String)scoreboard).chars().filter(c -> c > 20 && c < 127).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static List<String> getSidebarLines() {
        ArrayList<String> lines = new ArrayList<String>();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return lines;
        }
        Scoreboard scoreboard = mc.field_71441_e.func_96441_U();
        if (scoreboard == null) {
            return lines;
        }
        ScoreObjective objective = scoreboard.func_96539_a(1);
        if (objective == null) {
            return lines;
        }
        ArrayList scores = scoreboard.func_96534_i(objective);
        ArrayList list = scores.stream().filter(input -> input != null && input.func_96653_e() != null && !input.func_96653_e().startsWith("#")).collect(Collectors.toList());
        scores = list.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(list, (int)(scores.size() - 15))) : list;
        for (Score score : scores) {
            ScorePlayerTeam team = scoreboard.func_96509_i(score.func_96653_e());
            lines.add(ScorePlayerTeam.func_96667_a((Team)team, (String)score.func_96653_e()));
        }
        return lines;
    }

    @RegisterEvents
    public static class ChestGuiOverlayHandler {
        private static final Minecraft mc = Minecraft.func_71410_x();

        private String getClassFromLetter(String letter) {
            switch (letter) {
                case "B": {
                    return "Berserk";
                }
                case "A": {
                    return "Archer";
                }
                case "T": {
                    return "Tank";
                }
                case "H": {
                    return "Healer";
                }
                case "M": {
                    return "Mage";
                }
            }
            return "Unknown";
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
            if (event.gui instanceof GuiChest) {
                GuiChest chestGui = (GuiChest)event.gui;
                Container containerChest = chestGui.field_147002_h;
                String displayName = ((ContainerChest)containerChest).func_85151_d().func_145748_c_().func_150260_c().trim();
                if (Config.feature.dungeons.dungeonsSpiritLeapGUI && TablistParser.currentLocation.isDungeon() && "Spirit Leap".equals(displayName)) {
                    playerDataList.clear();
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onDrawScreenPre(GuiScreenEvent.DrawScreenEvent.Pre event) {
            if (event.gui instanceof GuiChest) {
                GuiChest chestGui = (GuiChest)event.gui;
                Container containerChest = chestGui.field_147002_h;
                String displayName = ((ContainerChest)containerChest).func_85151_d().func_145748_c_().func_150260_c().trim();
                if (Config.feature.dungeons.dungeonsSpiritLeapGUI && TablistParser.currentLocation.isDungeon() && "Spirit Leap".equals(displayName)) {
                    event.setCanceled(true);
                    if (playerDataList.isEmpty()) {
                        this.processSlots(chestGui);
                    }
                    this.drawCustomOverlay(event, chestGui);
                }
            }
        }

        private void processSlots(GuiChest chestGui) {
            for (Slot slot : chestGui.field_147002_h.field_75151_b) {
                Matcher colorMatcher;
                String name;
                ItemStack stack;
                if (slot.field_75224_c == ChestGuiOverlayHandler.mc.field_71439_g.field_71071_by || (stack = slot.func_75211_c()) == null || stack.func_77973_b() != Items.field_151144_bL || !stack.func_82837_s()) continue;
                String rawName = StringUtils.func_76338_a((String)stack.func_82833_r());
                Matcher matcher = PLAYER_PATTERN.matcher(rawName);
                if (!matcher.find() || (name = matcher.group(1)).equals("Unknown")) continue;
                String dungeonClass = "Unknown";
                for (String l : SpiritLeapHandler.getSidebarLines()) {
                    String line = SpiritLeapHandler.cleanSB(l);
                    if (!line.contains(name)) continue;
                    int classStart = line.indexOf(91);
                    int classEnd = line.indexOf(93);
                    if (classStart == -1 || classEnd == -1) continue;
                    String classLetter = line.substring(classStart + 1, classEnd);
                    dungeonClass = this.getClassFromLetter(classLetter);
                    break;
                }
                String colorCode = (colorMatcher = Pattern.compile("(\u00a7[0-9a-fk-or])").matcher(stack.func_82833_r())).find() ? colorMatcher.group(1) : "\u00a7f";
                playerDataList.add(new PlayerData(name, colorCode, slot.field_75222_d, dungeonClass));
            }
        }

        private void drawCustomOverlay(GuiScreenEvent.DrawScreenEvent.Pre event, GuiChest chestGui) {
            int screenWidth = event.gui.field_146294_l;
            int screenHeight = event.gui.field_146295_m;
            int boxWidth = 256;
            int boxHeight = 72;
            int padding = 32;
            int numBoxes = playerDataList.size();
            if (numBoxes == 0) {
                return;
            }
            int columns = 2;
            int rows = (int)Math.ceil((double)numBoxes / (double)columns);
            int totalWidth = columns * 256 + (columns - 1) * 32;
            int totalHeight = rows * 72 + (rows - 1) * 32;
            int startX = (screenWidth - totalWidth) / 2;
            int startY = (screenHeight - totalHeight) / 2;
            for (int i = 0; i < numBoxes; ++i) {
                PlayerData pd = (PlayerData)playerDataList.get(i);
                int column = i % columns;
                int row = i / columns;
                int x = startX + column * 288;
                int y = startY + row * 104;
                pd.boxX = x;
                pd.boxY = y;
                pd.boxWidth = 256;
                pd.boxHeight = 72;
                Gui.func_73734_a((int)x, (int)y, (int)(x + 256), (int)(y + 72), (int)Integer.MIN_VALUE);
                int borderColor = -14671840;
                Gui.func_73734_a((int)x, (int)y, (int)(x + 256), (int)(y + 1), (int)borderColor);
                Gui.func_73734_a((int)x, (int)(y + 72 - 1), (int)(x + 256), (int)(y + 72), (int)borderColor);
                Gui.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + 72), (int)borderColor);
                Gui.func_73734_a((int)(x + 256 - 1), (int)y, (int)(x + 256), (int)(y + 72), (int)borderColor);
                String name = pd.playerName;
                String className = pd.className;
                int nameWidth = ChestGuiOverlayHandler.mc.field_71466_p.func_78256_a(name);
                int classWidth = ChestGuiOverlayHandler.mc.field_71466_p.func_78256_a(className);
                int nameX = x + (256 - nameWidth * 2) / 2;
                int classX = x + (256 - classWidth) / 2;
                int nameY = y + 12;
                int classY = y + 40;
                int color = ChestGuiOverlayHandler.getColorFromString(pd.colorCode);
                GL11.glPushMatrix();
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                ChestGuiOverlayHandler.mc.field_71466_p.func_175063_a(name, (float)(nameX / 2), (float)(nameY / 2), color);
                GL11.glPopMatrix();
                ChestGuiOverlayHandler.mc.field_71466_p.func_175063_a(className, (float)classX, (float)classY, 0xAAAAAA);
            }
        }

        public static int getColorFromString(String colorCode) {
            switch (colorCode) {
                case "\u00a70": {
                    return -16777216;
                }
                case "\u00a71": {
                    return -16777046;
                }
                case "\u00a72": {
                    return -16733696;
                }
                case "\u00a73": {
                    return -16733526;
                }
                case "\u00a74": {
                    return -5636096;
                }
                case "\u00a75": {
                    return -5635926;
                }
                case "\u00a76": {
                    return -22016;
                }
                case "\u00a77": {
                    return -5592406;
                }
                case "\u00a78": {
                    return -11184811;
                }
                case "\u00a79": {
                    return -11184641;
                }
                case "\u00a7a": {
                    return -11141291;
                }
                case "\u00a7b": {
                    return -11141121;
                }
                case "\u00a7c": {
                    return -43691;
                }
                case "\u00a7d": {
                    return -43521;
                }
                case "\u00a7e": {
                    return -171;
                }
            }
            return -1;
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onMouseClick(GuiScreenEvent.MouseInputEvent.Pre event) {
            if (ChestGuiOverlayHandler.mc.field_71462_r instanceof GuiChest) {
                GuiChest chestGui = (GuiChest)ChestGuiOverlayHandler.mc.field_71462_r;
                Container containerChest = chestGui.field_147002_h;
                String displayName = ((ContainerChest)containerChest).func_85151_d().func_145748_c_().func_150260_c().trim();
                if (Config.feature.dungeons.dungeonsSpiritLeapGUI && TablistParser.currentLocation.isDungeon() && "Spirit Leap".equals(displayName)) {
                    int button = Mouse.getEventButton();
                    boolean pressed = Mouse.getEventButtonState();
                    if (button == 0 && pressed) {
                        ScaledResolution sr = new ScaledResolution(mc);
                        int mouseX = Mouse.getEventX() * sr.func_78326_a() / ChestGuiOverlayHandler.mc.field_71443_c;
                        int mouseY = sr.func_78328_b() - Mouse.getEventY() * sr.func_78328_b() / ChestGuiOverlayHandler.mc.field_71440_d - 1;
                        boolean clickedBox = false;
                        for (PlayerData pd : playerDataList) {
                            if (mouseX < pd.boxX || mouseX > pd.boxX + pd.boxWidth || mouseY < pd.boxY || mouseY > pd.boxY + pd.boxHeight) continue;
                            ChestGuiOverlayHandler.mc.field_71442_b.func_78753_a(chestGui.field_147002_h.field_75152_c, pd.slotId, 0, 0, (EntityPlayer)ChestGuiOverlayHandler.mc.field_71439_g);
                            if (Config.feature.dungeons.dungeonsLeapAnnounce) {
                                String command = String.format("/pc Leaped to %s!", pd.playerName);
                                ChestGuiOverlayHandler.mc.field_71439_g.func_71165_d(command);
                            }
                            mc.func_147108_a(null);
                            clickedBox = true;
                            break;
                        }
                        if (clickedBox) {
                            event.setCanceled(true);
                        }
                    }
                }
            }
        }
    }

    public static class PlayerData {
        public final String playerName;
        public final String colorCode;
        public final int slotId;
        public final String className;
        public int boxX;
        public int boxY;
        public int boxWidth;
        public int boxHeight;

        public PlayerData(String playerName, String colorCode, int slotId, String className) {
            this.playerName = playerName;
            this.colorCode = colorCode;
            this.slotId = slotId;
            this.className = className;
        }
    }
}

