/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class WitherDoors {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Set<BlockPos> activeDoors = new HashSet<BlockPos>();
    private final Map<String, List<BlockPos>> roomDoors = new HashMap<String, List<BlockPos>>();
    private final List<BlockPos> persistentDoors = new ArrayList<BlockPos>();
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 1000L;
    private int yLvl = -1;
    private int left = 0;
    private int right = 0;
    private int north = 0;
    private int south = 0;
    private int width = 0;
    private int height = 0;
    private String currentRoomId = "";
    private final List<BlockPos> foundCoalBlocks = new ArrayList<BlockPos>();
    private List<BlockPos> currentDoors = new ArrayList<BlockPos>();
    private ROOMSIZE size = ROOMSIZE.NONE;
    private boolean doorOpenedInEmptyRoom = false;

    private void checkYLVL() {
        EntityPlayerSP p = this.mc.field_71439_g;
        if (p == null) {
            return;
        }
        World w = p.field_70170_p;
        if (w == null) {
            return;
        }
        for (int i = 200; i > 65; --i) {
            BlockPos pos = new BlockPos(p.field_70165_t, (double)i, p.field_70161_v);
            Block b = w.func_180495_p(pos).func_177230_c();
            if (b == Blocks.field_150350_a) continue;
            this.yLvl = i;
            break;
        }
    }

    private void detectRoomBoundaries() {
        int z;
        BlockPos check;
        int x;
        if (this.yLvl == -1) {
            return;
        }
        EntityPlayerSP p = this.mc.field_71439_g;
        if (p == null || p.field_70170_p == null) {
            return;
        }
        World w = p.field_70170_p;
        BlockPos pos = new BlockPos(p.field_70165_t, (double)this.yLvl, p.field_70161_v);
        if (w.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        for (x = 0; x < 136; ++x) {
            check = new BlockPos(p.field_70165_t - (double)x, (double)this.yLvl, p.field_70161_v);
            if (w.func_180495_p(check).func_177230_c() != Blocks.field_150350_a) continue;
            this.left = check.func_177958_n();
            break;
        }
        for (x = 0; x < 136; ++x) {
            check = new BlockPos(p.field_70165_t + (double)x, (double)this.yLvl, p.field_70161_v);
            if (w.func_180495_p(check).func_177230_c() != Blocks.field_150350_a) continue;
            this.right = check.func_177958_n();
            break;
        }
        for (z = 0; z < 136; ++z) {
            check = new BlockPos(p.field_70165_t, (double)this.yLvl, p.field_70161_v - (double)z);
            if (w.func_180495_p(check).func_177230_c() != Blocks.field_150350_a) continue;
            this.north = check.func_177952_p();
            break;
        }
        for (z = 0; z < 136; ++z) {
            check = new BlockPos(p.field_70165_t, (double)this.yLvl, p.field_70161_v + (double)z);
            if (w.func_180495_p(check).func_177230_c() != Blocks.field_150350_a) continue;
            this.south = check.func_177952_p();
            break;
        }
        this.width = this.right - this.left;
        this.height = this.south - this.north;
        this.currentRoomId = this.left + ":" + this.right + ":" + this.north + ":" + this.south;
        String name = this.width / 32 + "x" + this.height / 32;
        if (this.height > this.width) {
            name = this.height / 32 + "x" + this.width / 32;
        }
        this.size = this.isLShaped(w, p) ? ROOMSIZE.L_SHAPE : ROOMSIZE.get(name);
    }

    private boolean isLShaped(World w, EntityPlayerSP sp) {
        if (this.width <= 32 && this.height <= 32) {
            return false;
        }
        if (this.width == this.height) {
            BlockPos center = new BlockPos(this.left + this.width / 2, this.yLvl, this.north + this.height / 2);
            return w.func_180495_p(center).func_177230_c() == Blocks.field_150350_a;
        }
        if (this.width > 64 || this.height > 64) {
            return false;
        }
        int centerX = this.left + this.width / 2;
        int centerZ = this.north + this.height / 2;
        if (this.width > this.height) {
            boolean closerToLeft = Math.abs(sp.field_70165_t - (double)this.left) <= Math.abs(sp.field_70165_t - (double)this.right);
            BlockPos pos = closerToLeft ? new BlockPos(this.right - 16, this.yLvl, centerZ) : new BlockPos(this.left + 16, this.yLvl, centerZ);
            ROOMSIZE rsize = this.getRoomSize(pos, w);
            return rsize == ROOMSIZE.TWO_TWO;
        }
        boolean closerToNorth = Math.abs(sp.field_70161_v - (double)this.north) <= Math.abs(sp.field_70161_v - (double)this.south);
        BlockPos pos = closerToNorth ? new BlockPos(centerX, this.yLvl, this.south - 16) : new BlockPos(centerX, this.yLvl, this.north + 16);
        ROOMSIZE rsize = this.getRoomSize(pos, w);
        return rsize == ROOMSIZE.TWO_TWO;
    }

    private ROOMSIZE getRoomSize(BlockPos pos, World w) {
        int z;
        BlockPos check;
        int x;
        int l = 0;
        int r = 0;
        int u = 0;
        int d = 0;
        for (x = 0; x < 128; ++x) {
            check = new BlockPos(pos.func_177958_n() - x, this.yLvl, pos.func_177952_p());
            if (w.func_180495_p(check).func_177230_c() != Blocks.field_150350_a) continue;
            l = check.func_177958_n();
            break;
        }
        for (x = 0; x < 128; ++x) {
            check = new BlockPos(pos.func_177958_n() + x, this.yLvl, pos.func_177952_p());
            if (w.func_180495_p(check).func_177230_c() != Blocks.field_150350_a) continue;
            r = check.func_177958_n();
            break;
        }
        for (z = 0; z < 128; ++z) {
            check = new BlockPos(pos.func_177958_n(), this.yLvl, pos.func_177952_p() - z);
            if (w.func_180495_p(check).func_177230_c() != Blocks.field_150350_a) continue;
            u = check.func_177952_p();
            break;
        }
        for (z = 0; z < 128; ++z) {
            check = new BlockPos(pos.func_177958_n(), this.yLvl, pos.func_177952_p() + z);
            if (w.func_180495_p(check).func_177230_c() != Blocks.field_150350_a) continue;
            d = check.func_177952_p();
            break;
        }
        int wi = r - l;
        int h = d - u;
        String name = wi / 32 + "x" + h / 32;
        if (h > wi) {
            name = h / 32 + "x" + wi / 32;
        }
        return ROOMSIZE.get(name);
    }

    private List<BlockPos> findWitherDoors() {
        HashSet<BlockPos> doorBases = new HashSet<BlockPos>();
        this.foundCoalBlocks.clear();
        if (this.yLvl == -1 || !TablistParser.currentLocation.isDungeon()) {
            return new ArrayList<BlockPos>();
        }
        WorldClient w = this.mc.field_71441_e;
        if (w == null) {
            return new ArrayList<BlockPos>();
        }
        for (int x = this.left + 1; x < this.right; ++x) {
            for (int z = this.north + 1; z < this.south; ++z) {
                BlockPos southBase;
                BlockPos westBase;
                BlockPos pos = new BlockPos(x, 69, z);
                IBlockState state = w.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block != Blocks.field_150402_ci && (block != Blocks.field_150406_ce || state.func_177229_b((IProperty)BlockColored.field_176581_a) != EnumDyeColor.RED)) continue;
                this.foundCoalBlocks.add(pos);
                if (this.isWitherDoorStructure((World)w, pos)) {
                    doorBases.add(pos);
                }
                if (this.isWitherDoorStructure((World)w, westBase = pos.func_177982_a(-2, 0, 0))) {
                    doorBases.add(westBase);
                }
                if (!this.isWitherDoorStructure((World)w, southBase = pos.func_177982_a(0, 0, -2))) continue;
                doorBases.add(southBase);
            }
        }
        return new ArrayList<BlockPos>(doorBases);
    }

    private boolean isWitherDoorStructure(World w, BlockPos base) {
        for (int dx = 0; dx < 3; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                for (int dz = 0; dz < 3; ++dz) {
                    BlockPos checkPos = base.func_177982_a(dx, dy, dz);
                    IBlockState state = w.func_180495_p(checkPos);
                    Block block = state.func_177230_c();
                    if (block == Blocks.field_150402_ci || block == Blocks.field_150406_ce && state.func_177229_b((IProperty)BlockColored.field_176581_a) == EnumDyeColor.RED) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!Config.feature.dungeons.dungeonsWitherDoors) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (System.currentTimeMillis() - this.lastUpdateTime > 1000L) {
            if (TablistParser.currentLocation.isDungeon()) {
                this.checkYLVL();
                this.detectRoomBoundaries();
                this.currentDoors = this.findWitherDoors();
                this.roomDoors.put(this.currentRoomId, this.currentDoors);
                for (BlockPos door : this.currentDoors) {
                    if (this.persistentDoors.contains(door)) continue;
                    this.persistentDoors.add(door);
                    if (!this.doorOpenedInEmptyRoom || this.persistentDoors.size() != 1) continue;
                    this.activeDoors.add(door);
                    this.doorOpenedInEmptyRoom = false;
                }
            }
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!Config.feature.dungeons.dungeonsWitherDoors) {
            return;
        }
        this.activeDoors.clear();
        this.roomDoors.clear();
        this.foundCoalBlocks.clear();
        this.persistentDoors.clear();
        this.doorOpenedInEmptyRoom = false;
    }

    @SubscribeEvent
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        if (!Config.feature.dungeons.dungeonsWitherDoors) {
            return;
        }
        if (!TablistParser.currentLocation.isDungeon()) {
            return;
        }
        String msg = event.message.func_150260_c();
        if (msg.startsWith("RIGHT CLICK on the WITHER DOOR to open it") || msg.startsWith("RIGHT CLICK on the BLOOD DOOR to open it")) {
            if (this.persistentDoors.isEmpty()) {
                this.doorOpenedInEmptyRoom = true;
            } else {
                this.activeDoors.addAll(this.persistentDoors);
            }
        } else if (msg.endsWith("opened a WITHER door!") || msg.endsWith("The BLOOD DOOR has been opened!")) {
            this.activeDoors.clear();
            this.persistentDoors.clear();
            this.foundCoalBlocks.clear();
            this.doorOpenedInEmptyRoom = false;
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!Config.feature.dungeons.dungeonsWitherDoors) {
            return;
        }
        if (!TablistParser.currentLocation.isDungeon()) {
            return;
        }
        if (this.persistentDoors.isEmpty()) {
            return;
        }
        double playerX = this.mc.field_71439_g.field_70169_q + (this.mc.field_71439_g.field_70165_t - this.mc.field_71439_g.field_70169_q) * (double)event.partialTicks;
        double playerY = this.mc.field_71439_g.field_70167_r + (this.mc.field_71439_g.field_70163_u - this.mc.field_71439_g.field_70167_r) * (double)event.partialTicks;
        double playerZ = this.mc.field_71439_g.field_70166_s + (this.mc.field_71439_g.field_70161_v - this.mc.field_71439_g.field_70166_s) * (double)event.partialTicks;
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GlStateManager.func_179140_f();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2929);
        GL11.glLineWidth((float)2.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (BlockPos door : this.persistentDoors) {
            boolean isActive = this.activeDoors.contains(door);
            Color color = isActive ? ColorUtils.getColor(Config.feature.dungeons.dungeonsWitherDoorsActive) : ColorUtils.getColor(Config.feature.dungeons.dungeonsWitherDoorsInactive);
            this.renderDoor(worldRenderer, door, color, playerX, playerY, playerZ);
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GlStateManager.func_179145_e();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    private void renderDoor(WorldRenderer worldRenderer, BlockPos door, Color color, double playerX, double playerY, double playerZ) {
        double minX = (double)door.func_177958_n() - playerX;
        double minY = (double)door.func_177956_o() - playerY;
        double minZ = (double)door.func_177952_p() - playerZ;
        double maxX = minX + 3.0;
        double maxY = minY + 4.0;
        double maxZ = minZ + 3.0;
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        worldRenderer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        worldRenderer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static enum ROOMSIZE {
        ONE_ONE("1x1"),
        ONE_TWO("2x1"),
        ONE_THREE("3x1"),
        ONE_FOUR("4x1"),
        TWO_TWO("2x2"),
        L_SHAPE("L"),
        NONE("");

        public final String name;

        private ROOMSIZE(String s) {
            this.name = s;
        }

        public static ROOMSIZE get(String name) {
            for (ROOMSIZE size : ROOMSIZE.values()) {
                if (!size.name.equals(name)) continue;
                return size;
            }
            return NONE;
        }
    }
}

