/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.devices;

import java.awt.Color;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockButtonStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.PacketWriteEvent;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;

@RegisterEvents
public class FirstDeviceSolver {
    private BlockPos[] positionsToSolve;
    private int[] positionsIndexSolved = new int[]{-1, -1, -1, -1, -1};
    private boolean startMemorising = false;
    private boolean resolving = false;
    private int positionInRound = 0;
    private int round = 1;

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        int i;
        if (!Config.feature.dungeons.dungeonsFirstDeviceSolver) {
            return;
        }
        if (this.startMemorising) {
            if (this.positionsToSolve == null) {
                return;
            }
            for (i = 0; i < this.positionsToSolve.length; ++i) {
                Block targetBlock = Minecraft.func_71410_x().field_71441_e.func_180495_p(this.positionsToSolve[i]).func_177230_c();
                if (targetBlock != Blocks.field_180398_cJ || this.positionsIndexSolved[this.round - 1] != -1 || this.checkIfAdded(this.positionsIndexSolved, i)) continue;
                this.positionsIndexSolved[this.round - 1] = i;
                this.resolving = true;
                this.startMemorising = false;
            }
        }
        if (this.resolving) {
            for (i = 0; i < this.round; ++i) {
                if (this.positionsIndexSolved[i] == -1) {
                    this.reset();
                    return;
                }
                Color baseColor = ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor);
                if (i == this.positionInRound) {
                    RenderUtils.highlightBlock(this.positionsToSolve[this.positionsIndexSolved[i]], ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor), false, true, event.partialTicks);
                    continue;
                }
                if (i == this.positionInRound + 1) {
                    RenderUtils.highlightBlock(this.positionsToSolve[this.positionsIndexSolved[i]], ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor), false, true, event.partialTicks);
                    continue;
                }
                if (i != this.positionInRound + 2) continue;
                RenderUtils.highlightBlock(this.positionsToSolve[this.positionsIndexSolved[i]], new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), 150), false, true, event.partialTicks);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onInteract(PlayerInteractEvent event) {
        Block buttonBlock;
        if (!Config.feature.dungeons.dungeonsFirstDeviceSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g != event.entityPlayer) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (buttonBlock = Minecraft.func_71410_x().field_71441_e.func_180495_p(event.pos).func_177230_c()) instanceof BlockButtonStone) {
            EnumFacing enumfacing = (EnumFacing)Minecraft.func_71410_x().field_71441_e.func_180495_p(event.pos).func_177229_b((IProperty)BlockButton.field_176585_a);
            Block blockClicked = Minecraft.func_71410_x().field_71441_e.func_180495_p(FirstDeviceSolver.getBlockUnderButton(event.pos, enumfacing)).func_177230_c();
            if (Objects.equals(blockClicked.func_149739_a(), Blocks.field_150343_Z.func_149739_a())) {
                if (!this.resolving) {
                    return;
                }
                if (!Objects.equals(FirstDeviceSolver.getBlockUnderButton(event.pos, enumfacing), this.positionsToSolve[this.positionsIndexSolved[this.positionInRound]])) {
                    event.setCanceled(true);
                    return;
                }
                ++this.positionInRound;
                if (this.positionInRound == this.round) {
                    this.positionInRound = 0;
                    ++this.round;
                    this.startMemorising = true;
                    this.resolving = false;
                }
                if (this.round == 6) {
                    this.reset();
                }
            } else if (Objects.equals(blockClicked.func_149739_a(), Blocks.field_150475_bE.func_149739_a())) {
                BlockPos pos = FirstDeviceSolver.getBlockUnderButton(event.pos, enumfacing);
                this.positionsToSolve = FirstDeviceSolver.getSurroundingBlocks(pos, enumfacing);
                this.reset();
                this.startMemorising = true;
            }
        }
    }

    @SubscribeEvent
    public void onDiggingPacket(PacketWriteEvent event) {
        if (!Config.feature.dungeons.dungeonsFirstDeviceSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        Packet packet = event.packet;
        if (packet instanceof C07PacketPlayerDigging) {
            C07PacketPlayerDigging packetPlayerDigging = (C07PacketPlayerDigging)packet;
            if (packetPlayerDigging.func_180762_c() != C07PacketPlayerDigging.Action.START_DESTROY_BLOCK) {
                return;
            }
            Block buttonBlock = Minecraft.func_71410_x().field_71441_e.func_180495_p(((C07PacketPlayerDigging)packet).func_179715_a()).func_177230_c();
            if (buttonBlock instanceof BlockButtonStone) {
                EnumFacing enumfacing = (EnumFacing)Minecraft.func_71410_x().field_71441_e.func_180495_p(((C07PacketPlayerDigging)packet).func_179715_a()).func_177229_b((IProperty)BlockButton.field_176585_a);
                Block blockClicked = Minecraft.func_71410_x().field_71441_e.func_180495_p(FirstDeviceSolver.getBlockUnderButton(((C07PacketPlayerDigging)packet).func_179715_a(), enumfacing)).func_177230_c();
                if (Objects.equals(blockClicked.func_149739_a(), Blocks.field_150343_Z.func_149739_a())) {
                    if (!this.resolving) {
                        return;
                    }
                    if (!Objects.equals(FirstDeviceSolver.getBlockUnderButton(((C07PacketPlayerDigging)packet).func_179715_a(), enumfacing), this.positionsToSolve[this.positionsIndexSolved[this.positionInRound]])) {
                        event.setCanceled(true);
                        return;
                    }
                    ++this.positionInRound;
                    if (this.positionInRound == this.round) {
                        this.positionInRound = 0;
                        ++this.round;
                        this.startMemorising = true;
                        this.resolving = false;
                    }
                    if (this.round == 6) {
                        this.reset();
                    }
                } else if (Objects.equals(blockClicked.func_149739_a(), Blocks.field_150475_bE.func_149739_a()) && !this.startMemorising) {
                    BlockPos pos = FirstDeviceSolver.getBlockUnderButton(((C07PacketPlayerDigging)packet).func_179715_a(), enumfacing);
                    this.positionsToSolve = FirstDeviceSolver.getSurroundingBlocks(pos, enumfacing);
                    this.reset();
                    this.startMemorising = true;
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (Config.feature.dungeons.dungeonsFirstDeviceSolver) {
            this.reset();
        }
    }

    private static BlockPos getBlockUnderButton(BlockPos pos, EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
            }
            case EAST: {
                return new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            }
            case SOUTH: {
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
            }
            case WEST: {
                return new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return null;
    }

    public static BlockPos[] getSurroundingBlocks(BlockPos startPos, EnumFacing enumFacing) {
        BlockPos[] surroundingBlocks = new BlockPos[16];
        int index = 0;
        for (int yOffset = -1; yOffset <= 2; ++yOffset) {
            for (int hOffset = 1; hOffset <= 4; ++hOffset) {
                int dx = 0;
                int dz = 0;
                int dy = yOffset;
                switch (enumFacing) {
                    case NORTH: {
                        dx = -hOffset;
                        break;
                    }
                    case SOUTH: {
                        dx = hOffset;
                        break;
                    }
                    case WEST: {
                        dz = hOffset;
                        break;
                    }
                    case EAST: {
                        dz = -hOffset;
                    }
                }
                surroundingBlocks[index++] = new BlockPos(startPos.func_177958_n() + dx, startPos.func_177956_o() + dy, startPos.func_177952_p() + dz);
            }
        }
        return surroundingBlocks;
    }

    private boolean checkIfAdded(int[] array, int index) {
        for (int j : array) {
            if (j != index) continue;
            return true;
        }
        return false;
    }

    private void reset() {
        this.positionsIndexSolved = new int[]{-1, -1, -1, -1, -1};
        this.startMemorising = false;
        this.resolving = false;
        this.positionInRound = 0;
        this.round = 1;
    }
}

