/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.devices;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockSeaLantern;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.C02PacketUseEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.PacketWriteEvent;
import org.ginafro.notenoughfakepixel.features.skyblock.dungeons.DungeonManager;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;

@RegisterEvents
public class ThirdDeviceSolver {
    private final Minecraft mc = Minecraft.func_71410_x();
    private static final Map<BlockPos, Integer> itemFramesRotations = new HashMap<BlockPos, Integer>();
    private static final Map<BlockPos, Integer> clientRemainingClicks = new HashMap<BlockPos, Integer>();
    private static final Set<String> processedPackets = new HashSet<String>();
    private long lastResyncTime = 0L;
    private int tickCounter = 0;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPacket(PacketWriteEvent event) {
        BlockPos posItemFrame;
        EntityItemFrame itemFrame;
        ItemStack item;
        C02PacketUseEntity packet;
        Entity entityHit;
        if (!Config.feature.dungeons.dungeonsThirdDeviceSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        if (event.packet instanceof C02PacketUseEntity && (entityHit = (packet = (C02PacketUseEntity)event.packet).func_149564_a((World)this.mc.field_71441_e)) instanceof EntityItemFrame && (item = (itemFrame = (EntityItemFrame)entityHit).func_82335_i()) != null && item.func_77973_b() == Items.field_151032_g && itemFramesRotations.containsKey(posItemFrame = new BlockPos((Vec3i)entityHit.func_180425_c()))) {
            int currentRotation;
            String packetId = posItemFrame + ":" + this.tickCounter;
            if (processedPackets.contains(packetId)) {
                event.setCanceled(true);
                return;
            }
            int desiredRotation = itemFramesRotations.get(posItemFrame);
            int remaining = clientRemainingClicks.getOrDefault(posItemFrame, (desiredRotation - (currentRotation = itemFrame.func_82333_j()) + 8) % 8);
            if (remaining <= 0) {
                event.setCanceled(true);
                return;
            }
            processedPackets.add(packetId);
            clientRemainingClicks.put(posItemFrame, remaining - 1);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!Config.feature.dungeons.dungeonsThirdDeviceSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        ++this.tickCounter;
        processedPackets.clear();
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastResyncTime >= 5000L) {
            this.resyncClientRemainingClicks();
            this.lastResyncTime = currentTime;
        }
    }

    private void resyncClientRemainingClicks() {
        for (Entity entity : this.mc.field_71441_e.field_72996_f) {
            if (!(entity instanceof EntityItemFrame)) continue;
            EntityItemFrame itemFrame = (EntityItemFrame)entity;
            BlockPos posItemFrame = new BlockPos((Vec3i)entity.func_180425_c());
            if (!itemFramesRotations.containsKey(posItemFrame)) continue;
            int desiredRotation = itemFramesRotations.get(posItemFrame);
            int currentRotation = itemFrame.func_82333_j();
            int clicksNeeded = (desiredRotation - currentRotation + 8) % 8;
            clientRemainingClicks.put(posItemFrame, clicksNeeded);
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (!Config.feature.dungeons.dungeonsThirdDeviceSolver) {
            return;
        }
        if (!DungeonManager.checkEssentialsF7()) {
            return;
        }
        this.mc.field_71441_e.field_72996_f.forEach(entity -> {
            if (entity instanceof EntityItemFrame) {
                EntityItemFrame itemFrame = (EntityItemFrame)entity;
                ItemStack item = itemFrame.func_82335_i();
                if (item == null || item.func_77973_b() != Items.field_151032_g) {
                    return;
                }
                BlockPos pos = ThirdDeviceSolver.getBlockUnderItemFrame(itemFrame);
                if (pos == null) {
                    return;
                }
                Color color = this.mc.field_71441_e.func_180495_p(pos).func_177230_c() instanceof BlockSeaLantern ? ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor) : ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor);
                RenderUtils.highlightBlock(pos, color, false, event.partialTicks);
                BlockPos posItemFrame = new BlockPos((Vec3i)entity.func_180425_c());
                if (itemFramesRotations.containsKey(posItemFrame)) {
                    int desiredRotation = itemFramesRotations.get(posItemFrame);
                    int currentRotation = itemFrame.func_82333_j();
                    int clicksNeeded = clientRemainingClicks.getOrDefault(posItemFrame, (desiredRotation - currentRotation + 8) % 8);
                    double[] renderPos = new double[]{(double)posItemFrame.func_177958_n() - 0.7, (double)posItemFrame.func_177956_o() - 3.3, posItemFrame.func_177952_p()};
                    Color textColor = clicksNeeded == 0 ? ColorUtils.getColor(Config.feature.dungeons.dungeonsCorrectColor) : ColorUtils.getColor(Config.feature.dungeons.dungeonsAlternativeColor);
                    RenderUtils.drawTag(String.valueOf(clicksNeeded), renderPos, textColor, event.partialTicks);
                }
            }
        });
    }

    private static BlockPos getBlockUnderItemFrame(EntityItemFrame itemFrame) {
        switch (itemFrame.field_174860_b) {
            case NORTH: {
                return new BlockPos(itemFrame.field_70165_t, itemFrame.field_70163_u, itemFrame.field_70161_v + 1.0);
            }
            case EAST: {
                return new BlockPos(itemFrame.field_70165_t - 1.0, itemFrame.field_70163_u, itemFrame.field_70161_v);
            }
            case SOUTH: {
                return new BlockPos(itemFrame.field_70165_t, itemFrame.field_70163_u, itemFrame.field_70161_v - 1.0);
            }
            case WEST: {
                return new BlockPos(itemFrame.field_70165_t + 1.0, itemFrame.field_70163_u, itemFrame.field_70161_v);
            }
        }
        return null;
    }

    static {
        itemFramesRotations.put(new BlockPos(6, 122, 85), 3);
        itemFramesRotations.put(new BlockPos(6, 121, 85), 1);
        itemFramesRotations.put(new BlockPos(6, 121, 84), 1);
        itemFramesRotations.put(new BlockPos(6, 121, 83), 7);
        itemFramesRotations.put(new BlockPos(6, 122, 83), 7);
        itemFramesRotations.put(new BlockPos(6, 123, 83), 7);
        itemFramesRotations.put(new BlockPos(6, 124, 83), 7);
        itemFramesRotations.put(new BlockPos(6, 125, 83), 5);
        itemFramesRotations.put(new BlockPos(6, 125, 84), 5);
        itemFramesRotations.put(new BlockPos(6, 125, 85), 5);
        itemFramesRotations.put(new BlockPos(6, 125, 86), 5);
        itemFramesRotations.put(new BlockPos(6, 125, 87), 3);
        itemFramesRotations.put(new BlockPos(6, 124, 87), 3);
        itemFramesRotations.put(new BlockPos(6, 123, 87), 3);
        itemFramesRotations.put(new BlockPos(6, 122, 87), 3);
    }
}

