/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.mobs;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.RenderEntityModelEvent;
import org.ginafro.notenoughfakepixel.utils.EntityHighlightUtils;
import org.ginafro.notenoughfakepixel.utils.OutlineUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class LividDisplay {
    static BlockPos pos = new BlockPos(45, 108, 52);
    static Entity livid = null;
    public static int LIVID_COLOUR;
    private static final Map<String, EnumChatFormatting> lividColors;
    private long lastUpdateTime = 0L;
    public final Set<EntityLivingBase> lividEntity = new HashSet<EntityLivingBase>();

    private static void initializeColors() {
        lividColors.put("Vendetta", EnumChatFormatting.WHITE);
        lividColors.put("Crossed", EnumChatFormatting.LIGHT_PURPLE);
        lividColors.put("Hockey", EnumChatFormatting.RED);
        lividColors.put("Doctor", EnumChatFormatting.GRAY);
        lividColors.put("Frog", EnumChatFormatting.DARK_GREEN);
        lividColors.put("Smile", EnumChatFormatting.GREEN);
        lividColors.put("Scream", EnumChatFormatting.BLUE);
        lividColors.put("Purple", EnumChatFormatting.DARK_PURPLE);
        lividColors.put("Arcade", EnumChatFormatting.YELLOW);
    }

    @SubscribeEvent
    public void onWorldChange(WorldEvent.Load event) {
        livid = null;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.func_82737_E() % 20L != 0L) {
            return;
        }
        if (TablistParser.currentLocation.isDungeon()) {
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            if (world == null) {
                return;
            }
            if (!Config.feature.dungeons.dungeonsLividFinder) {
                return;
            }
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150325_L) {
                int woolColor = world.func_180495_p(pos).func_177230_c().func_176222_j((World)world, pos);
                List entities = world.func_72910_y();
                for (Entity entity : entities) {
                    if (!(entity instanceof EntityArmorStand) || !entity.func_145818_k_()) continue;
                    String name = entity.func_95999_t();
                    for (Map.Entry<String, EnumChatFormatting> entry : lividColors.entrySet()) {
                        int expectedColor;
                        if (!name.contains(entry.getKey()) || woolColor != (expectedColor = LividDisplay.getWoolColorFromChatColor(entry.getValue()))) continue;
                        livid = entity;
                        EnumChatFormatting chatColor = entry.getValue();
                        Color color = LividDisplay.getColorFromEnumChatFormatting(chatColor);
                        LIVID_COLOUR = color.getRGB();
                        return;
                    }
                }
                livid = null;
            }
        }
    }

    @SubscribeEvent
    public void onRenderEntity(RenderLivingEvent.Pre<EntityLivingBase> event) {
        EntityLivingBase entity;
        if (!Config.feature.dungeons.dungeonsLividFinder || livid == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 20L) {
            this.lividEntity.clear();
            this.lastUpdateTime = currentTime;
        }
        if ((entity = event.entity) instanceof EntityArmorStand && entity.func_145818_k_()) {
            String name = entity.func_95999_t();
            if (!entity.func_70028_i(livid) && name.contains("Livid")) {
                event.setCanceled(true);
            }
        }
        if (Config.feature.dungeons.dungeonsLividFinderRender == 0) {
            return;
        }
        if (entity instanceof EntityArmorStand) {
            EntityLivingBase mob;
            EntityArmorStand armorStand = (EntityArmorStand)entity;
            if (entity.func_82150_aj()) {
                return;
            }
            if (entity.func_70028_i(livid) && (mob = this.findAssociatedMob(armorStand)) != null) {
                this.lividEntity.add(mob);
            }
        }
    }

    private EntityLivingBase findAssociatedMob(EntityArmorStand armorStand) {
        return armorStand.field_70170_p.func_175647_a(EntityLivingBase.class, armorStand.func_174813_aQ().func_72314_b(0.5, 3.0, 0.5), e -> e != null && !(e instanceof EntityArmorStand) && e != Minecraft.func_71410_x().field_71439_g).stream().findFirst().orElse(null);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderEntityModel(RenderEntityModelEvent event) {
        if (Config.feature.dungeons.dungeonsLividFinder && livid != null) {
            if (Config.feature.dungeons.dungeonsLividFinderRender == 0) {
                return;
            }
            EntityLivingBase entity = event.getEntity();
            if (!this.lividEntity.contains(entity)) {
                return;
            }
            if (Configuration.isPojav()) {
                EntityHighlightUtils.renderEntityOutline(event, new Color(LIVID_COLOUR));
            } else {
                OutlineUtils.outlineEntity(event, 5.0f, new Color(LIVID_COLOUR), true);
            }
        }
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (Config.feature.dungeons.dungeonsLividFinder && livid != null) {
            if (Config.feature.dungeons.dungeonsLividFinderRender == 0) {
                AxisAlignedBB aabb = new AxisAlignedBB(LividDisplay.livid.field_70165_t - 0.5, LividDisplay.livid.field_70163_u - 2.0, LividDisplay.livid.field_70161_v - 0.5, LividDisplay.livid.field_70165_t + 0.5, LividDisplay.livid.field_70163_u, LividDisplay.livid.field_70161_v + 0.5);
                LividDisplay.draw3DBox(aabb, LIVID_COLOUR, event.partialTicks);
            }
            RenderUtils.draw3DLine(new Vec3(LividDisplay.livid.field_70165_t, LividDisplay.livid.field_70163_u, LividDisplay.livid.field_70161_v), Minecraft.func_71410_x().field_71439_g.func_174824_e(event.partialTicks), new Color(LIVID_COLOUR), 8, true, event.partialTicks);
        }
    }

    public static void draw3DBox(AxisAlignedBB aabb, int colourInt, float partialTicks) {
        Entity render = Minecraft.func_71410_x().func_175606_aa();
        Color colour = new Color(colourInt);
        double realX = render.field_70142_S + (render.field_70165_t - render.field_70142_S) * (double)partialTicks;
        double realY = render.field_70137_T + (render.field_70163_u - render.field_70137_T) * (double)partialTicks;
        double realZ = render.field_70136_U + (render.field_70161_v - render.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-realX), (double)(-realY), (double)(-realZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glLineWidth((float)2.0f);
        RenderGlobal.func_181563_a((AxisAlignedBB)aabb, (int)colour.getRed(), (int)colour.getGreen(), (int)colour.getBlue(), (int)colour.getAlpha());
        GlStateManager.func_179137_b((double)realX, (double)realY, (double)realZ);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static int getWoolColorFromChatColor(EnumChatFormatting color) {
        switch (color) {
            case WHITE: {
                return 0;
            }
            case LIGHT_PURPLE: {
                return 6;
            }
            case YELLOW: {
                return 4;
            }
            case GREEN: {
                return 5;
            }
            case GRAY: {
                return 8;
            }
            case DARK_PURPLE: {
                return 10;
            }
            case BLUE: {
                return 11;
            }
            case DARK_GREEN: {
                return 13;
            }
            case RED: {
                return 14;
            }
        }
        return -1;
    }

    private static Color getColorFromEnumChatFormatting(EnumChatFormatting formatting) {
        switch (formatting) {
            case WHITE: {
                return new Color(0xFFFFFF);
            }
            case DARK_PURPLE: {
                return new Color(0xAA00AA);
            }
            case RED: {
                return new Color(0xFF5555);
            }
            case GRAY: {
                return new Color(0xAAAAAA);
            }
            case DARK_GREEN: {
                return new Color(43520);
            }
            case GREEN: {
                return new Color(0x55FF55);
            }
            case BLUE: {
                return new Color(0x5555FF);
            }
            case LIGHT_PURPLE: {
                return new Color(0xFF55FF);
            }
            case YELLOW: {
                return new Color(0xFFFF55);
            }
        }
        return Color.WHITE;
    }

    public Set<EntityLivingBase> getLividEntity() {
        return this.lividEntity;
    }

    static {
        lividColors = new HashMap<String, EnumChatFormatting>();
        LividDisplay.initializeColors();
    }
}

