/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.mobs;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.ginafro.notenoughfakepixel.Configuration;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.events.RenderEntityModelEvent;
import org.ginafro.notenoughfakepixel.utils.ColorUtils;
import org.ginafro.notenoughfakepixel.utils.EntityHighlightUtils;
import org.ginafro.notenoughfakepixel.utils.OutlineUtils;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.variables.MobDisplayTypes;

@RegisterEvents
public class StarredMobDisplay {
    private static final Pattern PATTERN1 = Pattern.compile("^\u00a7.\\[\u00a7.Lv\\d+\u00a7.\\] \u00a7.+ (?:\u00a7.)+0\u00a7f/.+\u00a7c\u2764$");
    private static final Pattern PATTERN2 = Pattern.compile("^.+ (?:\u00a7.)+0\u00a7c\u2764$");
    private static final Pattern PATTERN_RUNIC = Pattern.compile("^\u00a7.\\[\u00a7.Runic\u00a7.\\] \u00a7.+ (?:\u00a7.)+0\u00a7f/.+\u00a7c\u2764$");
    private long lastUpdateTime = 0L;
    private final Set<EntityLivingBase> currentEntities = new HashSet<EntityLivingBase>();
    MobDisplayTypes mobDisplayType = MobDisplayTypes.NONE;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderEntityModel(RenderEntityModelEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (Config.feature.dungeons.dungeonsStarredMobs == 2) {
            return;
        }
        if (Config.feature.dungeons.dungeonsStarredMobs == 1) {
            EntityLivingBase entity = event.getEntity();
            if (!this.currentEntities.contains(entity)) {
                return;
            }
            if (this.isDying(entity)) {
                return;
            }
            if (entity.func_82150_aj()) {
                return;
            }
            Color color = new Color(ColorUtils.getColor(Config.feature.dungeons.dungeonsStarredBoxColor).getRGB());
            boolean canSee = Minecraft.func_71410_x().field_71439_g.func_70685_l((Entity)entity);
            if (!Config.feature.dungeons.dungeonsStarredMobsEsp && !canSee) {
                return;
            }
            if (Configuration.isPojav()) {
                EntityHighlightUtils.renderEntityOutline(event, color);
            } else {
                OutlineUtils.outlineEntity(event, 5.0f, color, true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre<EntityLivingBase> event) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 20L) {
            this.clearCache();
            this.lastUpdateTime = currentTime;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (Entity entity : world.field_72996_f) {
            EntityLivingBase mob;
            EntityArmorStand armorStand;
            if (!(entity instanceof EntityArmorStand) || !(armorStand = (EntityArmorStand)entity).func_70005_c_().contains("\u272e") || (mob = this.findAssociatedMob(armorStand)) == null || this.isDying(mob)) continue;
            this.currentEntities.add(mob);
        }
    }

    private EntityLivingBase findAssociatedMob(EntityArmorStand armorStand) {
        return armorStand.field_70170_p.func_175647_a(EntityLivingBase.class, armorStand.func_174813_aQ().func_72314_b(0.5, 3.0, 0.5), e -> e != null && !(e instanceof EntityArmorStand) && e != Minecraft.func_71410_x().field_71439_g).stream().findFirst().orElse(null);
    }

    private boolean isDying(EntityLivingBase entity) {
        if (entity == null || entity.field_70128_L) {
            return true;
        }
        if (entity.func_110143_aJ() <= 0.1f) {
            return true;
        }
        IChatComponent displayName = entity.func_145748_c_();
        if (displayName == null) {
            return false;
        }
        String name = displayName.func_150260_c();
        return PATTERN1.matcher(name).matches() || PATTERN2.matcher(name).matches() || PATTERN_RUNIC.matcher(name).matches();
    }

    public void clearCache() {
        this.currentEntities.clear();
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (Config.feature.dungeons.dungeonsStarredMobs == 2) {
            return;
        }
        if (Config.feature.dungeons.dungeonsStarredMobs == 0) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            world.field_72996_f.forEach(entity -> {
                if (entity == null || entity.func_70005_c_() == null || !(entity instanceof EntityArmorStand)) {
                    return;
                }
                if (!entity.func_70005_c_().contains("\u272e")) {
                    return;
                }
                if (this.isDying((EntityLivingBase)entity)) {
                    return;
                }
                Color color = new Color(ColorUtils.getColor(Config.feature.dungeons.dungeonsStarredBoxColor).getRGB());
                if (entity.func_70005_c_().contains("Stormy")) {
                    color = new Color(ColorUtils.getColor(Config.feature.dungeons.dungeonsStormyColor).getRGB());
                } else if (entity.func_70005_c_().contains("Withermancer")) {
                    color = new Color(ColorUtils.getColor(Config.feature.dungeons.dungeonsWithermancerColor).getRGB());
                    this.mobDisplayType = MobDisplayTypes.WITHERMANCER;
                } else if (entity.func_70005_c_().contains("Zombie Commander")) {
                    color = new Color(ColorUtils.getColor(Config.feature.dungeons.dungeonsZombieCommanderColor).getRGB());
                } else if (entity.func_70005_c_().contains("Skeleton Master")) {
                    color = new Color(ColorUtils.getColor(Config.feature.dungeons.dungeonsSkeletonMasterColor).getRGB());
                } else if (entity.func_70005_c_().contains("Fels")) {
                    this.mobDisplayType = MobDisplayTypes.FELALIVE;
                }
                if (Config.feature.dungeons.dungeonsStarredMobsEsp) {
                    GlStateManager.func_179097_i();
                }
                RenderUtils.renderEntityHitbox(entity, event.partialTicks, color, this.mobDisplayType);
                if (Config.feature.dungeons.dungeonsStarredMobsEsp) {
                    GlStateManager.func_179126_j();
                }
                this.mobDisplayType = MobDisplayTypes.NONE;
            });
        }
    }

    public Set<EntityLivingBase> getCurrentEntities() {
        return this.currentEntities;
    }
}

