/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.puzzles;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.RenderUtils;
import org.ginafro.notenoughfakepixel.utils.TablistParser;

@RegisterEvents
public class BoulderSolver {
    public static BlockPos boulderChest = null;
    public static EnumFacing boulderFacing = null;
    public static BoulderState[][] grid = new BoulderState[7][6];
    public static int roomVariant = -1;
    public static ArrayList<ArrayList<BoulderPush>> variantSteps = new ArrayList();
    public static ArrayList<ArrayList<BoulderState>> expectedBoulders = new ArrayList();
    private static int ticks = 0;
    private static final Minecraft mc = Minecraft.func_71410_x();

    public BoulderSolver() {
        expectedBoulders.add(Lists.newArrayList((Object[])new BoulderState[]{BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY}));
        variantSteps.add(Lists.newArrayList((Object[])new BoulderPush[]{new BoulderPush(2, 4, Direction.RIGHT), new BoulderPush(2, 3, Direction.FORWARD), new BoulderPush(3, 3, Direction.RIGHT), new BoulderPush(4, 3, Direction.RIGHT), new BoulderPush(4, 1, Direction.FORWARD), new BoulderPush(5, 1, Direction.RIGHT)}));
        expectedBoulders.add(Lists.newArrayList((Object[])new BoulderState[]{BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED}));
        variantSteps.add(Lists.newArrayList((Object[])new BoulderPush[]{new BoulderPush(3, 4, Direction.FORWARD), new BoulderPush(2, 4, Direction.LEFT), new BoulderPush(3, 3, Direction.RIGHT), new BoulderPush(3, 2, Direction.FORWARD), new BoulderPush(2, 2, Direction.LEFT), new BoulderPush(4, 2, Direction.RIGHT), new BoulderPush(2, 1, Direction.FORWARD), new BoulderPush(4, 1, Direction.FORWARD), new BoulderPush(3, 1, Direction.RIGHT)}));
        expectedBoulders.add(Lists.newArrayList((Object[])new BoulderState[]{BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED}));
        variantSteps.add(Lists.newArrayList((Object[])new BoulderPush[]{new BoulderPush(1, 1, Direction.RIGHT)}));
        expectedBoulders.add(Lists.newArrayList((Object[])new BoulderState[]{BoulderState.FILLED, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.FILLED}));
        variantSteps.add(Lists.newArrayList((Object[])new BoulderPush[]{new BoulderPush(4, 3, Direction.FORWARD), new BoulderPush(3, 3, Direction.LEFT), new BoulderPush(3, 1, Direction.FORWARD), new BoulderPush(2, 1, Direction.LEFT)}));
        expectedBoulders.add(Lists.newArrayList((Object[])new BoulderState[]{BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED}));
        variantSteps.add(Lists.newArrayList((Object[])new BoulderPush[]{new BoulderPush(3, 4, Direction.FORWARD), new BoulderPush(3, 3, Direction.FORWARD), new BoulderPush(2, 1, Direction.FORWARD), new BoulderPush(1, 1, Direction.LEFT)}));
        expectedBoulders.add(Lists.newArrayList((Object[])new BoulderState[]{BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY}));
        variantSteps.add(Lists.newArrayList((Object[])new BoulderPush[]{new BoulderPush(1, 4, Direction.FORWARD), new BoulderPush(1, 1, Direction.RIGHT)}));
        expectedBoulders.add(Lists.newArrayList((Object[])new BoulderState[]{BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.FILLED, BoulderState.FILLED, BoulderState.FILLED, BoulderState.FILLED, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED}));
        variantSteps.add(Lists.newArrayList((Object[])new BoulderPush[]{new BoulderPush(6, 4, Direction.FORWARD), new BoulderPush(6, 3, Direction.FORWARD), new BoulderPush(4, 1, Direction.FORWARD), new BoulderPush(5, 1, Direction.RIGHT)}));
        expectedBoulders.add(Lists.newArrayList((Object[])new BoulderState[]{BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED}));
        variantSteps.add(Lists.newArrayList((Object[])new BoulderPush[]{new BoulderPush(0, 1, Direction.FORWARD)}));
        ArrayList newVariantInitial = Lists.newArrayList((Object[])new BoulderState[]{BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.FILLED, BoulderState.FILLED, BoulderState.FILLED, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY, BoulderState.FILLED, BoulderState.EMPTY});
        expectedBoulders.add(newVariantInitial);
        ArrayList newVariantSteps = Lists.newArrayList((Object[])new BoulderPush[]{new BoulderPush(1, 5, Direction.RIGHT), new BoulderPush(2, 1, Direction.RIGHT)});
        variantSteps.add(newVariantSteps);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (++ticks % 20 == 0) {
            ticks = 0;
            BoulderSolver.update();
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent event) {
        if (!Config.feature.dungeons.dungeonsBoulderSolver) {
            return;
        }
        if (boulderChest == null) {
            return;
        }
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)event.partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)event.partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)event.partialTicks;
        if (roomVariant >= 0) {
            ArrayList<BoulderPush> steps = variantSteps.get(roomVariant);
            for (BoulderPush step : steps) {
                if (grid[step.x][step.y] == BoulderState.EMPTY) continue;
                EnumFacing downRow = boulderFacing.func_176734_d();
                EnumFacing rightColumn = boulderFacing.func_176746_e();
                BlockPos farLeftPos = boulderChest.func_177967_a(downRow, 5).func_177967_a(rightColumn.func_176734_d(), 9);
                BlockPos boulderPos = farLeftPos.func_177967_a(rightColumn, 3 * step.x).func_177967_a(downRow, 3 * step.y);
                EnumFacing actualDirection = null;
                switch (step.direction) {
                    case FORWARD: {
                        actualDirection = boulderFacing;
                        break;
                    }
                    case BACKWARD: {
                        actualDirection = boulderFacing.func_176734_d();
                        break;
                    }
                    case LEFT: {
                        actualDirection = boulderFacing.func_176735_f();
                        break;
                    }
                    case RIGHT: {
                        actualDirection = boulderFacing.func_176746_e();
                    }
                }
                BlockPos buttonPos = boulderPos.func_177967_a(actualDirection.func_176734_d(), 2).func_177977_b();
                double x = (double)buttonPos.func_177958_n() - viewerX;
                double y = (double)buttonPos.func_177956_o() - viewerY;
                double z = (double)buttonPos.func_177952_p() - viewerZ;
                GlStateManager.func_179129_p();
                GlStateManager.func_179097_i();
                GlStateManager.func_179140_f();
                RenderUtils.drawFilledBoundingBox(new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0), new Color(255, 0, 0), 0.6f);
                GlStateManager.func_179089_o();
                GlStateManager.func_179098_w();
                GlStateManager.func_179126_j();
                GlStateManager.func_179084_k();
                break;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.pos == boulderChest) {
            BoulderSolver.reset();
        }
    }

    @SubscribeEvent
    public void onWorldChange(WorldEvent.Load event) {
        BoulderSolver.reset();
    }

    public static void update() {
        if (!Config.feature.dungeons.dungeonsBoulderSolver) {
            return;
        }
        EntityPlayerSP player = BoulderSolver.mc.field_71439_g;
        WorldClient world = BoulderSolver.mc.field_71441_e;
        if (TablistParser.currentLocation.isDungeon() && world != null && player != null) {
            new Thread(() -> BoulderSolver.lambda$update$0(player, (World)world)).start();
        }
    }

    public static void reset() {
        boulderChest = null;
        boulderFacing = null;
        grid = new BoulderState[7][6];
        roomVariant = -1;
    }

    private static /* synthetic */ void lambda$update$0(EntityPlayerSP player, World world) {
        int quartzBlocksFound = 0;
        int barriersFound = 0;
        BlockPos plusPlusQuartz = null;
        BlockPos minusMinusQuartz = null;
        Iterable blocks = BlockPos.func_177980_a((BlockPos)new BlockPos(player.field_70165_t - 25.0, 68.0, player.field_70161_v - 25.0), (BlockPos)new BlockPos(player.field_70165_t + 25.0, 68.0, player.field_70161_v + 25.0));
        for (BlockPos blockPos : blocks) {
            if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150371_ca) {
                ++quartzBlocksFound;
                if (plusPlusQuartz == null || blockPos.func_177958_n() >= plusPlusQuartz.func_177958_n() && blockPos.func_177952_p() >= plusPlusQuartz.func_177952_p()) {
                    plusPlusQuartz = blockPos;
                }
                if (minusMinusQuartz == null || blockPos.func_177958_n() <= minusMinusQuartz.func_177958_n() && blockPos.func_177952_p() <= minusMinusQuartz.func_177952_p()) {
                    minusMinusQuartz = blockPos;
                }
                if (quartzBlocksFound != 8) continue;
                break;
            }
            if (world.func_180495_p(blockPos).func_177230_c() != Blocks.field_180401_cv) continue;
            ++barriersFound;
        }
        if (quartzBlocksFound == 8 && barriersFound >= 10) {
            if (boulderChest == null || boulderFacing == null) {
                BlockPos northChest = minusMinusQuartz.func_177982_a(11, 1, 0);
                BlockPos eastChest = plusPlusQuartz.func_177982_a(0, 1, -11);
                BlockPos southChest = plusPlusQuartz.func_177982_a(-11, 1, 0);
                BlockPos westChest = minusMinusQuartz.func_177982_a(0, 1, 11);
                if (world.func_180495_p(northChest).func_177230_c() == Blocks.field_150364_r) {
                    boulderFacing = EnumFacing.NORTH;
                    boulderChest = northChest.func_177982_a(0, -3, -2);
                } else if (world.func_180495_p(eastChest).func_177230_c() == Blocks.field_150364_r) {
                    boulderFacing = EnumFacing.EAST;
                    boulderChest = eastChest.func_177982_a(2, -3, 0);
                } else if (world.func_180495_p(southChest).func_177230_c() == Blocks.field_150364_r) {
                    boulderFacing = EnumFacing.SOUTH;
                    boulderChest = southChest.func_177982_a(0, -3, 2);
                } else if (world.func_180495_p(westChest).func_177230_c() == Blocks.field_150364_r) {
                    boulderFacing = EnumFacing.WEST;
                    boulderChest = westChest.func_177982_a(-2, -3, 0);
                } else {
                    BoulderSolver.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Could not determine orientation of boulder room."));
                    return;
                }
                System.out.println("Boulder chest is at " + boulderChest);
                System.out.println("Boulder room is facing " + boulderFacing);
            }
            EnumFacing downRow = boulderFacing.func_176734_d();
            EnumFacing rightColumn = boulderFacing.func_176746_e();
            BlockPos farLeftPos = boulderChest.func_177967_a(downRow, 5).func_177967_a(rightColumn.func_176734_d(), 9);
            for (int row = 0; row < 6; ++row) {
                for (int column = 0; column < 7; ++column) {
                    BlockPos current = farLeftPos.func_177967_a(rightColumn, 3 * column).func_177967_a(downRow, 3 * row);
                    IBlockState state = world.func_180495_p(current);
                    BoulderSolver.grid[column][row] = state.func_177230_c() == Blocks.field_150350_a ? BoulderState.EMPTY : BoulderState.FILLED;
                }
            }
            if (roomVariant == -1) {
                roomVariant = -2;
                for (int i = 0; i < expectedBoulders.size(); ++i) {
                    ArrayList<BoulderState> expected = expectedBoulders.get(i);
                    boolean isRight = true;
                    for (int j = 0; j < expected.size(); ++j) {
                        BoulderState state;
                        int column = j % 7;
                        int row = (int)Math.floor(j / 7);
                        if (grid[column][row] == (state = expected.get(j)) || state == BoulderState.PLACEHOLDER) continue;
                        isRight = false;
                        break;
                    }
                    if (!isRight) continue;
                    roomVariant = i;
                    BoulderSolver.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "NEF detected boulder variant " + (roomVariant + 1) + "."));
                    break;
                }
                if (roomVariant == -2) {
                    BoulderSolver.mc.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "NEF couldn't detect the boulder variant."));
                }
            }
        }
    }

    public static enum BoulderState {
        EMPTY,
        FILLED,
        PLACEHOLDER;

    }

    public static enum Direction {
        FORWARD,
        BACKWARD,
        LEFT,
        RIGHT;

    }

    public static class BoulderPush {
        int x;
        int y;
        Direction direction;

        public BoulderPush(int x, int y, Direction direction) {
            this.x = x;
            this.y = y;
            this.direction = direction;
        }
    }
}

