/*
 * Decompiled with CFR 0.152.
 */
package org.ginafro.notenoughfakepixel.features.skyblock.dungeons.puzzles;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.ginafro.notenoughfakepixel.config.gui.Config;
import org.ginafro.notenoughfakepixel.envcheck.registers.RegisterEvents;
import org.ginafro.notenoughfakepixel.utils.TablistParser;
import org.lwjgl.opengl.GL11;

@RegisterEvents
public class CreeperSolver {
    static final int[] CREEPER_COLOURS = new int[]{-11473095, -3862255, -15520047, -15630547, -1223494, -1082099, -658089, -2694928, -9752645, -12976420};
    static boolean drawCreeperLines = false;
    static Vec3 creeperLocation = new Vec3(0.0, 0.0, 0.0);
    static List<Vec3[]> creeperLines = new ArrayList<Vec3[]>();
    private static int ticks = 0;
    private static final Set<BlockPos> usedEndBlocks = new HashSet<BlockPos>();

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        EntityPlayerSP player = mc.field_71439_g;
        if (++ticks % 20 == 0) {
            if (Config.feature.dungeons.dungeonsCreeper && TablistParser.currentLocation.isDungeon() && world != null && player != null) {
                double x = player.field_70165_t;
                double y = player.field_70163_u;
                double z = player.field_70161_v;
                AxisAlignedBB creeperScan = new AxisAlignedBB(x - 14.0, y - 8.0, z - 13.0, x + 14.0, y + 8.0, z + 13.0);
                List creepers = world.func_72872_a(EntityCreeper.class, creeperScan);
                if (!creepers.isEmpty() && !((EntityCreeper)creepers.get(0)).func_82150_aj()) {
                    EntityCreeper creeper = (EntityCreeper)creepers.get(0);
                    creeperLines.clear();
                    usedEndBlocks.clear();
                    if (!drawCreeperLines) {
                        creeperLocation = new Vec3(creeper.field_70165_t, creeper.field_70163_u + 1.0, creeper.field_70161_v);
                    }
                    drawCreeperLines = true;
                    BlockPos point1 = new BlockPos(creeper.field_70165_t - 14.0, creeper.field_70163_u - 7.0, creeper.field_70161_v - 13.0);
                    BlockPos point2 = new BlockPos(creeper.field_70165_t + 14.0, creeper.field_70163_u + 10.0, creeper.field_70161_v + 13.0);
                    Iterable blocks = BlockPos.func_177980_a((BlockPos)point1, (BlockPos)point2);
                    for (BlockPos blockPos : blocks) {
                        Vec3 startBlock;
                        BlockPos oppositeBlock;
                        BlockPos endBlock;
                        Block block = world.func_180495_p(blockPos).func_177230_c();
                        if (block != Blocks.field_180398_cJ && block != Blocks.field_180397_cI || (endBlock = CreeperSolver.getUniqueNearbyBlock(mc, oppositeBlock = CreeperSolver.getFirstBlockPosAfterVectors(mc, startBlock = new Vec3((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5), creeperLocation, 10, 20), Blocks.field_180398_cJ, Blocks.field_180397_cI)) == null || !(startBlock.field_72448_b > 68.0) || endBlock.func_177956_o() <= 68) continue;
                        Vec3[] insertArray = new Vec3[]{startBlock, new Vec3((double)endBlock.func_177958_n() + 0.5, (double)endBlock.func_177956_o() + 0.5, (double)endBlock.func_177952_p() + 0.5)};
                        creeperLines.add(insertArray);
                        usedEndBlocks.add(endBlock);
                    }
                } else {
                    drawCreeperLines = false;
                    usedEndBlocks.clear();
                }
            }
            ticks = 0;
        }
    }

    public static BlockPos getFirstBlockPosAfterVectors(Minecraft mc, Vec3 pos1, Vec3 pos2, int strength, int distance) {
        double x = pos2.field_72450_a - pos1.field_72450_a;
        double y = pos2.field_72448_b - pos1.field_72448_b;
        double z = pos2.field_72449_c - pos1.field_72449_c;
        for (int i = strength; i < distance * strength; ++i) {
            double newX = pos1.field_72450_a + x / (double)strength * (double)i;
            double newY = pos1.field_72448_b + y / (double)strength * (double)i;
            double newZ = pos1.field_72449_c + z / (double)strength * (double)i;
            BlockPos newBlock = new BlockPos(newX, newY, newZ);
            if (mc.field_71441_e.func_180495_p(newBlock).func_177230_c() == Blocks.field_150350_a) continue;
            return newBlock;
        }
        return null;
    }

    public static BlockPos getUniqueNearbyBlock(Minecraft mc, BlockPos pos, Block ... blockTypes) {
        if (pos == null) {
            return null;
        }
        BlockPos pos1 = new BlockPos(pos.func_177958_n() - 2, pos.func_177956_o() - 3, pos.func_177952_p() - 2);
        BlockPos pos2 = new BlockPos(pos.func_177958_n() + 2, pos.func_177956_o() + 3, pos.func_177952_p() + 2);
        BlockPos closestBlock = null;
        double closestBlockDistance = 99.0;
        Iterable blocks = BlockPos.func_177980_a((BlockPos)pos1, (BlockPos)pos2);
        for (BlockPos block : blocks) {
            for (Block blockType : blockTypes) {
                if (mc.field_71441_e.func_180495_p(block).func_177230_c() != blockType || usedEndBlocks.contains(block) || !(block.func_177951_i((Vec3i)pos) < closestBlockDistance)) continue;
                closestBlock = block;
                closestBlockDistance = block.func_177951_i((Vec3i)pos);
            }
        }
        return closestBlock;
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (Config.feature.dungeons.dungeonsCreeper && drawCreeperLines && !creeperLines.isEmpty()) {
            for (int i = 0; i < creeperLines.size(); ++i) {
                Vec3[] line = creeperLines.get(i);
                if (line == null || line.length < 2 || line[0] == null || line[1] == null) continue;
                Vec3 pos1 = line[0];
                Vec3 pos2 = line[1];
                int colour = CREEPER_COLOURS[i % CREEPER_COLOURS.length];
                CreeperSolver.drawFilled3DBox(new AxisAlignedBB(pos1.field_72450_a - 0.51, pos1.field_72448_b - 0.51, pos1.field_72449_c - 0.51, pos1.field_72450_a + 0.51, pos1.field_72448_b + 0.51, pos1.field_72449_c + 0.51), colour, true, true, event.partialTicks);
                CreeperSolver.drawFilled3DBox(new AxisAlignedBB(pos2.field_72450_a - 0.51, pos2.field_72448_b - 0.51, pos2.field_72449_c - 0.51, pos2.field_72450_a + 0.51, pos2.field_72448_b + 0.51, pos2.field_72449_c + 0.51), colour, true, true, event.partialTicks);
            }
        }
    }

    public static void drawFilled3DBox(AxisAlignedBB aabb, int colourInt, boolean translucent, boolean depth, float partialTicks) {
        Entity render = Minecraft.func_71410_x().func_175606_aa();
        WorldRenderer worldRenderer = Tessellator.func_178181_a().func_178180_c();
        Color colour = new Color(colourInt);
        double realX = render.field_70142_S + (render.field_70165_t - render.field_70142_S) * (double)partialTicks;
        double realY = render.field_70137_T + (render.field_70163_u - render.field_70137_T) * (double)partialTicks;
        double realZ = render.field_70136_U + (render.field_70161_v - render.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179137_b((double)(-realX), (double)(-realY), (double)(-realZ));
        GlStateManager.func_179090_x();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179120_a((int)770, (int)(translucent ? 1 : 771), (int)1, (int)0);
        if (!depth) {
            GL11.glDisable((int)2929);
            GlStateManager.func_179132_a((boolean)false);
        }
        GlStateManager.func_179131_c((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)0.5f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179137_b((double)realX, (double)realY, (double)realZ);
        if (!depth) {
            GL11.glEnable((int)2929);
            GlStateManager.func_179132_a((boolean)true);
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }
}

